/*
 * Decompiled with CFR 0.152.
 */
package org.monazilla.v2c;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.EtchedBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.MouseInputAdapter;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import org.monazilla.v2c.V2CAbstractAction;
import org.monazilla.v2c.V2CAction;
import org.monazilla.v2c.V2CApp;
import org.monazilla.v2c.V2CGestureMap;
import org.monazilla.v2c.V2CGestureMapConstants;
import org.monazilla.v2c.V2CMiscUtil;
import org.monazilla.v2c.V2CSwingUtil;
import org.monazilla.v2c.V2CTextChangeListener;

public class V2CGestureMapSP
extends JPanel
implements V2CGestureMapConstants,
ActionListener {
    private static int iSelectedTableIndex;
    private static int iSBValue;
    static final String[] slColNames;
    final boolean bUseGesture;
    final boolean bUseLeftButton = V2CGestureMap.getUseLeftButton();
    boolean bUseGesture0;
    boolean bTmpUseLeftButton;
    V2CGestureMap[] vgmlGestureMaps;
    V2CGestureMap gmCurrentGestureMap;
    JCheckBox jcbUseGesture;
    JCheckBox jcbUseRightButton;
    JComboBox jcbComponent;
    JTextField jtfFilter;
    String sLastFilterWords;
    ActionTableModel tmAction;
    JTable jtActions;
    JScrollPane jScrollPane;
    Color cFG;
    JComboBox jcbThreshold;
    JPanel jpStart;
    JTextField jtfGestureString;
    JButton jbSet;
    JButton jbAdd;
    JButton jbClear;
    JLabel jlStatus;
    boolean bChanged;

    static {
        slColNames = new String[]{"\u30b8\u30a7\u30b9\u30c1\u30e3", "\u30a2\u30af\u30b7\u30e7\u30f3"};
    }

    public V2CGestureMapSP(V2CGestureMap[] av2cgesturemap, int i) {
        super(new GridBagLayout());
        JLabel jlabel;
        Insets insets;
        JScrollPane jscrollpane;
        JTable jtable;
        JTextField jtextfield;
        JComboBox jcombobox;
        this.vgmlGestureMaps = av2cgesturemap;
        this.sLastFilterWords = "";
        this.bUseGesture = this.bUseGesture0 = V2CGestureMap.getUseGesture();
        GridBagConstraints gridbagconstraints = V2CSwingUtil.createGridBagConstraints();
        gridbagconstraints.insets = new Insets(3, 3, 3, 3);
        this.jcbUseGesture = V2CSwingUtil.addCheckBox("\u30de\u30a6\u30b9\u30b8\u30a7\u30b9\u30c1\u30e3\u3092\u4f7f\u7528\u3059\u308b", this.bUseGesture, this, gridbagconstraints, true);
        this.jcbUseGesture.addActionListener(this);
        if (V2CApp.isMacintosh()) {
            this.jcbUseRightButton = new JCheckBox("\u30de\u30a6\u30b9\u306e\u53f3\u30dc\u30bf\u30f3\u3092\u4f7f\u7528\u3059\u308b", !this.bUseLeftButton);
            this.jcbUseRightButton.setFocusable(false);
            this.add((Component)this.jcbUseRightButton, gridbagconstraints);
            ++gridbagconstraints.gridy;
        }
        this.jcbComponent = jcombobox = V2CSwingUtil.createComboBox(av2cgesturemap);
        jcombobox.setFocusable(false);
        jcombobox.setMaximumRowCount(20);
        jcombobox.addActionListener(this);
        gridbagconstraints.weightx = 1.0;
        this.add((Component)jcombobox, gridbagconstraints);
        gridbagconstraints.anchor = 13;
        this.jtfFilter = jtextfield = V2CSwingUtil.createTextField(6);
        new FilterListener();
        this.add((Component)jtextfield, gridbagconstraints);
        gridbagconstraints.gridx = 0;
        gridbagconstraints.anchor = 10;
        ++gridbagconstraints.gridy;
        this.tmAction = new ActionTableModel();
        this.jtActions = jtable = new JTable(this.tmAction);
        jtable.setSelectionMode(0);
        jtable.setColumnSelectionAllowed(false);
        jtable.getColumnModel().getColumn(slColNames.length - 1).setCellRenderer(new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable jtable1, Object obj, boolean flag, boolean flag1, int k, int l) {
                Component component = super.getTableCellRendererComponent(jtable1, obj, flag, flag1, k, l);
                component.setForeground(k >= V2CGestureMapSP.this.tmAction.nFiltered ? V2CGestureMapSP.this.cFG : Color.RED);
                return component;
            }
        });
        this.jScrollPane = jscrollpane = V2CSwingUtil.createScrollPaneForTable(jtable, 200);
        gridbagconstraints.fill = 1;
        gridbagconstraints.weightx = 1.0;
        gridbagconstraints.weighty = 1.0;
        this.add((Component)jscrollpane, gridbagconstraints);
        gridbagconstraints.weightx = 0.0;
        gridbagconstraints.weighty = 0.0;
        gridbagconstraints.fill = 0;
        ++gridbagconstraints.gridy;
        JPanel jpanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridbagconstraints1 = new GridBagConstraints();
        gridbagconstraints1.gridx = 0;
        gridbagconstraints1.gridy = 0;
        gridbagconstraints1.insets = insets = new Insets(4, 2, 4, 2);
        jpanel.add((Component)new JLabel("\u95be\u8ddd\u96e2\uff1a"), gridbagconstraints1);
        ++gridbagconstraints1.gridx;
        Object[] as = new String[19];
        int j = 0;
        while (j < as.length) {
            as[j] = String.valueOf(j * 5 + 10);
            ++j;
        }
        this.jcbThreshold = V2CSwingUtil.createComboBox(as);
        this.jcbThreshold.setSelectedIndex(V2CMiscUtil.restrictRange(0, (V2CGestureMap.nThreshold - 10) / 5, as.length - 1));
        this.jcbThreshold.addActionListener(this);
        this.jcbThreshold.setFocusable(false);
        gridbagconstraints1.insets = new Insets(4, 2, 4, 20);
        jpanel.add((Component)this.jcbThreshold, gridbagconstraints1);
        gridbagconstraints1.insets = insets;
        ++gridbagconstraints1.gridx;
        this.jpStart = new JPanel();
        this.jpStart.setBackground(Color.WHITE);
        Dimension dimension = new Dimension(i, i);
        this.jpStart.setPreferredSize(dimension);
        this.jpStart.setMinimumSize(dimension);
        this.jpStart.setBorder(new EtchedBorder(1));
        GestureListener gesturelistener = new GestureListener();
        this.jpStart.addMouseListener(gesturelistener);
        this.jpStart.addMouseMotionListener(gesturelistener);
        this.jpStart.addMouseWheelListener(gesturelistener);
        jpanel.add((Component)this.jpStart, gridbagconstraints1);
        ++gridbagconstraints1.gridx;
        this.jtfGestureString = new JTextField(15);
        this.jtfGestureString.setFocusable(false);
        this.jtfGestureString.setEditable(false);
        gridbagconstraints1.weightx = 1.0;
        gridbagconstraints1.fill = 2;
        jpanel.add((Component)this.jtfGestureString, gridbagconstraints1);
        gridbagconstraints1.weightx = 0.0;
        gridbagconstraints1.fill = 0;
        ++gridbagconstraints1.gridx;
        this.jbSet = this.createButton("\u8a2d\u5b9a", jpanel, gridbagconstraints1);
        this.jbAdd = this.createButton("\u8ffd\u52a0", jpanel, gridbagconstraints1);
        this.jbClear = this.createButton("\u524a\u9664", jpanel, gridbagconstraints1);
        gridbagconstraints.fill = 2;
        this.add((Component)jpanel, gridbagconstraints);
        ++gridbagconstraints.gridy;
        this.jlStatus = jlabel = new JLabel("\u8a2d\u5b9a\u7121\u3057");
        gridbagconstraints.fill = 0;
        this.add((Component)jlabel, gridbagconstraints);
        this.jcbComponent.setSelectedIndex(iSelectedTableIndex);
    }

    private JButton createButton(String s, JPanel jpanel, GridBagConstraints gridbagconstraints) {
        JButton jbutton = new JButton(s);
        jbutton.setFocusable(false);
        jbutton.addActionListener(this);
        jpanel.add((Component)jbutton, gridbagconstraints);
        ++gridbagconstraints.gridx;
        return jbutton;
    }

    void gestureMapSelectionChanged() {
        int i = this.jcbComponent.getSelectedIndex();
        if (i < 0 || i >= slGestureMapName.length) {
            return;
        }
        this.gmCurrentGestureMap = this.vgmlGestureMaps[i];
        this.tmAction.setActions(V2CAction.getGestureActionsToConfigure(i));
        this.updateStatus();
    }

    private void updateStatus() {
        String s = "\u8a2d\u5b9a\u7121\u3057";
        String s1 = this.jtfGestureString.getText();
        if (s1.length() > 0) {
            Iterator iterator = this.gmCurrentGestureMap.getKeyIterator();
            while (iterator.hasNext()) {
                V2CAbstractAction v2cabstractaction;
                if (!s1.equals(iterator.next())) continue;
                Object obj = this.gmCurrentGestureMap.get(s1);
                if (!(obj instanceof String) || (v2cabstractaction = V2CAction.getAction((String)obj)) == null) break;
                s = v2cabstractaction.toString();
                break;
            }
        }
        this.jlStatus.setText(s);
    }

    void setGesture(boolean flag) {
        String s1;
        String s = this.jtfGestureString.getText();
        if (s == null || s.length() == 0) {
            return;
        }
        int i = this.jtActions.getSelectedRow();
        if (i < 0) {
            return;
        }
        V2CAbstractAction v2cabstractaction = this.tmAction.getAction(i);
        if (v2cabstractaction == null) {
            return;
        }
        Iterator iterator = this.gmCurrentGestureMap.getKeyIterator();
        while (iterator.hasNext()) {
            if (!s.equals(iterator.next())) continue;
            Toolkit.getDefaultToolkit().beep();
            return;
        }
        if (!flag && (s1 = this.tmAction.getGesture(i)) != null) {
            this.gmCurrentGestureMap.remove(s1);
        }
        this.gmCurrentGestureMap.put(s, v2cabstractaction.getName());
        this.tmAction.gestureChanged(i, s, flag);
        this.bChanged = true;
        if (!this.bUseGesture0 && !this.jcbUseGesture.isSelected()) {
            this.bUseGesture0 = true;
            this.jcbUseGesture.setSelected(true);
        }
    }

    void clearGesture() {
        int i = this.jtActions.getSelectedRow();
        if (i < 0) {
            return;
        }
        V2CAbstractAction v2cabstractaction = this.tmAction.getAction(i);
        if (v2cabstractaction == null) {
            return;
        }
        String s = this.tmAction.getGesture(i);
        if (s != null) {
            this.gmCurrentGestureMap.remove(s);
        }
        this.tmAction.clearGesture(i);
        this.bChanged = true;
    }

    int getThreshold() {
        return this.jcbThreshold.getSelectedIndex() * 5 + 10;
    }

    @Override
    public void actionPerformed(ActionEvent actionevent) {
        Object obj = actionevent.getSource();
        if (obj == this.jcbUseGesture) {
            this.bUseGesture0 = true;
        } else if (obj == this.jcbComponent) {
            this.gestureMapSelectionChanged();
        } else if (obj == this.jbSet) {
            this.setGesture(false);
        } else if (obj == this.jbAdd) {
            this.setGesture(true);
        } else if (obj == this.jbClear) {
            this.clearGesture();
        } else if (obj == this.jcbThreshold) {
            int i = this.getThreshold();
            Dimension dimension = new Dimension(i, i);
            this.jpStart.setPreferredSize(dimension);
            this.jpStart.setMinimumSize(dimension);
            this.revalidate();
        }
    }

    void preShowDialog() {
        int i = iSBValue;
        if (i > 0) {
            this.scrollLater(i);
        }
    }

    private void scrollLater(final int iv) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JScrollBar jscrollbar = V2CGestureMapSP.this.jScrollPane.getVerticalScrollBar();
                if (jscrollbar != null) {
                    jscrollbar.setValue(iv);
                }
            }
        });
    }

    void postShowDialog() {
        JScrollBar jscrollbar;
        int i = this.jcbComponent.getSelectedIndex();
        if (i >= 0 && i < slGestureMapName.length) {
            iSelectedTableIndex = i;
        }
        if ((jscrollbar = this.jScrollPane.getVerticalScrollBar()) != null) {
            iSBValue = jscrollbar.getValue();
        }
    }

    boolean isChanged() {
        return this.bChanged;
    }

    boolean getUseGesture() {
        return this.jcbUseGesture.isSelected();
    }

    boolean getUseLeftButton() {
        if (this.jcbUseRightButton != null) {
            return !this.jcbUseRightButton.isSelected();
        }
        return false;
    }

    private class ActionTableModel
    extends AbstractTableModel {
        int nColumns = slColNames.length;
        V2CAbstractAction[] vlAbstractActions;
        ArrayList vActions = new ArrayList();
        boolean bImagePopup;
        int nFiltered;

        void filterActions() {
            this.setActions(this.vlAbstractActions);
            V2CGestureMapSP.this.scrollLater(0);
        }

        void setActions(V2CAbstractAction[] aal) {
            this.vlAbstractActions = aal;
            try {
                this.bImagePopup = V2CGestureMapSP.this.gmCurrentGestureMap.getName().equals("ImagePopup");
                this.vActions.clear();
                if (aal == null || aal.length == 0) {
                    return;
                }
                String s = V2CMiscUtil.normalizeCase(V2CGestureMapSP.this.sLastFilterWords);
                ArrayList<Object[]> arraylist = new ArrayList<Object[]>();
                int i = 0;
                while (i < aal.length) {
                    V2CAbstractAction obj = aal[i];
                    Object[] aobj = new Object[this.nColumns + 1];
                    aobj[this.nColumns - 1] = obj;
                    String obj1 = V2CMiscUtil.normalizeCase(obj.toString());
                    if (s.length() > 0 && obj1.indexOf(s) >= 0) {
                        arraylist.add(aobj);
                    } else {
                        this.vActions.add(aobj);
                    }
                    ++i;
                }
                this.nFiltered = arraylist.size();
                this.vActions.addAll(0, arraylist);
                Iterator iterator = V2CGestureMapSP.this.gmCurrentGestureMap.getKeyIterator();
                block5: while (iterator.hasNext()) {
                    V2CAbstractAction aa;
                    String s1 = (String)iterator.next();
                    String s2 = (String)V2CGestureMapSP.this.gmCurrentGestureMap.get(s1);
                    if (s2 == null || (aa = V2CAction.getAction(s2)) == null) continue;
                    int i2 = this.vActions.size() - 1;
                    while (i2 >= 0) {
                        if ((V2CAbstractAction)((Object[])this.vActions.get(i2))[this.nColumns - 1] == aa) {
                            this.setGesture(i2, s1, true);
                            continue block5;
                        }
                        --i2;
                    }
                }
            }
            finally {
                this.fireTableDataChanged();
            }
        }

        private void setGesture(int i, String s, boolean flag) {
            if (s == null) {
                return;
            }
            Object[] aobj = (Object[])this.vActions.get(i);
            if (flag && aobj[this.nColumns] != null) {
                Object obj = aobj[this.nColumns - 1];
                aobj = new Object[this.nColumns + 1];
                this.vActions.add(i + 1, aobj);
                aobj[this.nColumns - 1] = obj;
                if (i < this.nFiltered) {
                    ++this.nFiltered;
                }
            } else {
                int j = 0;
                while (j < this.nColumns - 1) {
                    aobj[j] = null;
                    ++j;
                }
            }
            aobj[this.nColumns] = s;
            aobj[0] = s;
        }

        void gestureChanged(int i, String s, boolean flag) {
            int j = this.vActions.size();
            this.setGesture(i, s, flag);
            if (this.vActions.size() == j) {
                this.fireTableRowsUpdated(i, i);
            } else if (this.vActions.size() == j + 1) {
                this.fireTableRowsInserted(i + 1, i + 1);
            }
        }

        void clearGesture(int i) {
            Object[] aobj = (Object[])this.vActions.get(i);
            aobj[this.nColumns] = null;
            int j = 0;
            while (j < this.nColumns - 1) {
                aobj[j] = null;
                ++j;
            }
            V2CAbstractAction v2cabstractaction = (V2CAbstractAction)aobj[this.nColumns - 1];
            boolean flag = false;
            if (i > 0) {
                Object[] aobj1 = (Object[])this.vActions.get(i - 1);
                boolean bl = flag = v2cabstractaction == aobj1[this.nColumns - 1];
            }
            if (!flag && i < this.vActions.size() - 1) {
                Object[] aobj2 = (Object[])this.vActions.get(i + 1);
                boolean bl = flag = v2cabstractaction == aobj2[this.nColumns - 1];
            }
            if (flag) {
                this.vActions.remove(i);
                if (i < this.nFiltered) {
                    --this.nFiltered;
                }
                this.fireTableRowsDeleted(i, i);
            } else {
                this.fireTableRowsUpdated(i, i);
            }
        }

        V2CAbstractAction getAction(int i) {
            if (i < 0 || i >= this.vActions.size()) {
                return null;
            }
            return (V2CAbstractAction)((Object[])this.vActions.get(i))[this.nColumns - 1];
        }

        String getGesture(int i) {
            if (i < 0 || i >= this.vActions.size()) {
                return null;
            }
            return (String)((Object[])this.vActions.get(i))[this.nColumns];
        }

        @Override
        public int getRowCount() {
            return this.vActions.size();
        }

        @Override
        public int getColumnCount() {
            return this.nColumns;
        }

        @Override
        public String getColumnName(int i) {
            return slColNames[i];
        }

        @Override
        public Object getValueAt(int i, int j) {
            return ((Object[])this.vActions.get(i))[j];
        }

        private ActionTableModel() {
        }
    }

    private class FilterListener
    extends V2CTextChangeListener {
        @Override
        public void changedUpdate(DocumentEvent documentevent) {
            if (this.isComposing()) {
                return;
            }
            V2CGestureMapSP.this.sLastFilterWords = V2CGestureMapSP.this.jtfFilter.getText();
            V2CGestureMapSP.this.tmAction.filterActions();
        }

        FilterListener() {
            super(V2CGestureMapSP.this.jtfFilter);
        }
    }

    private class GestureListener
    extends MouseInputAdapter
    implements MouseWheelListener {
        int nGestureCount;
        boolean bInGesture;

        @Override
        public void mouseDragged(MouseEvent mouseevent) {
            if (!this.bInGesture) {
                return;
            }
            if (!V2CGestureMapSP.this.gmCurrentGestureMap.mouseDragged(mouseevent)) {
                this.bInGesture = false;
                V2CGestureMapSP.this.jtfGestureString.setText("");
                return;
            }
            if (V2CGestureMap.getCurrentStrokeCount() <= this.nGestureCount) {
                return;
            }
            V2CGestureMapSP.this.jtfGestureString.setText(String.valueOf(V2CGestureMap.getCurrentGestureString(false)) + " <");
        }

        @Override
        public void mousePressed(MouseEvent mouseevent) {
            int i = mouseevent.getButton();
            if (this.bInGesture) {
                this.bInGesture = false;
                String s = V2CGestureMap.getCurrentGestureString(true);
                if (!V2CGestureMapSP.this.bTmpUseLeftButton && (i == 1 || i == 2 || i >= 4 && i <= 7)) {
                    String s2;
                    switch (i) {
                        case 1: {
                            s2 = "L";
                            break;
                        }
                        case 2: {
                            s2 = "M";
                            break;
                        }
                        case 4: {
                            s2 = "W\u2190";
                            break;
                        }
                        case 5: {
                            s2 = "W\u2192";
                            break;
                        }
                        case 6: {
                            s2 = "X1";
                            break;
                        }
                        case 7: {
                            s2 = "X2";
                            break;
                        }
                        default: {
                            s2 = "";
                        }
                    }
                    s = String.valueOf(s) + s2;
                }
                V2CGestureMapSP.this.jtfGestureString.setText(s);
                this.endGesture();
            } else if (i == 6 || i == 7) {
                String s1;
                String string = s1 = i != 6 ? "x2" : "x1";
                if ((mouseevent.getModifiersEx() & 0x40) != 0) {
                    s1 = String.valueOf('S') + s1;
                }
                V2CGestureMapSP.this.jtfGestureString.setText(s1);
                this.endGesture();
            } else {
                if (!V2CGestureMapSP.this.bUseGesture) {
                    V2CGestureMap.setUseGesture(true);
                }
                if (V2CGestureMapSP.this.jcbUseRightButton != null) {
                    boolean bl = V2CGestureMapSP.this.bTmpUseLeftButton = !V2CGestureMapSP.this.jcbUseRightButton.isSelected();
                    if (V2CGestureMapSP.this.bTmpUseLeftButton != V2CGestureMapSP.this.bUseLeftButton) {
                        V2CGestureMap.setUseLeftButton(V2CGestureMapSP.this.bTmpUseLeftButton);
                    }
                }
                V2CGestureMapSP.this.gmCurrentGestureMap.mousePressed(mouseevent, true);
                if (!V2CGestureMap.isInGesture()) {
                    return;
                }
                V2CGestureMapSP.this.jtfGestureString.setText(" <");
                this.bInGesture = true;
                this.nGestureCount = 0;
                V2CGestureMap.setFromSettingPanel(true);
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseevent) {
            if (!this.bInGesture) {
                return;
            }
            this.bInGesture = false;
            V2CGestureMapSP.this.jtfGestureString.setText(V2CGestureMap.getCurrentGestureString(false));
            this.endGesture();
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent mousewheelevent) {
            if (!this.bInGesture) {
                return;
            }
            this.bInGesture = false;
            StringBuffer stringbuffer = new StringBuffer();
            if (V2CGestureMap.bShiftDown) {
                stringbuffer.append('S');
            }
            if (V2CGestureMapSP.this.gmCurrentGestureMap.mouseWheelMoved(mousewheelevent)) {
                stringbuffer.append('W');
                stringbuffer.append(mousewheelevent.getUnitsToScroll() < 0 ? (char)'\u2191' : '\u2193');
            }
            V2CGestureMapSP.this.jtfGestureString.setText(stringbuffer.toString());
            this.endGesture();
        }

        private void endGesture() {
            if (V2CGestureMap.isInGesture()) {
                V2CGestureMap.endGesture();
            }
            if (!V2CGestureMapSP.this.bUseGesture) {
                V2CGestureMap.setUseGesture(false);
            }
            if (V2CGestureMapSP.this.jcbUseRightButton != null && V2CGestureMapSP.this.bTmpUseLeftButton != V2CGestureMapSP.this.bUseLeftButton) {
                V2CGestureMap.setUseLeftButton(V2CGestureMapSP.this.bUseLeftButton);
            }
            V2CGestureMap.setFromSettingPanel(false);
            V2CGestureMapSP.this.updateStatus();
        }

        private GestureListener() {
        }
    }
}

