/*
 * Decompiled with CFR 0.152.
 */
package org.monazilla.v2c;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.monazilla.v2c.V2CAbstractAction;
import org.monazilla.v2c.V2CAction;
import org.monazilla.v2c.V2CActionMap;
import org.monazilla.v2c.V2CApp;
import org.monazilla.v2c.V2CClassStateSaver;
import org.monazilla.v2c.V2CGestureActionEvent;
import org.monazilla.v2c.V2CGestureMapConstants;
import org.monazilla.v2c.V2CGestureMapSP;
import org.monazilla.v2c.V2CImagePopup;
import org.monazilla.v2c.V2CJStr;
import org.monazilla.v2c.V2CLocalFileHandler;
import org.monazilla.v2c.V2CMain;
import org.monazilla.v2c.V2CMiscUtil;
import org.monazilla.v2c.V2CMouseSP;
import org.monazilla.v2c.V2CProperty;
import org.monazilla.v2c.V2CSaveFile;

public class V2CGestureMap
extends HashMap
implements V2CGestureMapConstants {
    private static final String sSaveFile = "gesture.txt";
    static final String sKeyPrefix = "Gesture.";
    static final String sUseGestureKey = "Gesture.Enabled";
    static final String sUseLeftButtonKey = "Gesture.UseLeftButton";
    static final String sThresholdKey = "Gesture.Threshold";
    static final String GLOBAL;
    static final String THREADVIEW = "ThreadView";
    static final String IMAGEPOPUP = "ImagePopup";
    static final String TABBEDPANE = "TabbedPane";
    static final String WRITE = "Write";
    static final String OTHER = "Other";
    static final char MOVE_UP = '\u2191';
    static final char MOVE_LEFT = '\u2190';
    static final char MOVE_DOWN = '\u2193';
    static final char MOVE_RIGHT = '\u2192';
    static final HashMap hmGestureMaps;
    static V2CGestureMap[] vgmlGestureMaps;
    static V2CGestureMap gmGlobal;
    static boolean bUseGesture;
    static boolean bUseLeftButton;
    private static final int nDefThreshold = 30;
    static int nThreshold;
    static final ClassStateSaver classStateSaver;
    static boolean bInGesture;
    static boolean bNoGesture;
    static boolean bPointerMoved;
    static boolean bShiftDown;
    static boolean bWheelRotating;
    static boolean bLeftClicking;
    static boolean bFromSettingPanel;
    static int iX;
    static int iY;
    static int iX0;
    static int iY0;
    static int nLastStroke;
    static Point pStart;
    static char cLastDir;
    static Component cmpGesture;
    static final StringBuffer sbGestureBuffer;
    static final Timer tmCancelTimer;
    String sName;
    String sLabel;
    int iIndex;
    private boolean bGlobal;
    private final int STROKE_FACTOR = 30;

    static {
        hmGestureMaps = new HashMap();
        classStateSaver = new ClassStateSaver(60);
        sbGestureBuffer = new StringBuffer();
        GLOBAL = slGestureMapName[0];
        V2CProperty v2cproperty = V2CMain.getUserProperty();
        bUseGesture = v2cproperty.getBoolean(sUseGestureKey, false);
        if (V2CApp.isMacintosh()) {
            bUseLeftButton = v2cproperty.getBoolean(sUseLeftButtonKey, true);
        }
        nThreshold = V2CMiscUtil.restrictRange(10, v2cproperty.getInt(sThresholdKey, 30), 100);
        vgmlGestureMaps = new V2CGestureMap[slGestureMapName.length];
        tmCancelTimer = new Timer(1000, new GestureCancelAction());
        tmCancelTimer.setRepeats(false);
    }

    private static String decodeStroke(String s) {
        if (s == null) {
            return null;
        }
        int i = s.length();
        if (i == 1 || i == 2 && s.charAt(0) == 'S') {
            String s1;
            char c = s.charAt(i - 1);
            String string = s1 = i != 1 ? "SW" : "W";
            if (c == 'u') {
                return String.valueOf(s1) + '\u2191';
            }
            if (c == 'd') {
                return String.valueOf(s1) + '\u2193';
            }
            if (c == 'l') {
                return String.valueOf(s1) + '\u2190';
            }
            if (c == 'r') {
                return String.valueOf(s1) + '\u2192';
            }
        }
        boolean flag = false;
        StringBuffer stringbuffer = new StringBuffer();
        int j = 0;
        while (j < i) {
            char c1 = s.charAt(j);
            if (c1 == 'U') {
                stringbuffer.append('\u2191');
            } else if (c1 == 'L') {
                stringbuffer.append('\u2190');
            } else if (c1 == 'D') {
                stringbuffer.append('\u2193');
            } else if (c1 == 'R') {
                stringbuffer.append('\u2192');
            } else if (c1 == 'S') {
                if (j > 0 || i <= 1) {
                    return null;
                }
                stringbuffer.append('S');
            } else {
                if (c1 == '1') {
                    stringbuffer.append('L');
                    break;
                }
                if (c1 == '2') {
                    stringbuffer.append('M');
                    break;
                }
                if (c1 == '6') {
                    stringbuffer.append(flag ? "x1" : "X1");
                    break;
                }
                if (c1 == '7') {
                    stringbuffer.append(flag ? "x2" : "X2");
                    break;
                }
                if (c1 == '-') {
                    flag = true;
                } else {
                    return null;
                }
            }
            ++j;
        }
        return stringbuffer.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String encodeStroke(String s) {
        if (s == null) {
            return null;
        }
        int i = s.length();
        if (i == 2 && s.charAt(0) == 'W' || i == 3 && s.charAt(0) == 'S' && s.charAt(1) == 'W') {
            char c = s.charAt(i - 1);
            if (c == '\u2191') {
                if (i == 2) return "u";
                return "Su";
            }
            if (c == '\u2193') {
                if (i == 2) return "d";
                return "Sd";
            }
            if (c == '\u2190') {
                if (i == 2) return "l";
                return "Sl";
            }
            if (c != '\u2192') return null;
            if (i == 2) return "r";
            return "Sr";
        }
        StringBuffer stringbuffer = new StringBuffer();
        int j = 0;
        while (j < i) {
            char c1 = s.charAt(j);
            if (c1 == '\u2191') {
                stringbuffer.append('U');
            } else if (c1 == '\u2190') {
                stringbuffer.append('L');
            } else if (c1 == '\u2193') {
                stringbuffer.append('D');
            } else if (c1 == '\u2192') {
                stringbuffer.append('R');
            } else if (c1 == 'S') {
                if (j > 0) return null;
                if (i <= 1) {
                    return null;
                }
                stringbuffer.append('S');
            } else if (c1 == 'L') {
                if (j < i - 1) {
                    return null;
                }
                stringbuffer.append('1');
            } else if (c1 == 'M') {
                if (j < i - 1) {
                    return null;
                }
                stringbuffer.append('2');
            } else {
                char c2;
                if (c1 != 'X') {
                    if (c1 != 'x') return null;
                }
                if (j != i - 2) {
                    return null;
                }
                if (c1 == 'x') {
                    stringbuffer.append('-');
                }
                if ((c2 = s.charAt(++j)) == '1') {
                    stringbuffer.append('6');
                } else {
                    if (c2 != '2') return null;
                    stringbuffer.append('7');
                }
            }
            ++j;
        }
        return stringbuffer.toString();
    }

    static void checkThumbnailGesture() {
        V2CGestureMap localV2CGestureMap1 = vgmlGestureMaps[9];
        V2CGestureMap localV2CGestureMap2 = vgmlGestureMaps[6];
        if (localV2CGestureMap1 == null || localV2CGestureMap2 == null) {
            return;
        }
        boolean i = false;
        String[] arrayOfString = new String[]{"DisableLink", "DeleteLinkCache", "SaveImageSilent", "ShowQuickImageSaveMenu", "ShowImageProperty"};
        block0: for (String str1 : localV2CGestureMap1.keySet()) {
            String str2 = (String)localV2CGestureMap1.get(str1);
            if (str2 == null) continue;
            int j = 0;
            while (j < arrayOfString.length) {
                if (str2.equals(arrayOfString[j])) {
                    localV2CGestureMap2.put(str1, str2);
                    i = true;
                    continue block0;
                }
                ++j;
            }
        }
        if (i) {
            classStateSaver.requestSave();
        }
    }

    static void endGesture() {
        bInGesture = false;
        V2CGestureMap.restoreCursor();
        V2CMain.endTempMessage(V2CGestureMap.class);
    }

    private static void restoreCursor() {
        if (cmpGesture != null) {
            cmpGesture.setCursor(Cursor.getDefaultCursor());
        }
    }

    static V2CGestureMap getGestureMap(int i) {
        V2CGestureMap[] av2cgesturemap = vgmlGestureMaps;
        return i < 0 || i >= av2cgesturemap.length ? null : av2cgesturemap[i];
    }

    static V2CGestureMap getGestureMap(String s) {
        V2CGestureMap v2cgesturemap = (V2CGestureMap)hmGestureMaps.get(s);
        if (v2cgesturemap == null) {
            v2cgesturemap = new V2CGestureMap(s);
            hmGestureMaps.put(s, v2cgesturemap);
        }
        return v2cgesturemap;
    }

    static boolean getUseGesture() {
        return bUseGesture;
    }

    static void setUseGesture(boolean flag) {
        bUseGesture = flag;
    }

    static void setFromSettingPanel(boolean flag) {
        bFromSettingPanel = flag;
    }

    static boolean hasPointerMoved() {
        return bPointerMoved;
    }

    static boolean getUseLeftButton() {
        return bUseLeftButton;
    }

    static void setUseLeftButton(boolean flag) {
        bUseLeftButton = flag;
    }

    static boolean isInGesture() {
        return bInGesture;
    }

    static void restoreGestureMap() {
        block10: {
            BufferedReader bufferedreader = V2CLocalFileHandler.getUserSaveFileReader(sSaveFile);
            if (bufferedreader == null) {
                System.out.println("cannot read gesture.txt !");
                return;
            }
            try {
                try {
                    String s;
                    V2CGestureMap v2cgesturemap = null;
                    while ((s = bufferedreader.readLine()) != null) {
                        String[] as;
                        int j;
                        if (s.length() == 0 || s.charAt(0) == '#' || (j = (as = V2CMiscUtil.split(s)).length) != 2) continue;
                        if (as[0].equals("Map")) {
                            v2cgesturemap = new V2CGestureMap(as[1]);
                            hmGestureMaps.put(as[1], v2cgesturemap);
                            continue;
                        }
                        if (v2cgesturemap == null) continue;
                        v2cgesturemap.put(V2CGestureMap.decodeStroke(as[0]), as[1]);
                    }
                }
                catch (IOException ioexception) {
                    System.out.println(ioexception.getMessage());
                    V2CLocalFileHandler.closeReader(bufferedreader);
                    break block10;
                }
            }
            catch (Throwable throwable) {
                V2CLocalFileHandler.closeReader(bufferedreader);
                throw throwable;
            }
            V2CLocalFileHandler.closeReader(bufferedreader);
        }
        int i = 0;
        while (i < vgmlGestureMaps.length) {
            V2CGestureMap v2cgesturemap1 = V2CGestureMap.getGestureMap(slGestureMapName[i]);
            if (v2cgesturemap1 == null) {
                v2cgesturemap1 = new V2CGestureMap(slGestureMapName[i]);
            }
            V2CGestureMap.vgmlGestureMaps[i] = v2cgesturemap1;
            v2cgesturemap1.sLabel = V2CJStr.slGestureMapLabels[i];
            v2cgesturemap1.iIndex = i++;
        }
        gmGlobal = V2CGestureMap.getGestureMap(GLOBAL);
        V2CGestureMap.gmGlobal.bGlobal = true;
    }

    private static void saveGestureMap() {
        V2CSaveFile v2csavefile;
        block9: {
            v2csavefile = new V2CSaveFile(sSaveFile);
            BufferedWriter bufferedwriter = v2csavefile.getWriter();
            if (bufferedwriter == null) {
                return;
            }
            try {
                try {
                    int i = 0;
                    while (i < slGestureMapName.length) {
                        V2CGestureMap v2cgesturemap = vgmlGestureMaps[i];
                        if (v2cgesturemap != null && v2cgesturemap.size() != 0) {
                            bufferedwriter.write("Map,");
                            bufferedwriter.write(slGestureMapName[i]);
                            bufferedwriter.newLine();
                            Set set = v2cgesturemap.keySet();
                            for (String s : set) {
                                String s2;
                                String s1;
                                if (s == null || s.length() == 0 || (s1 = (String)v2cgesturemap.get(s)) == null || s1.length() == 0 || (s2 = V2CGestureMap.encodeStroke(s)) == null) continue;
                                bufferedwriter.write(s2);
                                bufferedwriter.write(44);
                                bufferedwriter.write(s1);
                                bufferedwriter.newLine();
                            }
                            bufferedwriter.newLine();
                        }
                        ++i;
                    }
                    v2csavefile.setOK();
                }
                catch (IOException iOException) {
                    V2CLocalFileHandler.closeWriter(bufferedwriter);
                    break block9;
                }
            }
            catch (Throwable throwable) {
                V2CLocalFileHandler.closeWriter(bufferedwriter);
                throw throwable;
            }
            V2CLocalFileHandler.closeWriter(bufferedwriter);
        }
        v2csavefile.replaceTmpFile();
    }

    public static JPanel getConfPanel() {
        V2CMouseSP v2cmousesp = new V2CMouseSP(vgmlGestureMaps, nThreshold);
        v2cmousesp.preShowPanel();
        return v2cmousesp;
    }

    static void showSettingPanel() {
        V2CMouseSP v2cmousesp = new V2CMouseSP(vgmlGestureMaps, nThreshold);
        v2cmousesp.showDialog();
        V2CGestureMap.applyChanges(v2cmousesp, false);
    }

    static void applyChanges(V2CMouseSP v2cmousesp, boolean doPost) {
        int j;
        boolean flag3;
        V2CGestureMapSP v2cgesturemapsp;
        if (doPost) {
            v2cmousesp.postShowPanel();
        }
        if ((v2cgesturemapsp = v2cmousesp.getGestureMapSP()).isChanged()) {
            classStateSaver.requestSave();
        }
        V2CProperty v2cproperty = V2CMain.getUserProperty();
        boolean flag2 = v2cgesturemapsp.getUseGesture();
        if (flag2 != bUseGesture) {
            bUseGesture = flag2;
            if (flag2) {
                v2cproperty.putBoolean(sUseGestureKey, true);
            } else {
                v2cproperty.remove(sUseGestureKey);
            }
        }
        if (V2CApp.isMacintosh() && (flag3 = v2cgesturemapsp.getUseLeftButton()) != bUseLeftButton) {
            bUseLeftButton = flag3;
            if (flag3) {
                v2cproperty.remove(sUseLeftButtonKey);
            } else {
                v2cproperty.putBoolean(sUseLeftButtonKey, false);
            }
        }
        if ((j = v2cgesturemapsp.getThreshold()) != nThreshold) {
            nThreshold = j;
            if (j != 30) {
                v2cproperty.putInt(sThresholdKey, j);
            } else {
                v2cproperty.remove(sThresholdKey);
            }
        }
    }

    static void checkActions() {
        boolean flag = false;
        V2CGestureMap[] av2cgesturemap = vgmlGestureMaps;
        int i = 0;
        while (i < av2cgesturemap.length) {
            V2CGestureMap v2cgesturemap = av2cgesturemap[i];
            Iterator iterator = v2cgesturemap.getKeyIterator();
            while (iterator.hasNext()) {
                if (V2CActionMap.getAction(v2cgesturemap.get(iterator.next())) != null) continue;
                iterator.remove();
                flag = true;
            }
            ++i;
        }
        if (flag) {
            classStateSaver.requestSave();
        }
    }

    private static boolean isNormalPopupButton(MouseEvent mouseevent) {
        int i = mouseevent.getButton();
        if (V2CApp.isMacintosh()) {
            return i == 1 && mouseevent.isControlDown() || i == 3;
        }
        return i == 3;
    }

    public V2CGestureMap(String s) {
        this.sName = s;
    }

    Iterator getKeyIterator() {
        return this.keySet().iterator();
    }

    boolean isPopupTrigger(MouseEvent mouseevent, boolean flag) {
        if (!bUseGesture || this.leftButtonBeingUsed()) {
            return mouseevent.isPopupTrigger();
        }
        if (flag) {
            return false;
        }
        return V2CGestureMap.isNormalPopupButton(mouseevent);
    }

    boolean isGestureTrigger(MouseEvent mouseevent, boolean flag) {
        if (!bUseGesture) {
            return false;
        }
        if (this.leftButtonBeingUsed()) {
            return flag && mouseevent.getButton() == 1 && !mouseevent.isControlDown();
        }
        return mouseevent.getButton() == 3;
    }

    boolean shouldPassToGlobal() {
        return !this.bGlobal && !(cmpGesture instanceof V2CImagePopup);
    }

    boolean shouldPassToThreadView() {
        int i = this.iIndex;
        return i == 5 || i == 6 || i == 7;
    }

    @Override
    public Object get(Object obj) {
        Object obj1 = super.get(obj);
        if (obj1 != null) {
            return obj1;
        }
        if (this.shouldPassToThreadView()) {
            return vgmlGestureMaps[4].get(obj);
        }
        return this.shouldPassToGlobal() ? gmGlobal.get(obj) : null;
    }

    boolean checkStroke(String s) {
        if (s == null || s.length() == 0) {
            return true;
        }
        Set set = this.keySet();
        for (String s1 : set) {
            if (s1 == null || s1.length() == 0 || !s1.startsWith(s)) continue;
            return true;
        }
        if (this.shouldPassToThreadView()) {
            return vgmlGestureMaps[4].checkStroke(s);
        }
        return this.shouldPassToGlobal() ? gmGlobal.checkStroke(s) : false;
    }

    boolean leftButtonBeingUsed() {
        return bUseLeftButton;
    }

    boolean mousePressed(MouseEvent mouseevent, boolean flag) {
        int i = mouseevent.getButton();
        if (bInGesture && (i == 3 || (mouseevent.getModifiersEx() & 0x1000) == 0)) {
            V2CGestureMap.endGesture();
        }
        if (bInGesture) {
            if (this.leftButtonBeingUsed() || (mouseevent.getModifiersEx() & 0x1000) == 0) {
                V2CGestureMap.endGesture();
                cmpGesture = null;
                return false;
            }
            if (i == 1 || i == 2 || i >= 4 && i <= 7) {
                StringBuffer stringbuffer = sbGestureBuffer;
                if (stringbuffer.length() > 0) {
                    V2CGestureMap.endGesture();
                }
                if (bWheelRotating) {
                    cmpGesture = null;
                    return false;
                }
                if (!bLeftClicking) {
                    bLeftClicking = true;
                    V2CGestureMap.restoreCursor();
                }
                if (cmpGesture != null) {
                    V2CAbstractAction v2cabstractaction1;
                    String s3;
                    String s;
                    switch (i) {
                        case 1: {
                            s = "L";
                            break;
                        }
                        case 2: {
                            s = "M";
                            break;
                        }
                        case 4: {
                            s = "W\u2190";
                            break;
                        }
                        case 5: {
                            s = "W\u2192";
                            break;
                        }
                        case 6: {
                            s = "X1";
                            break;
                        }
                        case 7: {
                            s = "X2";
                            break;
                        }
                        default: {
                            return false;
                        }
                    }
                    int j = s.length();
                    if (stringbuffer.length() > 0) {
                        stringbuffer.append(s);
                        s = stringbuffer.toString();
                    }
                    if (bShiftDown && s.length() == j) {
                        s = "S" + s;
                    }
                    if ((s3 = (String)this.get(s)) != null && (v2cabstractaction1 = V2CAction.getAction(s3)) != null) {
                        SwingUtilities.invokeLater(new V2CGestureActionEvent(v2cabstractaction1, cmpGesture, pStart));
                    }
                }
            }
            return false;
        }
        if (i == 6 || i == 7) {
            StringBuffer stringbuffer1 = sbGestureBuffer;
            if (stringbuffer1.length() > 0) {
                V2CGestureMap.endGesture();
                return false;
            }
            bShiftDown = (mouseevent.getModifiersEx() & 0x40) != 0;
            pStart = mouseevent.getPoint();
            cmpGesture = mouseevent.getComponent();
            if (cmpGesture != null) {
                V2CAbstractAction v2cabstractaction;
                String s2;
                String s1;
                String string = s1 = i != 6 ? "x2" : "x1";
                if (bShiftDown) {
                    s1 = "S" + s1;
                }
                if ((s2 = (String)this.get(s1)) != null && (v2cabstractaction = V2CAction.getAction(s2)) != null) {
                    SwingUtilities.invokeLater(new V2CGestureActionEvent(v2cabstractaction, cmpGesture, pStart));
                }
            }
            return false;
        }
        if (this.isGestureTrigger(mouseevent, flag)) {
            sbGestureBuffer.setLength(0);
            bInGesture = true;
            bNoGesture = false;
            bPointerMoved = false;
            bWheelRotating = false;
            bLeftClicking = false;
            bShiftDown = mouseevent.isShiftDown();
            iX = mouseevent.getX();
            iY = mouseevent.getY();
            pStart = mouseevent.getPoint();
            cLastDir = '\u0000';
            cmpGesture = mouseevent.getComponent();
            if (cmpGesture != null) {
                cmpGesture.setCursor(Cursor.getPredefinedCursor(13));
            }
            if (this.leftButtonBeingUsed()) {
                tmCancelTimer.start();
            }
            return false;
        }
        return this.isPopupTrigger(mouseevent, true);
    }

    boolean mouseReleased(MouseEvent mouseevent) {
        boolean flag = false;
        if (bInGesture) {
            if (mouseevent.getButton() != (this.leftButtonBeingUsed() ? 1 : 3)) {
                return false;
            }
            V2CGestureMap.endGesture();
            if (bLeftClicking || bWheelRotating) {
                cmpGesture = null;
                return false;
            }
            if (cmpGesture != null && sbGestureBuffer.length() > 0) {
                V2CAbstractAction v2cabstractaction;
                flag = true;
                String s = (String)this.get(sbGestureBuffer.toString());
                if (s != null && (v2cabstractaction = V2CAction.getAction(s)) != null) {
                    SwingUtilities.invokeLater(new V2CGestureActionEvent(v2cabstractaction, cmpGesture, pStart));
                }
            }
        }
        cmpGesture = null;
        if (flag || bLeftClicking || bWheelRotating) {
            return false;
        }
        return this.isPopupTrigger(mouseevent, false);
    }

    boolean mouseDragged(MouseEvent mouseevent) {
        if (!bInGesture) {
            return false;
        }
        if (bLeftClicking || bWheelRotating) {
            return true;
        }
        boolean flag = false;
        int i = mouseevent.getX();
        int j = mouseevent.getY();
        int k = i - iX;
        int l = j - iY;
        int c = 0;
        if (cLastDir == '\u0000') {
            if (Math.abs(k) > Math.abs(l)) {
                if (k < -nThreshold) {
                    c = 8592;
                    nLastStroke = -k;
                } else if (k > nThreshold) {
                    c = 8594;
                    nLastStroke = k;
                }
            } else if (l < -nThreshold) {
                c = 8593;
                nLastStroke = -l;
            } else if (l > nThreshold) {
                c = 8595;
                nLastStroke = l;
            }
            if (c != 0 && this.leftButtonBeingUsed() && tmCancelTimer.isRunning()) {
                tmCancelTimer.stop();
            }
        } else if (cLastDir == '\u2191') {
            int i1;
            if (l < 0) {
                l = 0;
                iY = j;
                nLastStroke = iY0 - j;
            }
            if (k < -(i1 = Math.max(30 * nLastStroke / 100, nThreshold))) {
                c = 8592;
            } else if (k > i1) {
                c = 8594;
            } else if (l > i1) {
                c = 8595;
            }
        } else if (cLastDir == '\u2193') {
            int j1;
            if (l > 0) {
                l = 0;
                iY = j;
                nLastStroke = j - iY0;
            }
            if (k < -(j1 = Math.max(30 * nLastStroke / 100, nThreshold))) {
                c = 8592;
            } else if (k > j1) {
                c = 8594;
            } else if (l < -j1) {
                c = 8593;
            }
        } else if (cLastDir == '\u2190') {
            int k1;
            if (k < 0) {
                k = 0;
                iX = i;
                nLastStroke = iX0 - i;
            }
            if (l < -(k1 = Math.max(30 * nLastStroke / 100, nThreshold))) {
                c = 8593;
            } else if (l > k1) {
                c = 8595;
            } else if (k > k1) {
                c = 8594;
            }
        } else if (cLastDir == '\u2192') {
            int l1;
            if (k > 0) {
                k = 0;
                iX = i;
                nLastStroke = i - iX0;
            }
            if (l < -(l1 = Math.max(30 * nLastStroke / 100, nThreshold))) {
                c = 8593;
            } else if (l > l1) {
                c = 8595;
            } else if (k < -l1) {
                c = 8592;
            }
        }
        if (c != 0) {
            cLastDir = (char)c;
            bPointerMoved = true;
            StringBuffer stringbuffer = sbGestureBuffer;
            if (bShiftDown && stringbuffer.length() == 0) {
                stringbuffer.append('S');
            }
            stringbuffer.append((char)c);
            iX0 = iX;
            iY0 = iY;
            iX = i;
            iY = j;
            if (!bNoGesture) {
                String s = stringbuffer.toString();
                if (!this.checkStroke(s)) {
                    bNoGesture = true;
                    if (cmpGesture != null) {
                        cmpGesture.setCursor(Cursor.getPredefinedCursor(1));
                        if (!bFromSettingPanel) {
                            V2CMain.endTempMessage(V2CGestureMap.class);
                        }
                    }
                } else if (!bFromSettingPanel) {
                    String s1 = (String)this.get(s);
                    V2CAbstractAction v2cabstractaction = s1 == null ? null : V2CAction.getAction(s1);
                    V2CMain.setTempMessage(v2cabstractaction == null ? s : String.valueOf(s) + ' ' + v2cabstractaction, V2CGestureMap.class);
                }
            }
        }
        return true;
    }

    boolean mouseWheelMoved(MouseWheelEvent mousewheelevent) {
        String s;
        V2CAbstractAction v2cabstractaction;
        if (bInGesture && !V2CApp.javaVersionEqualTo(1, 7) && !V2CApp.isMacintosh() && (mousewheelevent.getModifiersEx() & 0x1000) == 0) {
            V2CGestureMap.endGesture();
        }
        if (!bInGesture || bLeftClicking || sbGestureBuffer.length() > 0) {
            return false;
        }
        Component component = mousewheelevent.getComponent();
        if (component == null) {
            return false;
        }
        int i = mousewheelevent.getWheelRotation();
        if (i == 0) {
            return true;
        }
        if (!bWheelRotating) {
            bWheelRotating = true;
            V2CGestureMap.restoreCursor();
        }
        if (cmpGesture != null && (v2cabstractaction = V2CAction.getAction(s = (String)this.get(String.valueOf(bShiftDown ? "SW" : "W") + (i <= 0 ? (char)'\u2191' : '\u2193')))) != null) {
            SwingUtilities.invokeLater(new V2CGestureActionEvent(v2cabstractaction, cmpGesture, pStart));
        }
        return true;
    }

    static int getCurrentStrokeCount() {
        return sbGestureBuffer.length();
    }

    static String getCurrentGestureString(boolean flag) {
        StringBuffer stringbuffer = sbGestureBuffer;
        if (flag && bShiftDown && stringbuffer.length() == 0) {
            stringbuffer.append('S');
        }
        return stringbuffer.toString();
    }

    String getName() {
        return this.sName;
    }

    boolean isGlobal() {
        return this.bGlobal;
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj;
    }

    @Override
    public int hashCode() {
        return this.sLabel.hashCode();
    }

    @Override
    public String toString() {
        return this.sLabel;
    }

    private static class ClassStateSaver
    extends V2CClassStateSaver {
        @Override
        public void doSaveState() {
            V2CGestureMap.saveGestureMap();
        }

        ClassStateSaver(int i) {
            super(i);
        }
    }

    private static class GestureCancelAction
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent actionevent) {
            V2CGestureMap.endGesture();
        }

        private GestureCancelAction() {
        }
    }
}

