/*
 * Decompiled with CFR 0.152.
 */
package org.monazilla.v2c;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import org.monazilla.v2c.V2CApp;
import org.monazilla.v2c.V2CBaseFont;
import org.monazilla.v2c.V2CJ2SE5Util;
import org.monazilla.v2c.V2CMiscUtil;
import org.monazilla.v2c.V2CProperty;
import org.monazilla.v2c.V2CSSFont;
import org.monazilla.v2c.V2CSwingUtil;

public abstract class V2CFont {
    private static final String sCheckCharsKey = "Font.CheckChars";
    static final int NBOLD = 0;
    static final int NITALIC = 1;
    static final int NUNDERLINE = 2;
    static final int NSTRIKE = 3;
    static final int NBOLDUNDERLINE = 4;
    static final int NBOLDSTRIKE = 5;
    static final int NSTYLE = 6;
    static final int BOLD = 1;
    static final int ITALIC = 2;
    static final int UNDERLINE = 4;
    static final int STRIKE = 8;
    static final int BOLDUNDERLINE = 16;
    static final int BOLDSTRIKE = 32;
    static final String[] slStyleValues;
    static HashMap hmFont;
    static String DEFAULTNAME;
    static V2CFont fDefaultFont;
    private static final int nFrequentChars;
    private static int[] ilFrequentChars;
    static final int[] ilCacheIndex;
    static HashMap hmWidthCache;
    static boolean bCheckFontChars;
    static boolean bCheckPUAChars;
    String sName;
    V2CFont fParent;
    String sBaseFontName;
    V2CBaseFont baseFont;
    float fSize;
    int iStyle;
    boolean[] blStyle = new boolean[6];
    Font awtFont;
    Color cForeground;
    Color cBackground;
    boolean[] blUseParent = new boolean[6];
    boolean bBaseFontUseParent;
    boolean bSizeUseParent;
    boolean bForegroundUseParent;
    boolean bBackgroundUseParent;
    boolean bRecreateAwtFont;
    boolean bTemporary;
    byte[] blWidthCache;
    ArrayList alChildren = new ArrayList();
    int nHeight;
    int nAscent;
    int nDescent;
    int nLeading;
    int nLineHeight;
    int nSPWidth;
    private static final int NMAXFONTCHAR = 262144;
    private static byte[] blChar2Font;
    private static Font[] flFonts0;
    private static Font[] flFonts;
    private static Font[] flFontCache;
    private static boolean bArabicChecked;
    private static boolean bHebrewChecked;
    private static char[] clCharWidthBuffer;

    static boolean[] createDispCharArray(Font font) {
        boolean[] blArray = new boolean[nFrequentChars];
        if (font != null) {
            int[] nArray = ilFrequentChars;
            for (int i = nFrequentChars - 1; i >= 0; --i) {
                blArray[i] = font.canDisplay((char)nArray[i]);
            }
        }
        return blArray;
    }

    static void setCheckFontChars(boolean bl, boolean bl2) {
        if (bl == bCheckFontChars && bl2 == bCheckPUAChars) {
            return;
        }
        bCheckFontChars = bl;
        bCheckPUAChars = bl && bl2;
        V2CProperty v2CProperty = V2CApp.getUserProperty();
        if (bl) {
            v2CProperty.put(sCheckCharsKey, bl2 ? "cp" : "c");
        } else {
            v2CProperty.remove(sCheckCharsKey);
        }
    }

    private static boolean canDisplay(Font font, int n) {
        if (n < 65536) {
            return font.canDisplay((char)n);
        }
        if (V2CApp.javaVersionEqualOrGreaterThan(1, 5)) {
            return V2CJ2SE5Util.canDisplay(font, n);
        }
        return true;
    }

    private static int canDisplayUpTo(Font font, char[] cArray, int n, int n2) {
        boolean bl = false;
        for (int i = n; i < n2; ++i) {
            char c;
            int n3 = cArray[i];
            if ((n3 & 0xFC00) == 55296 && i + 1 < n2 && ((c = cArray[i + 1]) & 0xFC00) == 56320) {
                bl = true;
                n3 = V2CMiscUtil.toCodePoint(n3, c);
            }
            if (!V2CFont.canDisplay(font, n3)) {
                return i;
            }
            if (!bl) continue;
            bl = false;
            ++i;
        }
        return -1;
    }

    private static int canDisplayUpTo(Font font, String string, int n, int n2) {
        boolean bl = false;
        for (int i = n; i < n2; ++i) {
            char c;
            int n3 = string.charAt(i);
            if ((n3 & 0xFC00) == 55296 && i + 1 < n2 && ((c = string.charAt(i + 1)) & 0xFC00) == 56320) {
                bl = true;
                n3 = V2CMiscUtil.toCodePoint(n3, c);
            }
            if (!V2CFont.canDisplay(font, n3)) {
                return i;
            }
            if (!bl) continue;
            bl = false;
            ++i;
        }
        return -1;
    }

    static Font getAvailableFont(Font font, int n) {
        int n2;
        Object object;
        Serializable serializable;
        Object object2;
        if (n < 0 || n >= 262144) {
            return null;
        }
        if (!bCheckPUAChars && n >= 57344 && n < 63744) {
            return null;
        }
        int n3 = font.getSize();
        Font[] fontArray = flFonts;
        int n4 = blChar2Font[n] & 0xFF;
        if (n4 == 255) {
            return null;
        }
        if (n4 > 0 && (object2 = flFontCache[n4 - 1]) != null) {
            if (((Font)object2).getSize() != n3) {
                V2CFont.flFontCache[n4 - 1] = object2 = ((Font)object2).deriveFont((float)n3);
            }
            return object2;
        }
        if (fontArray == null) {
            int n5;
            int n6;
            object2 = GraphicsEnvironment.getLocalGraphicsEnvironment();
            serializable = new ArrayList<Font>();
            object = ((GraphicsEnvironment)object2).getAvailableFontFamilyNames();
            for (n6 = 0; n6 < ((String[])object).length; ++n6) {
                ((ArrayList)serializable).add(new Font(object[n6], 0, 1));
            }
            n6 = ((ArrayList)serializable).size();
            if (n6 > 2048) {
                n6 = 2048;
            }
            int[] nArray = new int[n6];
            Font[] fontArray2 = new Font[n6];
            for (n5 = 0; n5 < n6; ++n5) {
                Font font2;
                fontArray2[n5] = font2 = (Font)((ArrayList)serializable).get(n5);
                nArray[n5] = font2.getNumGlyphs() << 11 | n5;
            }
            Arrays.sort(nArray);
            n5 = n6;
            if (n5 > 254) {
                n5 = 254;
            }
            fontArray = new Font[n5];
            for (int i = 0; i < n5; ++i) {
                fontArray[i] = fontArray2[nArray[n6 - 1 - i] & 0x7FF];
            }
            flFonts0 = fontArray;
            flFonts = fontArray = new Font[n5];
            flFontCache = new Font[n5];
        }
        int n7 = fontArray.length;
        if (!(bArabicChecked || (n < 1536 || n >= 1920 || n >= 1792 && n < 1872) && (n < 64336 || n >= 65280 || n >= 65024 && n < 65136))) {
            bArabicChecked = true;
            serializable = V2CFont.checkArabicFont(n, n7, n3);
            if (serializable != null) {
                return serializable;
            }
        }
        if (!bHebrewChecked && (n >= 1424 && n < 1536 || n >= 64285 && n < 64336)) {
            bHebrewChecked = true;
            serializable = V2CFont.checkHebrewFont(n, n7, n3);
            if (serializable != null) {
                return serializable;
            }
        }
        for (n2 = 0; n2 < n7; ++n2) {
            Font font3;
            object = fontArray[n2];
            if (object == null || !V2CFont.canDisplay((Font)object, n) || (font3 = flFontCache[n2]) == null) continue;
            if (font3.getSize() != n3) {
                V2CFont.flFontCache[n2] = font3 = font3.deriveFont((float)n3);
            }
            return font3;
        }
        fontArray = flFonts0;
        for (n2 = 0; n2 < n7; ++n2) {
            Font font4;
            object = fontArray[n2];
            if (object == null || !V2CFont.canDisplay((Font)object, n)) continue;
            V2CFont.flFonts[n2] = object;
            fontArray[n2] = null;
            V2CFont.blChar2Font[n] = (byte)(n2 + 1);
            V2CFont.flFontCache[n2] = font4 = ((Font)object).deriveFont((float)n3);
            return font4;
        }
        V2CFont.blChar2Font[n] = -1;
        return null;
    }

    private static Font checkArabicFont(int n, int n2, int n3) {
        Font font;
        int n4;
        Font[] fontArray = flFonts;
        Font[] fontArray2 = flFonts0;
        int[] nArray = new int[n2];
        int[] nArray2 = new int[]{1643, 1672, 1619, 65010, 64606, 64342, 64338, 64426, 64384};
        int[] nArray3 = new int[]{11, 8, 3, 40, 11, 3, 2, 1, 49};
        Font font2 = null;
        int n5 = 0;
        int n6 = -1;
        for (int i = 0; i < n2; ++i) {
            Font font3 = fontArray[i];
            if (font3 == null) {
                font3 = fontArray2[i];
            }
            if (font3 == null || !V2CFont.canDisplay(font3, 1548)) continue;
            n4 = 0;
            for (int j = 0; j < nArray2.length; ++j) {
                if (!V2CFont.canDisplay(font3, nArray2[j])) continue;
                n4 += nArray3[j];
            }
            if (n4 <= n5) continue;
            n5 = n4;
            font2 = font3;
            n6 = i;
        }
        if (font2 == null) {
            return null;
        }
        if (fontArray[n6] == null) {
            fontArray[n6] = font2;
            fontArray2[n6] = null;
        }
        byte[] byArray = blChar2Font;
        byte by = (byte)(n6 + 1);
        for (n4 = 1536; n4 < 1920; ++n4) {
            if (n4 >= 1792 && n4 < 1872 || !V2CFont.canDisplay(font2, n4)) continue;
            byArray[n4] = by;
        }
        for (n4 = 64336; n4 < 65280; ++n4) {
            if (n4 >= 65024 && n4 < 65136 || !V2CFont.canDisplay(font2, n4)) continue;
            byArray[n4] = by;
        }
        if (!V2CFont.canDisplay(font2, n)) {
            return null;
        }
        V2CFont.flFontCache[n6] = font = font2.deriveFont((float)n3);
        return font;
    }

    private static Font checkHebrewFont(int n, int n2, int n3) {
        Font font;
        int n4;
        Font[] fontArray = flFonts;
        Font[] fontArray2 = flFonts0;
        int[] nArray = new int[n2];
        int[] nArray2 = new int[]{1425, 1520, 1466, 64298, 64286, 64285};
        int[] nArray3 = new int[]{7, 10, 1, 10, 9, 3};
        Font font2 = null;
        int n5 = 0;
        int n6 = -1;
        for (int i = 0; i < n2; ++i) {
            Font font3 = fontArray[i];
            if (font3 == null) {
                font3 = fontArray2[i];
            }
            if (font3 == null || !V2CFont.canDisplay(font3, 1488)) continue;
            n4 = 0;
            for (int j = 0; j < nArray2.length; ++j) {
                if (!V2CFont.canDisplay(font3, nArray2[j])) continue;
                n4 += nArray3[j];
            }
            if (n4 <= n5) continue;
            n5 = n4;
            font2 = font3;
            n6 = i;
        }
        if (font2 == null) {
            return null;
        }
        if (fontArray[n6] == null) {
            fontArray[n6] = font2;
            fontArray2[n6] = null;
        }
        byte[] byArray = blChar2Font;
        byte by = (byte)(n6 + 1);
        for (n4 = 1424; n4 < 1536; ++n4) {
            if (!V2CFont.canDisplay(font2, n4)) continue;
            byArray[n4] = by;
        }
        for (n4 = 64285; n4 < 64336; ++n4) {
            if (!V2CFont.canDisplay(font2, n4)) continue;
            byArray[n4] = by;
        }
        if (!V2CFont.canDisplay(font2, n)) {
            return null;
        }
        V2CFont.flFontCache[n6] = font = font2.deriveFont((float)n3);
        return font;
    }

    static int drawString(Graphics2D graphics2D, V2CSSFont[] v2CSSFontArray, int n, char[] cArray, int n2, int n3, int n4, int n5, int n6) {
        boolean bl = n + 1 < v2CSSFontArray.length;
        V2CSSFont v2CSSFont = v2CSSFontArray[n];
        Font font = v2CSSFont.getAwtFont();
        n2 += n4;
        n3 += n4;
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        if (!bl && !bCheckFontChars) {
            graphics2D.setFont(font);
            graphics2D.drawChars(cArray, n2, n3 - n2, n5, n6);
            if (n > 0) {
                Rectangle2D rectangle2D = font.getStringBounds(cArray, n2, n3, fontRenderContext);
                n5 += (int)rectangle2D.getWidth();
            }
            return n5;
        }
        Font font2 = null;
        int n7 = n5;
        while (n2 < n3) {
            int n8;
            int n9;
            graphics2D.setFont(font);
            int n10 = v2CSSFont.canDisplayUpTo(cArray, n2, n3, true);
            if (n10 < 0) {
                graphics2D.drawChars(cArray, n2, n3 - n2, n7, n6);
                if (n > 0) {
                    Rectangle2D rectangle2D = font.getStringBounds(cArray, n2, n3, fontRenderContext);
                    n7 += (int)rectangle2D.getWidth();
                }
                return n7;
            }
            if (n10 > n2) {
                graphics2D.drawChars(cArray, n2, n10 - n2, n7, n6);
                Rectangle2D rectangle2D = font.getStringBounds(cArray, n2, n10, fontRenderContext);
                n7 += (int)rectangle2D.getWidth();
                n2 = n10;
            }
            if (n2 + 1 < n3) {
                n9 = v2CSSFont.canDisplayUpTo(cArray, n2 + 1, n3, false);
                if (n9 < 0) {
                    n9 = n3;
                }
            } else {
                n9 = n3;
            }
            if (bl) {
                n7 = V2CFont.drawString(graphics2D, v2CSSFontArray, n + 1, cArray, n2 - n4, n9 - n4, n4, n7, n6);
                n2 = n9;
                continue;
            }
            Font font3 = V2CFont.getAvailableFont(font, V2CMiscUtil.toCodePoint(cArray, n2, n3));
            if (font3 != null) {
                n10 = V2CFont.canDisplayUpTo(font3, cArray, n2, n9);
                if (n10 < 0) {
                    n10 = n9;
                }
                if (n10 > n2) {
                    graphics2D.setFont(font3);
                    try {
                        graphics2D.drawChars(cArray, n2, n10 - n2, n7, n6);
                        Rectangle2D rectangle2D = font3.getStringBounds(cArray, n2, n10, fontRenderContext);
                        n7 += (int)rectangle2D.getWidth();
                    }
                    catch (NullPointerException nullPointerException) {
                        // empty catch block
                    }
                    n2 = n10;
                    continue;
                }
            }
            int n11 = 1;
            int n12 = cArray[n2];
            if ((n12 & 0xFC00) == 55296 && n2 + 1 < n3 && ((n8 = cArray[n2 + 1]) & 0xFC00) == 56320) {
                n12 = V2CMiscUtil.toCodePoint(n12, n8);
                n11 = 2;
            }
            n8 = font.getSize();
            float f = n11 == 1 ? (float)n8 * 0.95f : (float)n8 * 1.2f;
            int n13 = n8 - 1;
            graphics2D.drawRect(n7, n6 - n13 + 1, (int)f - 2, n13);
            if (font2 == null) {
                font2 = font.deriveFont((float)(n8 / 2 + 1));
            }
            graphics2D.setFont(font2);
            float f2 = (float)(n8 - 1) * 0.4f - 1.0f;
            char[] cArray2 = new char[1];
            for (int i = 0; i < 2; ++i) {
                int n14;
                int n15 = (int)(i == 0 ? (float)(n6 + 1) : (float)n6 - (float)n8 / 2.0f + 2.0f);
                int n16 = n14 = n11 == 1 ? 1 : 2;
                while (n14 >= 0) {
                    int n17 = n12 & 0xF;
                    n12 >>>= 4;
                    cArray2[0] = (char)(n17 < 10 ? 48 + n17 : 65 + n17 - 10);
                    graphics2D.drawChars(cArray2, 0, 1, (int)((float)n7 + (float)n14 * f2 + 2.0f), n15);
                    --n14;
                }
            }
            graphics2D.setFont(font);
            n7 = (int)((float)n7 + f);
            n2 += n11;
        }
        return n7;
    }

    static float drawString(Graphics2D graphics2D, V2CSSFont[] v2CSSFontArray, int n, String string, int n2, int n3, float f, float f2) {
        int n4;
        boolean bl = n + 1 < v2CSSFontArray.length;
        V2CSSFont v2CSSFont = v2CSSFontArray[n];
        Font font = v2CSSFont.getAwtFont();
        if (n2 > 0 || n3 < string.length()) {
            string = string.substring(n2, n3);
            n4 = n3 - n2;
        } else {
            n4 = n3;
        }
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        if (!bl && !bCheckFontChars) {
            graphics2D.setFont(font);
            graphics2D.drawString(string, f, f2);
            if (n > 0) {
                Rectangle2D rectangle2D = font.getStringBounds(string, 0, string.length(), fontRenderContext);
                f = (float)((double)f + rectangle2D.getWidth());
            }
            return f;
        }
        Font font2 = null;
        float f3 = f;
        while (n4 > 0) {
            int n5;
            int n6;
            graphics2D.setFont(font);
            int n7 = v2CSSFont.canDisplayUpTo(string, 0, n4, true);
            if (n7 < 0) {
                graphics2D.drawString(string, f3, f2);
                if (n > 0) {
                    Rectangle2D rectangle2D = font.getStringBounds(string, 0, n4, fontRenderContext);
                    f3 = (float)((double)f3 + rectangle2D.getWidth());
                }
                return f3;
            }
            if (n7 > 0) {
                graphics2D.drawString(string.substring(0, n7), f3, f2);
                Rectangle2D rectangle2D = font.getStringBounds(string, 0, n7, fontRenderContext);
                f3 = (float)((double)f3 + rectangle2D.getWidth());
                string = string.substring(n7);
                n4 -= n7;
            }
            if (1 < n4) {
                n6 = v2CSSFont.canDisplayUpTo(string, 1, n4, false);
                if (n6 < 0) {
                    n6 = n4;
                }
            } else {
                n6 = n4;
            }
            if (bl) {
                f3 = V2CFont.drawString(graphics2D, v2CSSFontArray, n + 1, string, 0, n6, f3, f2);
                string = string.substring(n6);
                n4 -= n6;
                continue;
            }
            Font font3 = V2CFont.getAvailableFont(font, V2CMiscUtil.toCodePoint(string, 0, n4));
            if (font3 != null) {
                n7 = V2CFont.canDisplayUpTo(font3, string, 0, n6);
                if (n7 < 0) {
                    n7 = n6;
                }
                if (n7 > 0) {
                    graphics2D.setFont(font3);
                    graphics2D.drawString(string.substring(0, n7), f3, f2);
                    Rectangle2D rectangle2D = font3.getStringBounds(string, 0, n7, fontRenderContext);
                    f3 = (float)((double)f3 + rectangle2D.getWidth());
                    string = string.substring(n7);
                    n4 -= n7;
                    continue;
                }
            }
            int n8 = 1;
            int n9 = string.charAt(0);
            if ((n9 & 0xFC00) == 55296 && n4 > 1 && ((n5 = (int)string.charAt(1)) & 0xFC00) == 56320) {
                n8 = 2;
            }
            n5 = font.getSize();
            float f4 = n8 == 1 ? (float)n5 * 0.95f : (float)n5 * 1.2f;
            int n10 = n5 - 1;
            graphics2D.drawRect((int)f3, (int)f2 - n10 + 1, (int)f4 - 2, n10);
            if (font2 == null) {
                font2 = font.deriveFont((float)(n5 / 2 + 1));
            }
            graphics2D.setFont(font2);
            float f5 = (float)(n5 - 1) * 0.4f - 1.0f;
            char[] cArray = new char[1];
            for (int i = 0; i < 2; ++i) {
                int n11;
                int n12 = (int)(i == 0 ? f2 + 1.0f : f2 - (float)n5 / 2.0f + 2.0f);
                int n13 = n11 = n8 == 1 ? 1 : 2;
                while (n11 >= 0) {
                    int n14 = n9 & 0xF;
                    n9 >>>= 4;
                    cArray[0] = (char)(n14 < 10 ? 48 + n14 : 65 + n14 - 10);
                    graphics2D.drawChars(cArray, 0, 1, (int)(f3 + (float)n11 * f5 + 2.0f), n12);
                    --n11;
                }
            }
            graphics2D.setFont(font);
            f3 += f4;
            string = string.substring(n8);
            n4 -= n8;
        }
        return f3;
    }

    static int getCharWidth(V2CSSFont[] v2CSSFontArray, int n, FontRenderContext fontRenderContext, boolean bl) {
        int n2 = v2CSSFontArray.length;
        for (int i = 0; i < n2; ++i) {
            int n3 = v2CSSFontArray[i].getCharWidth(n, fontRenderContext, bl, i + 1 < n2, bCheckFontChars);
            if (n3 < 0) continue;
            return n3;
        }
        return 0;
    }

    static Rectangle2D getStringBounds(V2CSSFont[] v2CSSFontArray, int n, String string, int n2, int n3, FontRenderContext fontRenderContext, boolean bl) {
        Font font;
        boolean bl2 = n + 1 < v2CSSFontArray.length;
        V2CSSFont v2CSSFont = v2CSSFontArray[n];
        Font font2 = font = bl ? null : v2CSSFont.getAwtFont();
        if (!bl2 && !bCheckFontChars) {
            if (bl) {
                return v2CSSFont.getStringBounds(string, n2, n3, fontRenderContext);
            }
            return font.getStringBounds(string, n2, n3, fontRenderContext);
        }
        float f = 0.0f;
        while (n2 < n3) {
            int n4;
            Object object;
            int n5;
            int n6 = v2CSSFont.canDisplayUpTo(string, n2, n3, true);
            if (n6 < 0) {
                Rectangle2D rectangle2D = bl ? v2CSSFont.getStringBounds(string, n2, n3, fontRenderContext) : font.getStringBounds(string, n2, n3, fontRenderContext);
                if (f > 0.0f) {
                    return new Rectangle2D.Float((float)rectangle2D.getX(), (float)rectangle2D.getY(), f + (float)rectangle2D.getWidth(), (float)rectangle2D.getHeight());
                }
                return rectangle2D;
            }
            if (n6 > n2) {
                Rectangle2D rectangle2D = bl ? v2CSSFont.getStringBounds(string, n2, n6, fontRenderContext) : font.getStringBounds(string, n2, n6, fontRenderContext);
                f += (float)((int)rectangle2D.getWidth());
                n2 = n6;
            }
            if (n2 + 1 < n3) {
                n5 = v2CSSFont.canDisplayUpTo(string, n2 + 1, n3, false);
                if (n5 < 0) {
                    n5 = n3;
                }
            } else {
                n5 = n3;
            }
            if (bl2) {
                object = V2CFont.getStringBounds(v2CSSFontArray, n + 1, string, n2, n5, fontRenderContext, bl);
                f += (float)((int)((RectangularShape)object).getWidth());
                n2 = n5;
                continue;
            }
            if (font == null) {
                font = v2CSSFont.getAwtFont();
            }
            if ((object = V2CFont.getAvailableFont(font, V2CMiscUtil.toCodePoint(string, n2, n3))) != null) {
                n6 = V2CFont.canDisplayUpTo((Font)object, string, n2, n5);
                if (n6 < 0) {
                    n6 = n5;
                }
                if (n6 > n2) {
                    try {
                        Rectangle2D rectangle2D = ((Font)object).getStringBounds(string, n2, n6, fontRenderContext);
                        f += (float)((int)rectangle2D.getWidth());
                    }
                    catch (NullPointerException nullPointerException) {
                        // empty catch block
                    }
                    n2 = n6;
                    continue;
                }
            }
            int n7 = 1;
            char c = string.charAt(n2);
            if ((c & 0xFC00) == 55296 && n2 + 1 < n3 && ((n4 = (int)string.charAt(n2 + 1)) & 0xFC00) == 56320) {
                n7 = 2;
            }
            n4 = font.getSize();
            f += n7 == 1 ? (float)n4 * 0.95f : (float)n4 * 1.2f;
            n2 += n7;
        }
        return new Rectangle2D.Float(0.0f, -v2CSSFont.nAscent, f, v2CSSFont.nAscent + v2CSSFont.nDescent);
    }

    static V2CFont getFont(String string) {
        return (V2CFont)hmFont.get(string);
    }

    static void baseFontChanged(V2CBaseFont v2CBaseFont) {
        V2CFont.baseFontChanged(v2CBaseFont, hmFont);
        V2CFont.clearAllWidthCache();
    }

    static void baseFontChanged(V2CBaseFont v2CBaseFont, HashMap hashMap) {
        Iterator iterator = hashMap.values().iterator();
        while (iterator.hasNext()) {
            V2CFont v2CFont = (V2CFont)iterator.next();
            v2CFont.checkBaseFontChange(v2CBaseFont);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void clearAllWidthCache() {
        HashMap hashMap = hmWidthCache;
        synchronized (hashMap) {
            Iterator iterator = hmWidthCache.values().iterator();
            while (iterator.hasNext()) {
                Arrays.fill((byte[])iterator.next(), (byte)-1);
            }
        }
    }

    protected V2CFont() {
    }

    public V2CFont(String string) {
        this.bRecreateAwtFont = true;
        String[] stringArray = V2CMiscUtil.split(string);
        int n = stringArray.length;
        if (n < 2) {
            return;
        }
        this.sName = stringArray[0];
        String string2 = stringArray[1];
        if (string2 == null || string2.length() == 0) {
            if (fDefaultFont == null) {
                this.setDefault();
            }
            this.setUseParent();
        } else {
            this.fParent = V2CFont.getFont(string2);
            if (this.fParent == null) {
                this.fParent = fDefaultFont;
            }
            if (this.fParent == null) {
                this.setDefault();
                this.setUseParent();
            } else {
                this.fParent.addChild(this);
                this.copyParent();
                this.setUseParent();
            }
        }
        if (n >= 3) {
            this.sBaseFontName = stringArray[2];
            this.setBaseFont(V2CBaseFont.getBaseFont(this.sBaseFontName));
        }
        if (n >= 4) {
            this.setSize(stringArray[3]);
        }
        if (n >= 5) {
            this.setStyle(stringArray[4]);
        }
        if (n >= 6) {
            this.setForeground(V2CSwingUtil.parseColorString(stringArray[5]));
        }
        if (n >= 7) {
            this.setBackground(V2CSwingUtil.parseColorString(stringArray[6]));
        }
        this.add();
    }

    public V2CFont(V2CFont v2CFont) {
        this.bRecreateAwtFont = true;
        this.fParent = v2CFont;
        this.fParent.addChild(this);
        this.copyParent();
        this.setUseParent();
    }

    void getSaveString(StringBuffer stringBuffer) {
        stringBuffer.setLength(0);
        stringBuffer.append(this.sName);
        stringBuffer.append(',');
        if (this.fParent != null) {
            stringBuffer.append(this.fParent.getName());
        }
        stringBuffer.append(',');
        if (!this.bBaseFontUseParent) {
            stringBuffer.append(this.sBaseFontName);
        }
        stringBuffer.append(',');
        if (!this.bSizeUseParent) {
            stringBuffer.append(String.valueOf((int)this.fSize));
        }
        stringBuffer.append(',');
        boolean bl = false;
        for (int i = 0; i < this.blStyle.length; ++i) {
            if (this.blUseParent[i]) continue;
            bl = true;
            if (!this.blStyle[i]) {
                stringBuffer.append('!');
            }
            stringBuffer.append(slStyleValues[i]);
            stringBuffer.append('|');
        }
        if (bl) {
            stringBuffer.setLength(stringBuffer.length() - 1);
        }
        stringBuffer.append(',');
        if (!this.bForegroundUseParent && this.cForeground != null) {
            stringBuffer.append(V2CSwingUtil.colorToString(this.cForeground));
        }
        stringBuffer.append(',');
        if (!this.bBackgroundUseParent && this.cBackground != null) {
            stringBuffer.append(V2CSwingUtil.colorToString(this.cBackground));
        }
    }

    void copyParent() {
        this.baseFont = this.fParent.baseFont;
        this.fSize = this.fParent.fSize;
        this.iStyle = this.fParent.iStyle;
        this.cForeground = this.fParent.cForeground;
        this.cBackground = this.fParent.cBackground;
        System.arraycopy(this.fParent.blStyle, 0, this.blStyle, 0, this.blStyle.length);
    }

    void checkBaseFontChange(V2CBaseFont v2CBaseFont) {
        if (v2CBaseFont != this.baseFont) {
            return;
        }
        this.bRecreateAwtFont = true;
        this.createWidthCache(true);
    }

    void add() {
        hmFont.put(this.sName, this);
    }

    Font createAwtFont() {
        Font font;
        if (!this.bRecreateAwtFont) {
            return this.awtFont;
        }
        this.bRecreateAwtFont = false;
        int n = 0;
        if (this.blStyle[1]) {
            n |= 2;
        }
        if (this.baseFont == null) {
            this.baseFont = V2CBaseFont.getDefaultBaseFont();
        }
        this.awtFont = font = this.baseFont.deriveFont(n, this.fSize);
        return font;
    }

    void setUseParent() {
        Arrays.fill(this.blUseParent, true);
        this.bBaseFontUseParent = true;
        this.bSizeUseParent = true;
        this.bForegroundUseParent = true;
        this.bBackgroundUseParent = true;
    }

    void resetUseParent() {
        Arrays.fill(this.blUseParent, false);
        this.bBaseFontUseParent = false;
        this.bSizeUseParent = false;
        this.bForegroundUseParent = false;
        this.bBackgroundUseParent = false;
    }

    void setBaseFont(V2CBaseFont v2CBaseFont) {
        this.setBaseFont(v2CBaseFont, false);
    }

    void setBaseFont(V2CBaseFont v2CBaseFont, boolean bl) {
        if (v2CBaseFont == null) {
            return;
        }
        if (this.baseFont != v2CBaseFont) {
            this.bRecreateAwtFont = true;
        }
        this.baseFont = v2CBaseFont;
        this.bBaseFontUseParent = bl;
    }

    void setSize(String string) {
        try {
            float f = Float.parseFloat(string);
            this.setSize(f);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    void setSize(float f) {
        this.setSize(f, false);
    }

    void setSize(float f, boolean bl) {
        if (f <= 0.0f) {
            return;
        }
        if (this.fSize != f) {
            this.bRecreateAwtFont = true;
        }
        this.fSize = f;
        this.bSizeUseParent = bl;
    }

    void setStyle(String string) {
        if (string == null || string.length() == 0) {
            return;
        }
        String[] stringArray = string.split("\\|");
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            if (string2.length() == 0) continue;
            boolean bl = false;
            if (string2.charAt(0) == '!') {
                bl = true;
                string2 = string2.substring(1);
            }
            for (int j = 0; j < slStyleValues.length; ++j) {
                if (!string2.equals(slStyleValues[j])) continue;
                if (bl) {
                    this.resetStyle(1 << j);
                    continue;
                }
                this.setStyle(1 << j);
            }
        }
    }

    void setStyle(int n) {
        this.setStyle(n, false);
    }

    void setStyle(int n, boolean bl) {
        int n2 = 1;
        for (int i = 0; i < 6; ++i) {
            if ((n & n2) != 0) {
                if (i == 1 && !this.blStyle[1]) {
                    this.bRecreateAwtFont = true;
                }
                this.blUseParent[i] = bl;
                this.blStyle[i] = true;
            }
            n2 <<= 1;
        }
    }

    void resetStyle(int n) {
        this.resetStyle(n, false);
    }

    void resetStyle(int n, boolean bl) {
        int n2 = 1;
        for (int i = 0; i < 6; ++i) {
            if ((n & n2) != 0) {
                if (i == 1 && this.blStyle[1]) {
                    this.bRecreateAwtFont = true;
                }
                this.blUseParent[i] = bl;
                this.blStyle[i] = false;
            }
            n2 <<= 1;
        }
    }

    void setForeground(Color color) {
        this.setForeground(color, false);
    }

    void setForeground(Color color, boolean bl) {
        if (color == null) {
            return;
        }
        this.cForeground = color;
        this.bForegroundUseParent = bl;
    }

    void setBackground(Color color) {
        this.setBackground(color, false);
    }

    void setBackground(Color color, boolean bl) {
        if (color == null) {
            return;
        }
        this.cBackground = color;
        this.bBackgroundUseParent = bl;
    }

    void addChild(V2CFont v2CFont) {
        this.alChildren.add(v2CFont);
    }

    private boolean canDisplay(int n) {
        int n2;
        V2CBaseFont v2CBaseFont = this.baseFont;
        if (v2CBaseFont != null && n < 65536 && (n2 = ilCacheIndex[n]) >= 0) {
            return v2CBaseFont.canDisplay(n2);
        }
        return V2CFont.canDisplay(this.getAwtFont(), n);
    }

    protected int canDisplayUpTo(char[] cArray, int n, int n2, boolean bl) {
        boolean bl2 = false;
        for (int i = n; i < n2; ++i) {
            char c;
            int n3 = cArray[i];
            if ((n3 & 0xFC00) == 55296 && i + 1 < n2 && ((c = cArray[i + 1]) & 0xFC00) == 56320) {
                bl2 = true;
                n3 = V2CMiscUtil.toCodePoint(n3, c);
            }
            if (this.canDisplay(n3) != bl) {
                return i;
            }
            if (!bl2) continue;
            bl2 = false;
            ++i;
        }
        return -1;
    }

    protected int canDisplayUpTo(String string, int n, int n2, boolean bl) {
        boolean bl2 = false;
        for (int i = n; i < n2; ++i) {
            char c;
            int n3 = string.charAt(i);
            if ((n3 & 0xFC00) == 55296 && i + 1 < n2 && ((c = string.charAt(i + 1)) & 0xFC00) == 56320) {
                bl2 = true;
                n3 = V2CMiscUtil.toCodePoint(n3, c);
            }
            if (this.canDisplay(n3) != bl) {
                return i;
            }
            if (!bl2) continue;
            bl2 = false;
            ++i;
        }
        return -1;
    }

    int getCharWidth(int n, FontRenderContext fontRenderContext) {
        return this.getCharWidth(n, fontRenderContext, true, false, false);
    }

    int getCharWidth(int n, FontRenderContext fontRenderContext, boolean bl, boolean bl2, boolean bl3) {
        int n2;
        int n3;
        Object object;
        boolean bl4 = true;
        if (!this.canDisplay(n)) {
            if (bl2) {
                return -1;
            }
            if (bl3 && fontRenderContext != null && (object = (Object)V2CFont.getAvailableFont(this.getAwtFont(), n)) != null) {
                int n4;
                char[] cArray = clCharWidthBuffer;
                if (n < 65536) {
                    cArray[0] = (char)n;
                    n4 = 1;
                } else {
                    cArray[0] = (char)((n -= 65536) >>> 10 & 0x3FF | 0xD800);
                    cArray[1] = (char)(n & 0x3FF | 0xDC00);
                    n4 = 2;
                }
                Rectangle2D rectangle2D = ((Font)object).getStringBounds(cArray, 0, n4, fontRenderContext);
                return (int)rectangle2D.getWidth();
            }
        }
        if (bl && n < 65536 && (n3 = ilCacheIndex[n]) >= 0) {
            int n5 = this.blWidthCache[n3] & 0xFF;
            if (n5 == 255) {
                char[] cArray = clCharWidthBuffer;
                cArray[0] = (char)n;
                Rectangle2D rectangle2D = this.getAwtFont().getStringBounds(cArray, 0, 1, fontRenderContext);
                n5 = (int)rectangle2D.getWidth();
                if (n5 >= 255) {
                    n5 = 254;
                }
                this.blWidthCache[n3] = (byte)n5;
            }
            return n5;
        }
        object = clCharWidthBuffer;
        if (n < 65536) {
            object[0] = (char)n;
            n2 = 1;
        } else {
            object[0] = (char)((n -= 65536) >>> 10 & 0x3FF | 0xD800);
            object[1] = (char)(n & 0x3FF | 0xDC00);
            n2 = 2;
        }
        Rectangle2D rectangle2D = this.getAwtFont().getStringBounds((char[])object, 0, n2, fontRenderContext);
        return (int)rectangle2D.getWidth();
    }

    Rectangle2D getStringBounds(CharSequence charSequence, int n, int n2, FontRenderContext fontRenderContext) {
        int n3 = 0;
        for (int i = n; i < n2; ++i) {
            int n4;
            Rectangle2D rectangle2D;
            int n5;
            int n6 = charSequence.charAt(i);
            if ((n6 & 0xFC00) == 55296 && i + 1 < n2 && ((n5 = (int)charSequence.charAt(i + 1)) & 0xFC00) == 56320) {
                ++i;
                n6 = V2CMiscUtil.toCodePoint(n6, n5);
            }
            int n7 = n5 = n6 < 65536 ? ilCacheIndex[n6] : -1;
            if (n5 >= 0) {
                int n8 = this.blWidthCache[n5] & 0xFF;
                if (n8 == 255) {
                    char[] cArray = clCharWidthBuffer;
                    cArray[0] = (char)n6;
                    rectangle2D = this.getAwtFont().getStringBounds(cArray, 0, 1, fontRenderContext);
                    n8 = (int)rectangle2D.getWidth();
                    if (n8 >= 255) {
                        n8 = 254;
                    }
                    this.blWidthCache[n5] = (byte)n8;
                }
                n3 += n8;
                continue;
            }
            char[] cArray = clCharWidthBuffer;
            if (n6 < 65536) {
                cArray[0] = (char)n6;
                n4 = 1;
            } else {
                cArray[0] = (char)((n6 -= 65536) >>> 10 & 0x3FF | 0xD800);
                cArray[1] = (char)(n6 & 0x3FF | 0xDC00);
                n4 = 2;
            }
            rectangle2D = this.getAwtFont().getStringBounds(cArray, 0, n4, fontRenderContext);
            n3 += (int)rectangle2D.getWidth();
        }
        return new Rectangle2D.Float(0.0f, -this.nAscent, n3, this.nAscent + this.nDescent);
    }

    void createWidthCache() {
        this.createWidthCache(false);
    }

    void createWidthCache(boolean bl) {
        if (!bl && this.blWidthCache != null) {
            return;
        }
        this.blWidthCache = this.getWidthCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[] getWidthCache() {
        String string = this.baseFont.getFaceName() + ":" + (int)this.fSize;
        byte[] byArray = null;
        HashMap hashMap = hmWidthCache;
        synchronized (hashMap) {
            Object v = hmWidthCache.get(string);
            if (v != null) {
                return (byte[])v;
            }
            byArray = new byte[nFrequentChars];
            Arrays.fill(byArray, (byte)-1);
            hmWidthCache.put(string, byArray);
        }
        return byArray;
    }

    float getSize() {
        return this.fSize;
    }

    String getName() {
        return this.sName;
    }

    V2CBaseFont getBaseFont() {
        return this.baseFont;
    }

    Font getAwtFont() {
        Font font = this.awtFont;
        if (this.bRecreateAwtFont || font == null) {
            font = this.createAwtFont();
        }
        return font;
    }

    boolean getStyleValue(int n) {
        return this.blStyle[n];
    }

    Color getForeground() {
        return this.cForeground;
    }

    Color getBackground() {
        return this.cBackground;
    }

    void setDefault() {
        this.setBaseFont(V2CBaseFont.getDefaultBaseFont());
        this.fSize = 12.0f;
        this.cForeground = Color.BLACK;
        fDefaultFont = this;
        hmFont.put(DEFAULTNAME, this);
    }

    void setFontParameters(Graphics graphics) {
        graphics.setFont(this.getAwtFont());
        if (this.cForeground != null) {
            graphics.setColor(this.cForeground);
        }
    }

    void propagateChange() {
        this.propagateChange(false);
    }

    void propagateChange(boolean bl) {
        if (bl) {
            this.createWidthCache(true);
        }
        int n = this.alChildren.size();
        for (int i = 0; i < n; ++i) {
            ((V2CFont)this.alChildren.get(i)).parentChanged(bl);
        }
    }

    void parentChanged(boolean bl) {
        if (this.fParent == null) {
            return;
        }
        if (this.bBaseFontUseParent) {
            this.setBaseFont(this.fParent.baseFont, true);
        }
        if (this.bSizeUseParent) {
            this.setSize(this.fParent.fSize, true);
        }
        for (int i = 0; i < this.blStyle.length; ++i) {
            if (!this.blUseParent[i]) continue;
            if (i == 1 && this.fParent.blStyle[1] != this.blStyle[1]) {
                this.bRecreateAwtFont = true;
            }
            this.blStyle[i] = this.fParent.blStyle[i];
        }
        if (this.bForegroundUseParent) {
            this.setForeground(this.fParent.cForeground, true);
        }
        if (this.bBackgroundUseParent) {
            this.setBackground(this.fParent.cBackground, true);
        }
        if (bl) {
            this.createWidthCache(true);
        }
        this.propagateChange(bl);
    }

    public String toString() {
        return this.sName;
    }

    static {
        int n;
        slStyleValues = new String[]{"BOLD", "ITALIC", "UNDERLINE", "STRIKE", "REVERSE", "BOLDUNDERLINE"};
        hmFont = new HashMap();
        DEFAULTNAME = "Default";
        ilFrequentChars = new int[]{32, 60, 62, 12288, 47, 48, 114, 58, 49, 97, 101, 98, 12398, 116, 103, 50, 51, 46, 12375, 12435, 115, 34, 12356, 12394, 59, 52, 54, 68, 105, 73, 53, 12373, 57, 12390, 55, 110, 56, 12387, 12290, 12363, 28961, 21517, 12383, 38, 12392, 12391, 12395, 39080, 35895, 108, 12399, 61, 12427, 12364, 12289, 99, 12384, 104, 12358, 95, 12540, 100, 109, 12418, 12425, 102, 107, 12539, 12428, 12414, 12377, 124, 111, 39, 44, 12434, 12531, 12371, 12354, 12426, 45, 12367, 12369, 12424, 112, 12473, 12381, 119, 65311, 12393, 12365, 12524, 12452, 12450, 65343, 12360, 117, 12385, 12362, 65507, 65, 106, 12521, 12488, 33, 77, 12523, 69, 12419, 12420, 65281, 79, 40, 12541, 12429, 41, 83, 12483, 86, 12522, 121, 12376, 12388, 84, 67, 80, 65380, 65288, 20154, 12431, 78, 12397, 118, 12513, 66, 12415, 120, 82, 76, 74, 85, 65289, 12479, 71, 72, 12463, 88, 113, 70, 75, 87, 35211, 12300, 12301, 89, 122, 65295, 65438, 81, 90, 43, 12525, 12491, 8230, 12510, 24605, 63, 12417, 20316, 20986, 12471, 12379, 65340, 35441, 12489, 9473, 12472, 19968, 12501, 65439, 12461, 180, 65381, 12400, 12459, 12515, 26085, 96, 35328, 65344, 12467, 65374, 12486, 20170, 20998, 12458, 27671, 12401, 12503, 12496, 21069, 12490, 8208, 65392, 12494, 12454, 26412, 12423, 12456, 12464, 23376, 22823, 26368, 20013, 12481, 26178, 20309, 22238, 12378, 12353, 12487, 26041, 12512, 12469, 65417, 12451, 65312, 38291, 12411, 12511, 65418, 20107, 65310, 33145, 33258, 65306, 19978, 65297, 65298, 24460, 12493, 12480, 12460, 21205, 26376, 24863, 26469, 9472, 12497, 12502, 20351, 30011, 12499, 21407, 20474, 29983, 20837, 65437, 126, 20840, 12495, 23450, 12517, 65367, 30340, 21512, 65408, 65383, 25918, 65394, 30446, 12508, 34892, 32066, 12474, 24180, 32773, 8213, 8704, 22899, 23455, 12372, 12416, 25163, 24847, 26360, 36949, 12366, 21516, 20108, 1044, 22793, 33391, 12370, 9632, 38754, 12519, 12514, 12449, 12382, 12468, 22320, 30693, 65296, 26032, 22580, 36865, 8743, 29702, 12466, 24403, 8978, 36890, 12477, 30058, 27700, 35501, 20197, 30330, 20307, 19979, 12409, 26399, 38306, 21021, 12406, 65356, 37096, 30333, 24230, 22909, 12542, 12408, 12475, 12455, 12500, 12527, 65309, 12484, 31532, 9675, 38283, 65299, 19981, 21619, 19977, 36913, 12465, 29289, 12509, 32080, 30000, 21147, 23569, 22768, 12368, 27515, 27096, 20104, 26495, 36796, 31435, 12505, 65412, 12305, 9633, 65414, 9670, 12304, 12402, 22810, 22806, 26126, 24746, 29992, 12470, 12403, 9834, 12413, 27491, 25126, 36023, 39640, 23567, 24615, 12516, 20184, 38899, 65316, 23550, 65405, 29256, 33021, 30452, 12462, 20844, 65399, 21270, 12293, 20808, 25345, 65398, 12412, 20869, 12405, 32771, 35373, 12445, 21697, 38263, 22770, 12374, 24515, 32654, 42, 21839, 35299, 65404, 12457, 34920, 27425, 65432, 30906, 32068, 27005, 12359, 65434, 65420, 123, 28431, 29694, 8594, 24819, 21029, 25152, 24453, 33804, 20999, 38988, 21462, 65400, 12422, 35201, 20182, 36942, 65308, 31070, 32862, 12380, 20027, 32232, 36899, 20250, 23398, 19990, 25104, 36817, 65391, 125, 26144, 12532, 24773, 12506, 25968, 35486, 35504, 32154, 24859, 65423, 25991, 28982, 27231, 37329, 26481, 35500, 27969, 12507, 21531, 30495, 23478, 22269, 65372, 21487, 29305, 26222, 65407, 65300, 31169, 12498, 20195, 24059, 22818, 22900, 27083, 27770, 26395, 24540, 20778, 33853, 94, 26356, 35352, 9475, 27442, 65313, 24375, 65431, 65334, 12396, 20181, 65421, 30028, 65294, 24517, 35222, 9679, 20449, 65301, 37, 32117, 23665, 9474, 37326, 22812, 28436, 27578, 31505, 21322, 65433, 20877, 21521, 65402, 30007, 25945, 31034, 27468, 22577, 22987, 36523, 37682, 65327, 20803, 65377, 33865, 28857, 38663, 21578, 30528, 65393, 25551, 26410, 36948, 24471, 65293, 30456, 21046, 65424, 37325, 31966, 24029, 27490, 36215, 24335, 12389, 33394, 21213, 23433, 20687, 39764, 24341, 36275, 26089, 35251, 12504, 27531, 28779, 36953, 93, 12404, 20418, 28023, 9734, 27861, 23616, 12421, 30435, 65362, 91, 27663, 65395, 23637, 38480, 28040, 12407, 31354, 9733, 38598, 22312, 30331, 21152, 27841, 39135, 35, 65436, 32884, 24120, 22825, 29366, 24441, 21435, 12476, 26408, 35242, 30001, 31278, 65422, 23436, 21313, 8834, 38957, 21336, 31038, 28145, 20043, 25237, 25731, 22303, 24417, 65307, 12518, 21644, 12355, 32622, 35226, 65317, 38996, 12302, 32032, 65388, 26377, 20855, 23481, 65331, 22985, 23244, 27598, 65303, 23627, 65328, 12303, 30563, 27963, 20379, 36074, 21453, 24373, 40658, 65302, 24107, 65342, 23384, 26332, 26684, 26143, 38651, 20889, 24907, 21416, 29579, 20491, 26354, 23389, 21463, 28459, 65419, 65384, 12291, 32218, 65435, 65304, 36947, 31995, 65411, 21475, 12361, 26397, 36960, 12297, 65305, 23383, 1076, 35469, 65315, 21729, 39131, 22763, 36229, 31361, 8595, 20301, 22833, 65428, 36861, 21028, 38627, 20253, 39340, 26989, 31243, 20140, 27874, 24444, 21488, 35542, 20804, 65409, 20385, 39364, 8801, 20057, 65332, 36820, 32020, 22969, 32118, 25351, 12357, 23449, 27966, 38972, 25244, 65397, 39321, 23431, 23517, 36000, 26657, 36914, 27604, 969, 65401, 20870, 27507, 25925, 35519, 28608, 38555, 23798, 36578, 20102, 24536, 26524, 31456, 65286, 35379, 38738, 65413, 29190, 20055, 65353, 36895, 25216, 20284, 30707, 27875, 21106, 21033, 36984, 31561, 20174, 22937, 24418, 30342, 12296, 20445, 32210, 20117, 22826, 33618, 22730, 39000, 35215, 36794, 28288, 38500, 36884, 24179, 65314, 21315, 36020, 25913, 35199, 33050, 36933, 20303, 65427, 21629, 38915, 37070, 35413, 32004, 21451, 34899, 23621, 35937, 35672, 65426, 36870, 65403, 24112, 32681, 36867, 21442, 31227, 38750, 27704, 22827, 31934, 37197, 26082, 38477, 36617, 25915, 21454, 65326, 35430, 20363, 24535, 24565, 20498, 39658, 20932, 21628, 8746, 20022, 215, 39729, 65319, 36893, 65396, 38360, 92, 26029, 65369, 12444, 25147, 28858, 29699, 33510, 12443, 33075, 20462, 65389, 27573, 31105, 40575, 24494, 21271, 24195, 12530, 21476, 20302, 65325, 64, 22411, 22522, 32076, 26149, 37117, 20083, 21481, 19975, 8744, 21495, 36196, 65416, 27665, 24651, 65379, 65386, 65390, 26381, 22679, 32207, 20037, 65291, 20966, 22258, 8745, 21360, 25506, 35422, 12520, 27597, 65378, 24489, 25171, 65292, 21127, 23822, 24184, 26132, 26009, 25973, 35336, 8593, 23019, 8221, 35239, 25563, 20171, 12410, 20214, 31295, 34276, 35377, 26908, 31216, 36554, 8251, 30772, 25276, 35069, 20809, 20006, 9678, 32025, 21161, 35696, 33564, 39443, 65410, 20313, 24433, 38538, 12478, 8242, 20596, 36208, 30053, 24066, 35036, 12446, 8835, 35023, 20001, 24215, 36557, 29238, 21177, 29575, 23064, 35013, 31471, 20849, 32048, 34880, 23470, 8592, 21066, 38626, 26086, 24046, 22856, 12492, 28187, 36, 26449, 31179, 37327, 30064, 23432, 29577, 24754, 23475, 24111, 24598, 20105, 8736, 8756, 36939, 23039, 8757, 27880, 24037, 19976, 26411, 65329, 25943, 32013, 20206, 35468, 26522, 20219, 38609, 22259, 25105, 25201, 20304, 12386, 26152, 36234, 22120, 30334, 25014, 33509, 20516, 20241, 65337, 36896, 21491, 65323, 29356, 22290, 30427, 26441, 21335, 23713, 65330, 26063, 27810, 29105, 20024, 33457};
        ilCacheIndex = new int[65536];
        hmWidthCache = new HashMap();
        String string = V2CApp.getUserProperty().get(sCheckCharsKey);
        if (string != null) {
            int n2 = string.length();
            if (n2 >= 1) {
                boolean bl = bCheckFontChars = string.charAt(0) == 'c';
            }
            if (n2 >= 2) {
                bCheckPUAChars = string.charAt(1) == 'p';
            }
        }
        int[] nArray = ilCacheIndex;
        Arrays.fill(nArray, -1);
        int[] nArray2 = ilFrequentChars;
        nFrequentChars = n = nArray2.length;
        for (int i = 0; i < n; ++i) {
            nArray[nArray2[i]] = i;
        }
        blChar2Font = new byte[262144];
        clCharWidthBuffer = new char[2];
    }
}

