/*
 * Decompiled with CFR 0.152.
 */
package org.monazilla.v2c;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import org.monazilla.v2c.V2CBeIDListItem;
import org.monazilla.v2c.V2CLocalFileHandler;
import org.monazilla.v2c.V2CMiscUtil;
import org.monazilla.v2c.V2CSaveFile;

public class V2CCookie {
    private static final String sCookieFile = "cookie.txt";
    private static final String sBeMailName = "DMDM";
    private static final String sBeCodeName = "MDMD";
    private static final Object vBeLoginMonitor = new Object();
    static String sDMDMValue;
    static String sMDMDValue;
    private static final ArrayList alCookieList;
    private static boolean bRestored;
    private static boolean bChanged;
    String sRaw;
    String sName;
    String sValue;
    String sDomain;
    String sPath;
    long ltExpires;
    int nMaxAge;
    boolean bMaxAge;
    long ltMaxAgeOrigin;
    boolean bValid;
    URL uURL;
    private static SimpleDateFormat[] lSimpleDateFormat;

    static Object getBeLoginMonitor() {
        sMDMDValue = null;
        sDMDMValue = null;
        return vBeLoginMonitor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean hasHAP(boolean bl) {
        ArrayList arrayList;
        ArrayList arrayList2 = arrayList = alCookieList;
        synchronized (arrayList2) {
            for (int i = arrayList.size() - 1; i >= 0; --i) {
                String string;
                URL uRL;
                V2CCookie v2CCookie = (V2CCookie)arrayList.get(i);
                String string2 = v2CCookie.sName;
                if (string2 == null || !string2.equals("HAP") || (uRL = v2CCookie.uURL) == null || !(string = uRL.getHost().toLowerCase()).endsWith(bl ? ".bbspink.com" : ".2ch.net")) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void discardHAP(boolean bl) {
        ArrayList arrayList;
        ArrayList arrayList2 = arrayList = alCookieList;
        synchronized (arrayList2) {
            boolean bl2 = false;
            for (int i = arrayList.size() - 1; i >= 0; --i) {
                String string;
                URL uRL;
                V2CCookie v2CCookie = (V2CCookie)arrayList.get(i);
                String string2 = v2CCookie.sName;
                if (string2 == null || !string2.equals("HAP") || (uRL = v2CCookie.uURL) == null || !(string = uRL.getHost().toLowerCase()).endsWith(bl ? ".bbspink.com" : ".2ch.net")) continue;
                bl2 = true;
                arrayList.remove(i);
            }
            if (bl2) {
                bChanged = true;
                V2CCookie.saveCookies();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void addCookie(String string, URL uRL) {
        ArrayList arrayList;
        V2CCookie.restoreCookies();
        V2CCookie v2CCookie = new V2CCookie(string, uRL, null);
        if (!v2CCookie.isValid()) {
            v2CCookie.printErrorMessage();
            return;
        }
        if (!v2CCookie.miscCheck()) {
            return;
        }
        if (v2CCookie.sDomain.endsWith(".2ch.net") && v2CCookie.sPath.equals("/")) {
            if (v2CCookie.sName.equals(sBeMailName)) {
                sDMDMValue = v2CCookie.sValue;
                return;
            }
            if (v2CCookie.sName.equals(sBeCodeName)) {
                sMDMDValue = v2CCookie.sValue;
                return;
            }
        }
        bChanged = true;
        boolean bl = v2CCookie.bMaxAge && v2CCookie.nMaxAge == 0;
        ArrayList arrayList2 = arrayList = alCookieList;
        synchronized (arrayList2) {
            for (int i = 0; i < arrayList.size(); ++i) {
                if (!v2CCookie.matches((V2CCookie)arrayList.get(i))) continue;
                if (bl) {
                    arrayList.remove(i);
                } else {
                    arrayList.set(i, v2CCookie);
                }
                return;
            }
            if (!bl) {
                arrayList.add(v2CCookie);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void removeCookie(String string, String string2, String string3) {
        ArrayList arrayList;
        V2CCookie.restoreCookies();
        ArrayList arrayList2 = arrayList = alCookieList;
        synchronized (arrayList2) {
            for (int i = 0; i < arrayList.size(); ++i) {
                V2CCookie v2CCookie = (V2CCookie)arrayList.get(i);
                if (!v2CCookie.matches(string, string2, string3)) continue;
                bChanged = true;
                arrayList.remove(i--);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String getOneCookieValue(String string, String string2, String string3) {
        ArrayList arrayList;
        V2CCookie.restoreCookies();
        ArrayList arrayList2 = arrayList = alCookieList;
        synchronized (arrayList2) {
            for (int i = 0; i < arrayList.size(); ++i) {
                V2CCookie v2CCookie = (V2CCookie)arrayList.get(i);
                if (!v2CCookie.matches(string, string2, string3)) continue;
                return v2CCookie.sValue;
            }
        }
        return null;
    }

    static String getCookie(URL uRL) {
        return V2CCookie.getCookie(uRL, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String getCookie(URL uRL, V2CBeIDListItem v2CBeIDListItem) {
        V2CCookie v2CCookie;
        int n;
        V2CCookie.restoreCookies();
        ArrayList arrayList = alCookieList;
        if (arrayList.size() == 0) {
            return null;
        }
        ArrayList<V2CCookie> arrayList2 = new ArrayList<V2CCookie>();
        ArrayList arrayList3 = arrayList;
        synchronized (arrayList3) {
            long l = System.currentTimeMillis();
            for (int i = 0; i < arrayList.size(); ++i) {
                V2CCookie v2CCookie2 = (V2CCookie)arrayList.get(i);
                if (v2CCookie2.ltExpires > 0L && v2CCookie2.ltExpires < l) {
                    bChanged = true;
                    arrayList.remove(i--);
                    continue;
                }
                String string = v2CCookie2.sName;
                if (string.equals(sBeMailName) || string.equals(sBeCodeName) || !v2CCookie2.applicableTo(uRL)) continue;
                for (int j = 0; j < arrayList2.size(); ++j) {
                    if (v2CCookie2.compareTo((V2CCookie)arrayList2.get(j)) < 0) continue;
                    arrayList2.add(j, v2CCookie2);
                    v2CCookie2 = null;
                    break;
                }
                if (v2CCookie2 == null) continue;
                arrayList2.add(v2CCookie2);
            }
        }
        boolean bl = false;
        for (n = arrayList2.size() - 1; n >= 0; --n) {
            v2CCookie = (V2CCookie)arrayList2.get(n);
            if (!v2CCookie.isValid() || !v2CCookie.sName.equalsIgnoreCase("HAP") || !v2CCookie.sDomain.equalsIgnoreCase(".2ch.net") && !v2CCookie.sDomain.equalsIgnoreCase(".bbspink.com") || !v2CCookie.sPath.equals("/")) continue;
            bl = true;
            break;
        }
        if (bl) {
            for (n = arrayList2.size() - 2; n >= 0; --n) {
                v2CCookie = (V2CCookie)arrayList2.get(n);
                if (!v2CCookie.isValid() || !v2CCookie.sName.equalsIgnoreCase("HAP") || (v2CCookie.sDomain.length() <= 8 || !v2CCookie.sDomain.endsWith(".2ch.net")) && (v2CCookie.sDomain.length() <= 12 || !v2CCookie.sDomain.endsWith(".bbspink.com")) || !v2CCookie.sPath.equals("/")) continue;
                arrayList2.remove(n);
                arrayList2.add(v2CCookie);
            }
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < arrayList2.size(); ++i) {
            V2CCookie v2CCookie3 = (V2CCookie)arrayList2.get(i);
            stringBuffer.append(v2CCookie3.sName + '=' + v2CCookie3.sValue + "; ");
        }
        if (v2CBeIDListItem != null) {
            stringBuffer.append("DMDM=" + v2CBeIDListItem.sDMDM + "; " + sBeCodeName + '=' + v2CBeIDListItem.sMDMD + "; ");
        }
        return stringBuffer.length() > 0 ? stringBuffer.substring(0, stringBuffer.length() - 2) : null;
    }

    static synchronized void restoreCookies() {
        if (bRestored) {
            return;
        }
        bRestored = true;
        BufferedReader bufferedReader = V2CLocalFileHandler.getUserSaveFileReader(sCookieFile);
        if (bufferedReader == null) {
            return;
        }
        try {
            String string;
            while ((string = bufferedReader.readLine()) != null) {
                URL uRL;
                int n;
                if (string.length() == 0 || string.charAt(0) == '#') continue;
                String string2 = null;
                int n2 = 0;
                char c = string.charAt(0);
                if (c >= '0' && c <= '9') {
                    n2 = string.indexOf(9);
                    if (n2 < 0) continue;
                    string2 = string.substring(0, n2);
                    ++n2;
                }
                if ((n = string.indexOf(9, n2)) < 0) continue;
                String string3 = string.substring(n + 1);
                try {
                    uRL = new URL(string.substring(n2, n));
                }
                catch (MalformedURLException malformedURLException) {
                    V2CMiscUtil.printMalformedURLException(malformedURLException);
                    continue;
                }
                V2CCookie v2CCookie = new V2CCookie(string3, uRL, string2);
                if (v2CCookie.sName == null) continue;
                alCookieList.add(v2CCookie);
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static void saveCookies() {
        ArrayList arrayList;
        ArrayList arrayList2 = arrayList = alCookieList;
        synchronized (arrayList2) {
            V2CSaveFile v2CSaveFile;
            block11: {
                if (!bChanged) {
                    return;
                }
                bChanged = false;
                v2CSaveFile = new V2CSaveFile(sCookieFile);
                BufferedWriter bufferedWriter = v2CSaveFile.getWriter();
                if (bufferedWriter == null) {
                    bChanged = true;
                    return;
                }
                long l = System.currentTimeMillis();
                try {
                    try {
                        for (int i = 0; i < arrayList.size(); ++i) {
                            String string;
                            V2CCookie v2CCookie = (V2CCookie)arrayList.get(i);
                            if (v2CCookie.ltExpires < l) continue;
                            if (v2CCookie.bMaxAge) {
                                if (v2CCookie.nMaxAge == 0) continue;
                                bufferedWriter.write(String.valueOf(v2CCookie.ltMaxAgeOrigin / 1000L));
                                bufferedWriter.write(9);
                            }
                            if ((string = v2CCookie.getURLString()) != null && string.length() > 0) {
                                bufferedWriter.write(string);
                            }
                            bufferedWriter.write(9);
                            bufferedWriter.write(v2CCookie.sRaw);
                            bufferedWriter.newLine();
                        }
                        v2CSaveFile.setOK();
                    }
                    catch (IOException iOException) {
                        bChanged = true;
                        Object var10_10 = null;
                        V2CLocalFileHandler.closeWriter(bufferedWriter);
                        break block11;
                    }
                    Object var10_9 = null;
                }
                catch (Throwable throwable) {
                    Object var10_11 = null;
                    V2CLocalFileHandler.closeWriter(bufferedWriter);
                    throw throwable;
                }
                V2CLocalFileHandler.closeWriter(bufferedWriter);
            }
            v2CSaveFile.replaceTmpFile();
            return;
        }
    }

    static long parseHttpDate(String string) {
        if (string == null) {
            return 0L;
        }
        SimpleDateFormat[] simpleDateFormatArray = lSimpleDateFormat;
        for (int i = 0; i < simpleDateFormatArray.length; ++i) {
            ParsePosition parsePosition = new ParsePosition(0);
            Date date = simpleDateFormatArray[i].parse(string, parsePosition);
            if (date == null) continue;
            return date.getTime();
        }
        return -1L;
    }

    public V2CCookie(String string, URL uRL, String string2) {
        this.uURL = uRL;
        this.bValid = false;
        this.sRaw = string;
        if (string2 != null) {
            this.ltMaxAgeOrigin = V2CMiscUtil.parseLong(string2) * 1000L;
        }
        this.parseCookieString(string, uRL);
    }

    private void printErrorMessage() {
        if (this.bValid) {
            return;
        }
    }

    void parseCookieString(String string, URL uRL) {
        int n;
        String string2;
        if (string == null || string.length() < 3) {
            return;
        }
        String[] stringArray = string.split("\\s*;\\s*");
        if (!this.parseNameAndValue(stringArray[0])) {
            return;
        }
        int n2 = stringArray.length;
        for (int i = 1; i < n2; ++i) {
            string2 = stringArray[i];
            if (this.parseFields(string2) || string2.equalsIgnoreCase("HttpOnly") || string2.equalsIgnoreCase("secure")) continue;
            return;
        }
        String string3 = this.sDomain;
        if (string3 != null && string3.length() > 0 && string3.charAt(0) != '.') {
            this.sDomain = string3 = '.' + string3;
        }
        if (uRL != null) {
            if (this.sDomain == null) {
                this.sDomain = uRL.getHost();
            }
            if (this.sPath == null) {
                string2 = uRL.getPath();
                if (string2.length() == 1) {
                    this.sPath = string2;
                } else {
                    n = string2.lastIndexOf(47);
                    if (n == 0) {
                        this.sPath = string2.substring(0, 1);
                    } else if (n > 0) {
                        this.sPath = string2.substring(0, n);
                    }
                }
            }
        }
        if (this.sName == null || this.sName.length() == 0 || this.sDomain == null || this.sDomain.length() == 0 || this.sPath == null) {
            return;
        }
        if (uRL != null) {
            string2 = uRL.getPath();
            if (string2.length() > 0 && !string2.startsWith(this.sPath)) {
                return;
            }
            string3 = this.sDomain;
            n = string3.length();
            if (string3.lastIndexOf(46) == 0) {
                return;
            }
            String string4 = uRL.getHost();
            if (string4.length() > 0) {
                char c = string4.charAt(0);
                if (c >= '0' && c <= '9' && string4.matches("(?:\\d+\\.){3}\\d+")) {
                    if (!string4.equals(string3)) {
                        return;
                    }
                } else if (!(string3.equals(string4) || string3.charAt(0) == '.' && string3.regionMatches(true, 1, string4, 0, string4.length()))) {
                    if (string4.indexOf(46) != string4.length() - string3.length()) {
                        return;
                    }
                    if (!string4.toLowerCase().endsWith(string3.toLowerCase())) {
                        return;
                    }
                }
            }
        }
        this.bValid = true;
    }

    boolean parseFields(String string) {
        int n = string.indexOf(61);
        if (n < 0) {
            return false;
        }
        String string2 = string.substring(0, n).toLowerCase();
        String string3 = string.substring(n + 1, string.length());
        if (string2.equals("domain")) {
            this.sDomain = string3;
        } else if (string2.equals("path")) {
            this.sPath = string3;
        } else if (string2.equals("max-age")) {
            this.nMaxAge = V2CMiscUtil.parseInt(string3);
            if (this.nMaxAge < 0) {
                return false;
            }
            this.bMaxAge = true;
            long l = this.ltMaxAgeOrigin;
            if (l <= 0L) {
                this.ltMaxAgeOrigin = l = System.currentTimeMillis();
            }
            this.ltExpires = (long)this.nMaxAge * 1000L + l;
        } else if (string2.equals("expires")) {
            this.ltExpires = this.parseExpiresString(string3);
            if (this.ltExpires < 0L) {
                return false;
            }
        } else if (string2.equals("version")) {
            if (!string3.equals("1")) {
                return false;
            }
        } else if (!string2.equals("comment")) {
            System.out.println("Unknown field: " + string2);
            return false;
        }
        return true;
    }

    long parseExpiresString(String string) {
        if (string.length() < 10) {
            return -1L;
        }
        if (string.length() == 27 && string.charAt(11) == '-' && string.charAt(14) == ' ') {
            string = string.substring(0, 12) + "20" + string.substring(12);
        }
        return V2CCookie.parseHttpDate(string);
    }

    boolean parseNameAndValue(String string) {
        int n = string.indexOf(61);
        if (n <= 0) {
            return false;
        }
        this.sName = string.substring(0, n).trim();
        this.sValue = string.substring(n + 1, string.length());
        return true;
    }

    public boolean applicableTo(URL uRL) {
        String string = uRL.getHost();
        String string2 = uRL.getPath();
        if (string == null || string2 == null) {
            return false;
        }
        String string3 = this.sDomain;
        boolean bl = string3.startsWith(".") ? string.endsWith(string3) || string.length() == string3.length() - 1 && string.regionMatches(0, string3, 1, string.length()) : string.equals(string3);
        boolean bl2 = this.sPath.endsWith("/") ? string2.startsWith(this.sPath) : (string2.length() < this.sPath.length() ? false : (string2.length() > this.sPath.length() ? string2.startsWith(this.sPath) && string2.charAt(this.sPath.length()) == '/' : string2.equals(this.sPath)));
        return bl && bl2;
    }

    boolean miscCheck() {
        if (this.sDomain.indexOf(".yourfilehost.com") >= 0) {
            return false;
        }
        if (this.sDomain.indexOf(".twitter.com") >= 0 && this.sName.matches("_twitter_sess|twid")) {
            return false;
        }
        return this.sDomain.indexOf(".twitpic.com") < 0;
    }

    public int compareTo(V2CCookie v2CCookie) {
        return this.sPath.length() - v2CCookie.sPath.length();
    }

    public boolean matches(V2CCookie v2CCookie) {
        return this.bValid && v2CCookie.isValid() && this.sName.equals(v2CCookie.sName) && this.sDomain.equals(v2CCookie.sDomain) && this.sPath.equals(v2CCookie.sPath);
    }

    boolean matches(String string, String string2, String string3) {
        return this.bValid && this.sName.equals(string) && this.sDomain.equals(string2) && this.sPath.equals(string3);
    }

    String getURLString() {
        return this.uURL.toString();
    }

    public boolean isValid() {
        return this.bValid;
    }

    public String toString() {
        return "name: " + this.sName + "\nvalue: " + this.sValue + "\ndomain: " + this.sDomain + "\npath: " + this.sPath + "\nexpires: " + new Date(this.ltExpires) + "\n";
    }

    static {
        alCookieList = new ArrayList();
        lSimpleDateFormat = new SimpleDateFormat[]{new SimpleDateFormat("EEE, dd-MMM-yyyy HH:mm:ss z"), new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z")};
    }
}

