/*
 * Decompiled with CFR 0.152.
 */
package org.monazilla.v2c;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JTabbedPane;
import javax.swing.colorchooser.DefaultColorSelectionModel;
import org.monazilla.v2c.V2CApp;
import org.monazilla.v2c.V2CMacQuaquaSupport;
import org.monazilla.v2c.V2CMain;
import org.monazilla.v2c.V2CPopupListener;
import org.monazilla.v2c.V2CSwingUtil;

public final class V2CColorSelectButton
extends JLabel {
    static final boolean bHasAlpha = V2CApp.javaVersionEqualOrGreaterThan(1, 7) && !V2CApp.isGTK();
    private static BGMouseListener bgMouseListener;
    final char cSaveKey;
    final boolean bAlpha;
    boolean bHasDefault;
    boolean bOverrideDefault;
    ArrayList alColorHistory;
    int nCurrentHistory;

    public V2CColorSelectButton() {
        this(null, '\u0000', false);
    }

    public V2CColorSelectButton(char c) {
        this(null, c, false);
    }

    public V2CColorSelectButton(Color color) {
        this(color, '\u0000', false);
    }

    public V2CColorSelectButton(Color color, boolean flag) {
        this(color, '\u0000', flag);
    }

    public V2CColorSelectButton(Color color, char c) {
        this(color, c, false);
    }

    public V2CColorSelectButton(Color color, char c, boolean flag) {
        super(" click ");
        this.cSaveKey = c;
        this.bAlpha = flag;
        this.setBorder(BorderFactory.createEtchedBorder(1));
        if (color != null) {
            if (flag && !bHasAlpha) {
                color = new Color(color.getRed(), color.getGreen(), color.getBlue());
            }
            this.setColor(color);
        }
        this.setOpaque(true);
        if (bgMouseListener == null) {
            bgMouseListener = new BGMouseListener();
        }
        this.addMouseListener(bgMouseListener);
        this.addMouseListener(new V2CPopupListener("ColorSel"));
    }

    void setHasDefault() {
        this.bHasDefault = true;
    }

    boolean hasDefault() {
        return this.bHasDefault;
    }

    void setOverrideDefault(boolean flag) {
        if (this.bHasDefault) {
            this.bOverrideDefault = flag;
        }
    }

    boolean getOverrideDefault() {
        return this.bOverrideDefault;
    }

    void setColor(Color color) {
        if (color == null) {
            return;
        }
        if (this.isShowing()) {
            int i;
            ArrayList<Color> arraylist = this.alColorHistory;
            if (arraylist == null) {
                this.alColorHistory = arraylist = new ArrayList<Color>();
                Color color1 = this.getBackground();
                if (color1 != null) {
                    arraylist.add(color1);
                }
            }
            if ((i = this.nCurrentHistory) + 1 < arraylist.size()) {
                int j = arraylist.size() - 1;
                while (j > i) {
                    arraylist.remove(j);
                    --j;
                }
            }
            arraylist.add(color);
            this.nCurrentHistory = i + 1;
        }
        this.setBackground(color);
    }

    void undoColor() {
        ArrayList arraylist = this.alColorHistory;
        if (arraylist == null) {
            return;
        }
        int i = this.nCurrentHistory;
        if (i <= 0) {
            return;
        }
        this.nCurrentHistory = --i;
        this.setBackground((Color)arraylist.get(i));
    }

    void redoColor() {
        ArrayList arraylist = this.alColorHistory;
        if (arraylist == null) {
            return;
        }
        int i = this.nCurrentHistory;
        if (i + 1 >= arraylist.size()) {
            return;
        }
        this.nCurrentHistory = ++i;
        this.setBackground((Color)arraylist.get(i));
    }

    Color getColor() {
        return this.getBackground();
    }

    void pasteColor() {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        if (clipboard == null) {
            return;
        }
        Transferable transferable = null;
        try {
            transferable = clipboard.getContents(null);
        }
        catch (IllegalStateException illegalstateexception) {
            System.out.println(illegalstateexception.getMessage());
        }
        if (transferable == null || !transferable.isDataFlavorSupported(DataFlavor.stringFlavor)) {
            return;
        }
        Object obj = null;
        try {
            obj = transferable.getTransferData(DataFlavor.stringFlavor);
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
        }
        if (!(obj instanceof String)) {
            return;
        }
        String s = (String)obj;
        if (s.length() > 8) {
            return;
        }
        Matcher matcher = Pattern.compile("\\s*(?:#|0x)?((?:[0-9A-F]{3}){1,2})\\s*", 2).matcher(s);
        if (!matcher.matches()) {
            return;
        }
        Color color = V2CSwingUtil.parseHexColorString(matcher.group(1));
        if (color != null) {
            this.setColor(color);
        }
    }

    char getSaveKey() {
        return this.cSaveKey;
    }

    void performAction(String s) {
        if (s == null) {
            return;
        }
        if (s.equals("Copy")) {
            String s1 = V2CSwingUtil.colorToString(this.getColor());
            if (s1 != null && s1.length() == 7 && s1.charAt(0) == '#') {
                V2CMain.copyString(s1.substring(1));
            }
        } else if (s.equals("Paste")) {
            this.pasteColor();
        } else if (s.equals("Undo")) {
            this.undoColor();
        } else if (s.equals("Redo")) {
            this.redoColor();
        }
    }

    private static class BGMouseListener
    extends MouseAdapter {
        @Override
        public void mouseClicked(MouseEvent mouseevent) {
            Color color;
            Component component;
            block14: {
                component = mouseevent.getComponent();
                if (!(component instanceof V2CColorSelectButton)) {
                    return;
                }
                V2CColorSelectButton v2ccolorselectbutton = (V2CColorSelectButton)component;
                color = null;
                try {
                    JColorChooser jcolorchooser;
                    OpaqueColorSelectionModel opaquecolorselectionmodel;
                    block15: {
                        if (v2ccolorselectbutton.bAlpha || !bHasAlpha) {
                            color = JColorChooser.showDialog(V2CMain.v2cMain, "Background Color", component.getBackground());
                            break block14;
                        }
                        opaquecolorselectionmodel = new OpaqueColorSelectionModel(component.getBackground());
                        jcolorchooser = new JColorChooser(opaquecolorselectionmodel);
                        JTabbedPane jtabbedpane = null;
                        for (int i = jcolorchooser.getComponentCount() - 1; i >= 0; --i) {
                            Component component1 = jcolorchooser.getComponent(i);
                            if (!(component1 instanceof JTabbedPane)) continue;
                            jtabbedpane = (JTabbedPane)component1;
                            break;
                        }
                        if (jtabbedpane == null) break block15;
                        int j = jtabbedpane.getTabCount() - 1;
                        while (j >= 0) {
                            block16: {
                                int byte0;
                                Container container;
                                Component component2;
                                block18: {
                                    String s;
                                    block17: {
                                        component2 = jtabbedpane.getComponentAt(j);
                                        if (!(component2 instanceof Container)) break block16;
                                        container = (Container)component2;
                                        s = jtabbedpane.getTitleAt(j);
                                        if (!s.equals("CMYK")) break block17;
                                        byte0 = 4;
                                        break block18;
                                    }
                                    if (!s.equals("HSV") && !s.equals("HSL") && !s.equals("RGB")) break block16;
                                    byte0 = 3;
                                }
                                if (container.getComponentCount() == 1) {
                                    component2 = container.getComponent(0);
                                }
                                try {
                                    Class<?> class1 = component2.getClass();
                                    Field field = class1.getDeclaredField("panel");
                                    field.setAccessible(true);
                                    Object obj = field.get(component2);
                                    field.setAccessible(false);
                                    Field field1 = obj.getClass().getDeclaredField("spinners");
                                    field1.setAccessible(true);
                                    Object obj1 = field1.get(obj);
                                    field1.setAccessible(false);
                                    Object obj2 = ((Object[])obj1)[byte0];
                                    Method method = obj2.getClass().getDeclaredMethod("setVisible", Boolean.TYPE);
                                    method.setAccessible(true);
                                    method.invoke(obj2, Boolean.FALSE);
                                    method.setAccessible(false);
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                            --j;
                        }
                    }
                    JDialog jdialog = JColorChooser.createDialog(V2CMain.v2cMain, "Background Color", true, jcolorchooser, opaquecolorselectionmodel, null);
                    jdialog.setVisible(true);
                    jdialog.dispose();
                    color = opaquecolorselectionmodel.cSelColor;
                }
                catch (Throwable throwable) {
                    if (!V2CApp.isMacintosh() || !V2CMacQuaquaSupport.isQuaquaInstalled()) break block14;
                    V2CSwingUtil.showErrorMessage("\u8272\u9078\u629e\u30c0\u30a4\u30a2\u30ed\u30b0\u3092\u8868\u793a\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002\nQuaqua\u3092\u4f7f\u7528\u3057\u306a\u3044\u72b6\u614b\u3067\u8a2d\u5b9a\u3057\u3066\u307f\u3066\u304f\u3060\u3055\u3044\u3002");
                }
            }
            if (color == null) {
                return;
            }
            ((V2CColorSelectButton)component).setColor(color);
        }

        private BGMouseListener() {
        }
    }

    private static class OpaqueColorSelectionModel
    extends DefaultColorSelectionModel
    implements ActionListener {
        Color cSelColor;

        @Override
        public void setSelectedColor(Color color) {
            super.setSelectedColor(new Color(color.getRed(), color.getGreen(), color.getBlue()));
        }

        @Override
        public void actionPerformed(ActionEvent actionevent) {
            this.cSelColor = this.getSelectedColor();
        }

        OpaqueColorSelectionModel(Color color) {
            super(color);
        }
    }
}

