/*
 * Decompiled with CFR 0.152.
 */
package org.monazilla.v2c;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.MouseInputAdapter;
import org.monazilla.v2c.V2CAbstractThreadPanel;
import org.monazilla.v2c.V2CApp;
import org.monazilla.v2c.V2CHTMLPane;
import org.monazilla.v2c.V2CHttpUtil;
import org.monazilla.v2c.V2CMain;
import org.monazilla.v2c.V2CMiscUtil;
import org.monazilla.v2c.V2CPopupPanel;
import org.monazilla.v2c.V2CSwingUtil;
import org.monazilla.v2c.V2CThreadPopup;
import org.monazilla.v2c.V2CThreadStyle;

public final class V2CBePopup
extends V2CHTMLPane
implements V2CPopupPanel,
HyperlinkListener {
    static final String sBeCondKey = "ThreadView.BePopup";
    static Pattern pHTTP = Pattern.compile("([^=\"])(https?://[-_.!~*'()a-zA-Z0-9;/?:@&=+$,%#]+)");
    static Map hmProfiles = Collections.synchronizedMap(new HashMap());
    static Map hmFlogBookmarks = Collections.synchronizedMap(new HashMap());
    V2CAbstractThreadPanel vtpParent;
    Window jwPopupWindow;
    Container cContainer;
    JScrollPane jScrollPane;
    JLabel jlURL;
    Point pLocation;
    int iFlogIndex;
    final boolean bRemote;
    Thread thGetProfile;
    Thread thGetFlogBookmark;
    Integer iBeID;
    static Pattern pFlogScript = Pattern.compile("<script src=\"(http://www.flog.jp/[-_a-zA-Z0-9/]+.js)\" type=\"text/javascript\">");
    private static final Pattern pDivLeft = Pattern.compile("<div\\sid=\"leftside\">");
    private static final Pattern pDivRight = Pattern.compile("<div\\sid=\"rightside\">");
    private static final Pattern pDivContent = Pattern.compile("<div\\sid=\"content\">");

    static boolean hasCache(Integer integer) {
        return hmProfiles.containsKey(integer);
    }

    static String getSimpleInfo(Integer integer) {
        return (String)hmProfiles.get(integer);
    }

    private static String getBodyTextTagString() {
        return "<body bgcolor=\"" + V2CSwingUtil.colorToString(V2CThreadPopup.cPopupBG) + "\" text=\"" + V2CSwingUtil.colorToString(V2CThreadStyle.getDefaultForeground()) + "\">";
    }

    public V2CBePopup(V2CAbstractThreadPanel v2cabstractthreadpanel, Point point, Integer integer) {
        this(v2cabstractthreadpanel, null, point, integer, false);
    }

    public V2CBePopup(V2CAbstractThreadPanel v2cabstractthreadpanel, String s, Point point, Integer integer) {
        this(v2cabstractthreadpanel, s, point, integer, true);
    }

    private V2CBePopup(V2CAbstractThreadPanel v2cabstractthreadpanel, String s, Point point, Integer integer, boolean flag) {
        String s1;
        this.iBeID = integer;
        this.bRemote = flag;
        this.setBackground(V2CThreadPopup.cPopupBG);
        this.vtpParent = v2cabstractthreadpanel;
        this.pLocation = point;
        ClickListener clicklistener = new ClickListener(null);
        this.addMouseListener(clicklistener);
        this.addMouseMotionListener(clicklistener);
        this.addHyperlinkListener(this);
        this.jScrollPane = new JScrollPane(this);
        if (V2CApp.isUNIX()) {
            JWindow jwindow = new JWindow(V2CMain.v2cMain);
            this.jwPopupWindow = jwindow;
            this.cContainer = jwindow.getContentPane();
        } else {
            JDialog jdialog = new JDialog((Frame)V2CMain.v2cMain, false);
            this.jwPopupWindow = jdialog;
            jdialog.setUndecorated(true);
            this.cContainer = jdialog.getContentPane();
        }
        this.cContainer.add((Component)this.jScrollPane, "Center");
        this.jwPopupWindow.setLocation(point);
        this.jwPopupWindow.setSize(0, 0);
        this.jwPopupWindow.setVisible(true);
        if (flag) {
            s1 = "<html>" + V2CBePopup.getBodyTextTagString() + "\u30d7\u30ed\u30d5\u30a3\u30fc\u30eb\u53d6\u5f97\u4e2d\u2026</body></html>";
        } else {
            s1 = (String)hmProfiles.get(integer);
            if (s1 == null) {
                s1 = "<html>" + V2CBePopup.getBodyTextTagString() + "\u30d7\u30ed\u30d5\u30a3\u30fc\u30eb\u60c5\u5831\u304c\u3042\u308a\u307e\u305b\u3093\u3002</body></html>";
            }
        }
        this.updateText(s1, true);
        if (flag) {
            this.thGetProfile = new Thread(new GetProfileThread(s, this));
            this.thGetProfile.start();
        }
    }

    @Override
    public boolean isCloseOnExit() {
        return false;
    }

    @Override
    public void closePopupWindow() {
        if (this.vtpParent != null) {
            V2CAbstractThreadPanel v2cabstractthreadpanel = this.vtpParent;
            this.vtpParent = null;
            if (v2cabstractthreadpanel.requestClosePopup(this)) {
                return;
            }
        }
        if (this.thGetProfile != null && this.thGetProfile.isAlive()) {
            this.thGetProfile.interrupt();
        }
        if (this.thGetFlogBookmark != null && this.thGetFlogBookmark.isAlive()) {
            this.thGetFlogBookmark.interrupt();
        }
        this.jwPopupWindow.dispose();
    }

    private void updateText(String s, boolean flag) {
        s = s.replaceAll("src=\"/static", "src=\"http://be.5ch.net/static");
        Rectangle rectangle = V2CSwingUtil.getScreenBoundsAt(this.pLocation);
        Dimension dimension = V2CThreadPopup.getMaxPopupSize();
        Insets insets = this.jScrollPane.getInsets();
        int i = Math.min(dimension.width, rectangle.width - 2);
        int j = Math.min(dimension.height, rectangle.height - 2);
        s = this.checkFlog(s, flag);
        this.createLabelIfNecessary(s);
        s = s.replaceAll("(?s)<script(?: [^>]+)?>.*?</script>", "\n");
        this.doSetText(s);
        V2CHTMLPane v2chtmlpane = new V2CHTMLPane(s);
        Dimension dimension1 = v2chtmlpane.getPreferredSize();
        int k = this.jlURL != null ? this.jlURL.getPreferredSize().height : 0;
        int l = Math.min(dimension1.width + insets.left + insets.right + 20, i);
        int i1 = Math.min(dimension1.height + insets.top + insets.bottom, j - k);
        this.jScrollPane.setPreferredSize(new Dimension(l, i1));
        i1 += k;
        int j1 = (int)this.pLocation.getX();
        int k1 = (int)this.pLocation.getY();
        boolean flag1 = false;
        if (j1 + l + 2 > rectangle.x + rectangle.width) {
            flag1 = true;
            j1 = rectangle.x + rectangle.width - l - 1;
        }
        if (k1 + i1 + 2 > rectangle.y + rectangle.height) {
            flag1 = true;
            k1 = rectangle.y + rectangle.height - i1 - 1;
        }
        if (flag1) {
            this.jwPopupWindow.setLocation(j1, k1);
        }
        this.jwPopupWindow.pack();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                V2CBePopup.this.scrollRectToVisible(new Rectangle(0, 0, 1, 1));
            }
        });
    }

    String checkFlog(String s, boolean flag) {
        int i = 0;
        Matcher matcher;
        while ((matcher = pFlogScript.matcher(s)).find(i)) {
            i = matcher.start();
            s = String.valueOf(s.substring(0, i)) + s.substring(matcher.end());
            String s1 = matcher.group(1);
            if (!s1.endsWith("/sb-euc.js")) continue;
            this.iFlogIndex = i;
            if (flag && this.bRemote) {
                this.thGetFlogBookmark = new Thread(new GetFlogThread(s1));
                this.thGetFlogBookmark.start();
                continue;
            }
            String s2 = (String)hmFlogBookmarks.get(s1);
            if (s2 == null) continue;
            s = this.insertFlog(s, s2);
            i += s2.length();
        }
        return s;
    }

    private void updateFlog() {
        String s = (String)hmProfiles.get(this.iBeID);
        if (s == null || s.length() < this.iFlogIndex) {
            return;
        }
        this.updateText(s, false);
    }

    private String insertFlog(String s, String s1) {
        return String.valueOf(s.substring(0, this.iFlogIndex)) + s1 + s.substring(this.iFlogIndex);
    }

    private void createLabelIfNecessary(String s) {
        if (this.jlURL != null || s.indexOf("<a ") < 0 && s.indexOf("<A ") < 0) {
            return;
        }
        this.jlURL = new JLabel(" ");
        this.jlURL.setOpaque(true);
        this.jlURL.setForeground(V2CThreadStyle.getDefaultForeground());
        this.jlURL.setBackground(V2CThreadPopup.cPopupBG);
        this.jlURL.setBorder(BorderFactory.createBevelBorder(1));
        this.cContainer.add((Component)this.jlURL, "South");
    }

    private static String putProfile(Integer integer, String s) {
        int i = 0;
        while ((i = s.indexOf("<form ", i)) > 0) {
            int j = s.indexOf("</form>", i + 6);
            if (j > 0) {
                s = String.valueOf(s.substring(0, i)) + s.substring(j + 7);
                continue;
            }
            i += 6;
        }
        s = s.replaceAll("<p></p>", "");
        Matcher matcher = pHTTP.matcher(s);
        s = matcher.replaceAll("$1<a href=\"$2\">$2</a>");
        Matcher matcher1 = pDivContent.matcher(s);
        Matcher matcher2 = pDivLeft.matcher(s);
        Matcher matcher3 = pDivRight.matcher(s);
        if (matcher1.find() && matcher2.find() && matcher3.find()) {
            int k = s.indexOf("</div>", matcher1.end());
            int l = s.indexOf("</div>", matcher2.end());
            int i1 = s.indexOf("</div>", matcher3.end());
            if (k > 0 && l > 0 && i1 > 0) {
                StringBuffer stringbuffer = new StringBuffer();
                stringbuffer.append("<html><body bgcolor=\"");
                stringbuffer.append(V2CSwingUtil.colorToString(V2CThreadPopup.cPopupBG));
                stringbuffer.append("\" text=\"");
                stringbuffer.append(V2CSwingUtil.colorToString(V2CThreadStyle.getDefaultForeground()));
                stringbuffer.append("\"><table border=\"1\" rules=\"all\" cellspacing=\"1\" cellpadding=\"5\"><tr><td width=\"170\" valign=\"top\">");
                stringbuffer.append(s.substring(matcher2.end(), l).replaceAll("/>", ">"));
                stringbuffer.append("</font></td><td width=\"400\" valign=\"top\">");
                stringbuffer.append(s.substring(matcher1.end(), k).replaceAll("/>", ">"));
                stringbuffer.append("</font></td><td width=\"150\" valign=\"top\">");
                stringbuffer.append(s.substring(matcher3.end(), i1).replaceAll("/>", ">"));
                stringbuffer.append("</font></td></tr></body></html>");
                s = stringbuffer.toString();
            }
        }
        hmProfiles.put(integer, s);
        return s;
    }

    private String putFlog(String s, String s1) {
        Matcher matcher;
        String s2 = "flog error !!";
        if (s1 != null && (matcher = Pattern.compile("document.write\\(\"(.+)\"\\);").matcher(s1)).matches()) {
            s2 = matcher.group(1);
        }
        hmFlogBookmarks.put(s, s2);
        return s2;
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent hyperlinkevent) {
        URL url = hyperlinkevent.getURL();
        if (url == null) {
            return;
        }
        String s = url.toString();
        if (hyperlinkevent.getEventType() == HyperlinkEvent.EventType.ENTERED) {
            if (this.jlURL == null) {
                return;
            }
            String s1 = V2CMiscUtil.maybeGetURLDecodedString(s);
            if (s1 != null) {
                int i = s1.indexOf(10);
                if (i >= 0) {
                    s1 = s1.substring(0, i);
                }
            } else {
                s1 = s;
            }
            this.jlURL.setText(s1);
        } else if (hyperlinkevent.getEventType() == HyperlinkEvent.EventType.EXITED) {
            if (this.jlURL != null) {
                this.jlURL.setText(" ");
            }
        } else if (hyperlinkevent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            V2CMiscUtil.openUnknownLink(s, true, false, true);
        }
    }

    static boolean getBeProfileBG(Integer integer, String s, V2CAbstractThreadPanel v2cabstractthreadpanel, Object obj) {
        if (!V2CMain.isOnlineMode()) {
            return false;
        }
        new Thread(new GetProfileThread(integer, s, v2cabstractthreadpanel, obj)).start();
        return true;
    }

    private class ClickListener
    extends MouseInputAdapter {
        boolean bDragged;

        @Override
        public void mouseDragged(MouseEvent mouseevent) {
            this.bDragged = true;
        }

        @Override
        public void mousePressed(MouseEvent mouseevent) {
            this.bDragged = false;
        }

        @Override
        public void mouseClicked(MouseEvent mouseevent) {
            if (this.bDragged || mouseevent.getButton() != 1) {
                return;
            }
            V2CBePopup.this.closePopupWindow();
        }

        ClickListener(ClickListener param1) {
            this();
        }

        private ClickListener() {
        }
    }

    private class GetFlogThread
    implements Runnable {
        String sFlogURL;

        @Override
        public void run() {
            V2CHttpUtil.CAndC candc = V2CHttpUtil.getHTTPFile(this.sFlogURL, null, "EUC-JP", "application/x-javascript", 0L);
            if (Thread.currentThread().isInterrupted()) {
                return;
            }
            String s = null;
            if (candc != null) {
                s = candc.getContents();
            }
            V2CBePopup.this.putFlog(this.sFlogURL, s);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    V2CBePopup.this.updateFlog();
                }
            });
        }

        GetFlogThread(String s) {
            this.sFlogURL = s;
        }
    }

    private static class GetProfileThread
    extends Thread {
        final Integer iLocalBeID;
        final String sProfileURL;
        final V2CBePopup vBePopup;
        final V2CAbstractThreadPanel vAbstractThreadPanel;
        final Object vPopupKey;

        @Override
        public void run() {
            String s = V2CHttpUtil.getHTMLFile(this.sProfileURL, "UTF-8");
            if (Thread.currentThread().isInterrupted()) {
                return;
            }
            if (s == null || s.length() == 0) {
                s = "<html><body>\u30c0\u30a6\u30f3\u30ed\u30fc\u30c9\u5931\u6557</body></html>";
            }
            final String sr0 = V2CBePopup.putProfile(this.iLocalBeID, s);
            if (this.vBePopup != null) {
                this.vBePopup.vtpParent.forceRepaint();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        vBePopup.updateText(sr0, true);
                    }
                });
            } else if (this.vAbstractThreadPanel != null) {
                this.vAbstractThreadPanel.beProfileUpdated(this.vPopupKey);
            }
        }

        GetProfileThread(Integer integer, String s, V2CAbstractThreadPanel v2cabstractthreadpanel, Object obj) {
            this(integer, s, null, v2cabstractthreadpanel, obj);
        }

        GetProfileThread(String s, V2CBePopup v2cbepopup) {
            this(v2cbepopup.iBeID, s, v2cbepopup, null, null);
        }

        GetProfileThread(Integer integer, String s, V2CBePopup v2cbepopup, V2CAbstractThreadPanel v2cabstractthreadpanel, Object obj) {
            this.iLocalBeID = integer;
            this.sProfileURL = s;
            this.vBePopup = v2cbepopup;
            this.vAbstractThreadPanel = v2cabstractthreadpanel;
            this.vPopupKey = obj;
        }
    }
}

