/*
 * Decompiled with CFR 0.152.
 */
package org.monazilla.v2c;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.monazilla.v2c.V2CApp;
import org.monazilla.v2c.V2CAutoReloader;
import org.monazilla.v2c.V2CMacQuaquaSupport;
import org.monazilla.v2c.V2CSwingUtil;
import org.monazilla.v2c.V2CThreadPanel;

public class V2CAutoReloadController
extends JPanel
implements ActionListener {
    private static final Color cNormal = new Color(8900331);
    private static final Color cWarning = Color.YELLOW;
    private static final Color cPaused = new Color(10025880);
    private static final Color cStopping = Color.RED;
    private static final int nReloadTimeUnit = 1800;
    private static final int nWarningLimit = 360;
    private static final int nStoppingLimit = 180;
    V2CThreadPanel vThreadPanel;
    JToggleButton jbStart;
    JToggleButton jbPause;
    JButton jbStop;
    JToggleButton jtbNextThread;
    JToggleButton jtbPage;
    JToggleButton jtbOneLineMode;
    JLabel jlTimeIndicator;
    JButton jbSet;
    JButton jbClose;
    boolean bRunning;
    private Timer tUpdateTimer;

    public V2CAutoReloadController(V2CThreadPanel paramV2CThreadPanel) {
        super(new GridBagLayout());
        JLabel localJLabel;
        if (V2CApp.isMacintosh()) {
            this.setOpaque(true);
        }
        this.vThreadPanel = paramV2CThreadPanel;
        V2CAutoReloader localV2CAutoReloader = paramV2CThreadPanel.vAutoReloader;
        GridBagConstraints localGridBagConstraints = new GridBagConstraints();
        localGridBagConstraints.gridx = 0;
        localGridBagConstraints.gridy = 0;
        localGridBagConstraints.fill = 3;
        Insets localInsets1 = new Insets(2, 7, 2, 7);
        this.jbStart = this.createToggleButton("arstart", false, localInsets1, localGridBagConstraints);
        this.jbPause = this.createToggleButton("arpause", false, localInsets1, localGridBagConstraints);
        this.jbStop = this.createButton("arstop", localInsets1, localGridBagConstraints);
        Insets localInsets2 = new Insets(2, 2, 2, 2);
        this.jtbNextThread = this.createToggleButton("arnextth", true, localInsets2, localGridBagConstraints);
        this.jtbPage = this.createToggleButton("arpagesc", localV2CAutoReloader != null ? localV2CAutoReloader.bPageScroll : V2CAutoReloader.bPageScroll0, localInsets2, localGridBagConstraints);
        boolean bool = paramV2CThreadPanel.isOneLineMode();
        this.jtbOneLineMode = this.createToggleButton("ar1lmode", bool, localInsets2, localGridBagConstraints);
        this.jlTimeIndicator = localJLabel = new JLabel("00:00:00");
        localJLabel.setBorder(BorderFactory.createEmptyBorder(2, 4, 2, 4));
        localJLabel.setFont(localJLabel.getFont().deriveFont(1, 12.0f));
        localJLabel.setOpaque(true);
        this.resetCount();
        this.add((Component)localJLabel, localGridBagConstraints);
        ++localGridBagConstraints.gridx;
        this.jbSet = this.createButton("arset", localInsets2, localGridBagConstraints);
        this.jbClose = this.createButton("arclose", localInsets2, localGridBagConstraints);
        if (!bool && (localV2CAutoReloader != null ? localV2CAutoReloader.bOneLineMode : V2CAutoReloader.bOneLineMode0)) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    V2CAutoReloadController.this.jtbOneLineMode.setSelected(true);
                    V2CAutoReloadController.this.vThreadPanel.setOneLineMode(true);
                }
            });
        }
    }

    @Override
    public boolean isValidateRoot() {
        return true;
    }

    private JButton createButton(String paramString, Insets paramInsets, GridBagConstraints paramGridBagConstraints) {
        JButton localJButton = new JButton(V2CSwingUtil.getSystemIcon(paramString));
        localJButton.setFocusable(false);
        if (V2CApp.isMacintosh() && V2CMacQuaquaSupport.needsGeometryTweak()) {
            V2CMacQuaquaSupport.resetVisualMargin(localJButton);
            V2CMacQuaquaSupport.setSquareButtonStyle(localJButton);
        }
        localJButton.setMargin(paramInsets);
        localJButton.addActionListener(this);
        this.add((Component)localJButton, paramGridBagConstraints);
        ++paramGridBagConstraints.gridx;
        return localJButton;
    }

    private JToggleButton createToggleButton(String paramString, boolean paramBoolean, Insets paramInsets, GridBagConstraints paramGridBagConstraints) {
        JToggleButton localJToggleButton = new JToggleButton(V2CSwingUtil.getSystemIcon(paramString));
        localJToggleButton.setFocusable(false);
        if (V2CApp.isMacintosh() && V2CMacQuaquaSupport.needsGeometryTweak()) {
            V2CMacQuaquaSupport.resetVisualMargin(localJToggleButton);
            V2CMacQuaquaSupport.setSquareButtonStyle(localJToggleButton);
        }
        if (paramBoolean) {
            localJToggleButton.setSelected(paramBoolean);
        }
        localJToggleButton.setMargin(paramInsets);
        localJToggleButton.addActionListener(this);
        this.add((Component)localJToggleButton, paramGridBagConstraints);
        ++paramGridBagConstraints.gridx;
        return localJToggleButton;
    }

    boolean isPageMode() {
        return this.jtbPage.isSelected();
    }

    void togglePageMode() {
        this.jtbPage.setSelected(!this.jtbPage.isSelected());
    }

    boolean isOneLineMode() {
        return this.jtbOneLineMode.isSelected();
    }

    void setOneLineMode(boolean paramBoolean) {
        this.jtbOneLineMode.setSelected(paramBoolean);
    }

    void started() {
        this.bRunning = true;
        this.updateCount();
        this.jbStart.setSelected(true);
        this.startUpdateTimer();
    }

    void stopped() {
        this.bRunning = false;
        this.stopUpdateTimer();
        this.jbPause.setSelected(false);
        this.jbStart.setSelected(false);
        this.resetCount();
    }

    void setMode(V2CAutoReloadController paramV2CAutoReloadController) {
        if (paramV2CAutoReloadController != null) {
            this.setNextThread(paramV2CAutoReloadController.getNextThread());
            this.jtbPage.setSelected(paramV2CAutoReloadController.jtbPage.isSelected());
            this.jtbOneLineMode.setSelected(paramV2CAutoReloadController.jtbOneLineMode.isSelected());
        }
    }

    void toggleNextThread() {
        this.setNextThread(!this.getNextThread());
    }

    void setNextThread(boolean paramBoolean) {
        this.jtbNextThread.setSelected(paramBoolean);
    }

    boolean getNextThread() {
        return this.jtbNextThread.isSelected();
    }

    void resetCount() {
        this.setCount(0, false);
    }

    void updateCount() {
        V2CAutoReloader localV2CAutoReloader = this.vThreadPanel.vAutoReloader;
        this.setCount(localV2CAutoReloader != null ? localV2CAutoReloader.getRemainingTime() : 0, true);
    }

    void setCount(int paramInt, boolean paramBoolean) {
        V2CAutoReloader localV2CAutoReloader;
        if (paramBoolean && !this.bRunning) {
            return;
        }
        if (paramInt < 0) {
            paramInt = 0;
        }
        StringBuffer localStringBuffer = new StringBuffer();
        int i = paramInt / 3600;
        if (i < 10) {
            localStringBuffer.append('0');
        }
        localStringBuffer.append(i);
        localStringBuffer.append(':');
        int j = paramInt / 60 % 60;
        if (j < 10) {
            localStringBuffer.append('0');
        }
        localStringBuffer.append(j);
        localStringBuffer.append(':');
        int k = paramInt % 60;
        if (k < 10) {
            localStringBuffer.append('0');
        }
        localStringBuffer.append(k);
        this.jlTimeIndicator.setText(localStringBuffer.toString());
        Color localColor = paramBoolean ? ((localV2CAutoReloader = this.vThreadPanel.vAutoReloader) != null && localV2CAutoReloader.isPaused() ? cPaused : (paramInt <= 180 ? cStopping : (paramInt <= 360 ? cWarning : cNormal))) : null;
        this.jlTimeIndicator.setBackground(localColor);
    }

    void startUpdateTimer() {
        if (this.tUpdateTimer == null) {
            this.tUpdateTimer = new Timer(1000, this);
        } else if (this.tUpdateTimer.isRunning()) {
            this.tUpdateTimer.stop();
        }
        this.tUpdateTimer.start();
    }

    void stopUpdateTimer() {
        if (this.tUpdateTimer != null && this.tUpdateTimer.isRunning()) {
            this.tUpdateTimer.stop();
        }
    }

    @Override
    public void actionPerformed(ActionEvent paramActionEvent) {
        Object localObject = paramActionEvent.getSource();
        if (localObject == this.jbStart) {
            if (this.jbStart.isSelected()) {
                this.vThreadPanel.startAutoReload(true);
            } else if (this.jbPause.isSelected()) {
                this.vThreadPanel.togglePauseAutoReload();
                this.jbPause.setSelected(false);
                this.jbStart.setSelected(true);
            } else {
                this.vThreadPanel.startAutoReload(true);
                this.jbStart.setSelected(true);
            }
        } else if (localObject == this.jbPause) {
            if (this.jbStart.isSelected()) {
                this.vThreadPanel.togglePauseAutoReload();
            } else {
                this.jbPause.setSelected(false);
            }
        } else if (localObject == this.jbStop) {
            this.vThreadPanel.stopAutoReload();
            this.jbPause.setSelected(false);
            this.jbStart.setSelected(false);
        } else if (localObject == this.jtbPage) {
            this.vThreadPanel.setScrollMode(this.jtbPage.isSelected());
        } else if (localObject == this.jtbOneLineMode) {
            this.vThreadPanel.setOneLineMode(this.jtbOneLineMode.isSelected());
        } else if (localObject == this.jbSet) {
            V2CAutoReloader.setAutoReload();
        } else if (localObject == this.jbClose) {
            this.vThreadPanel.hideAutoReloadController(true);
        } else if (localObject == this.tUpdateTimer) {
            this.updateCount();
        }
    }
}

