/*
 * Decompiled with CFR 0.152.
 */
package com.bulenkov.iconloader.util;

import com.bulenkov.iconloader.IconLoader;
import com.bulenkov.iconloader.IsRetina;
import com.bulenkov.iconloader.JBHiDPIScaledImage;
import com.bulenkov.iconloader.RetinaImage;
import com.bulenkov.iconloader.util.CenteredIcon;
import com.bulenkov.iconloader.util.ColorUtil;
import com.bulenkov.iconloader.util.DoubleColor;
import com.bulenkov.iconloader.util.Gray;
import com.bulenkov.iconloader.util.Ref;
import com.bulenkov.iconloader.util.SystemInfo;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.lang.reflect.Field;
import javax.swing.GrayFilter;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.UIManager;

public class UIUtil {
    public static final Color TRANSPARENT_COLOR = new Color(0, 0, 0, 0);
    private static final Color DECORATED_ROW_BG_COLOR = new DoubleColor(new Color(242, 245, 249), new Color(65, 69, 71));
    private static final Ref<Boolean> ourRetina = Ref.create(SystemInfo.isMac ? null : Boolean.valueOf(false));
    private static final GrayFilter DEFAULT_GRAY_FILTER = new GrayFilter(true, 65);
    private static final GrayFilter DARCULA_GRAY_FILTER = new GrayFilter(true, 30);

    public static <T extends JComponent> T findComponentOfType(JComponent parent, Class<T> cls) {
        if (parent == null || cls.isAssignableFrom(parent.getClass())) {
            JComponent t = parent;
            return (T)t;
        }
        for (Component component : parent.getComponents()) {
            T comp;
            if (!(component instanceof JComponent) || (comp = UIUtil.findComponentOfType((JComponent)component, cls)) == null) continue;
            return comp;
        }
        return null;
    }

    public static <T> T getParentOfType(Class<? extends T> cls, Component c) {
        for (Component eachParent = c; eachParent != null; eachParent = eachParent.getParent()) {
            if (!cls.isAssignableFrom(eachParent.getClass())) continue;
            Component t = eachParent;
            return (T)t;
        }
        return null;
    }

    public static Color getControlColor() {
        return UIManager.getColor("control");
    }

    public static Color getPanelBackground() {
        return UIManager.getColor("Panel.background");
    }

    public static boolean isUnderDarcula() {
        return UIManager.getLookAndFeel().getName().equals("Darcula");
    }

    public static Color getListBackground() {
        return UIManager.getColor("List.background");
    }

    public static Color getListForeground() {
        return UIManager.getColor("List.foreground");
    }

    public static Color getLabelForeground() {
        return UIManager.getColor("Label.foreground");
    }

    public static Color getTextFieldBackground() {
        return UIManager.getColor("TextField.background");
    }

    public static Color getTreeSelectionForeground() {
        return UIManager.getColor("Tree.selectionForeground");
    }

    public static Color getTreeForeground() {
        return UIManager.getColor("Tree.foreground");
    }

    public static Color getDecoratedRowColor() {
        return DECORATED_ROW_BG_COLOR;
    }

    public static Color getTreeSelectionBackground(boolean focused) {
        return focused ? UIUtil.getTreeSelectionBackground() : UIUtil.getTreeUnfocusedSelectionBackground();
    }

    private static Color getTreeSelectionBackground() {
        return UIManager.getColor("Tree.selectionBackground");
    }

    public static Color getTreeUnfocusedSelectionBackground() {
        Color background = UIUtil.getTreeTextBackground();
        return ColorUtil.isDark(background) ? new DoubleColor(Gray._30, new Color(13, 41, 62)) : Gray._212;
    }

    public static Color getTreeTextBackground() {
        return UIManager.getColor("Tree.textBackground");
    }

    public static Icon getTreeNodeIcon(boolean expanded, boolean selected, boolean focused) {
        boolean white = selected && focused || UIUtil.isUnderDarcula();
        Icon selectedIcon = UIUtil.getTreeSelectedExpandedIcon();
        Icon notSelectedIcon = UIUtil.getTreeExpandedIcon();
        int width = Math.max(selectedIcon.getIconWidth(), notSelectedIcon.getIconWidth());
        int height = Math.max(selectedIcon.getIconWidth(), notSelectedIcon.getIconWidth());
        return new CenteredIcon(expanded ? (white ? UIUtil.getTreeSelectedExpandedIcon() : UIUtil.getTreeExpandedIcon()) : (white ? UIUtil.getTreeSelectedCollapsedIcon() : UIUtil.getTreeCollapsedIcon()), width, height, false);
    }

    public static Icon getTreeCollapsedIcon() {
        return UIManager.getIcon("Tree.collapsedIcon");
    }

    public static Icon getTreeExpandedIcon() {
        return UIManager.getIcon("Tree.expandedIcon");
    }

    public static Icon getTreeSelectedCollapsedIcon() {
        return IconLoader.getIcon("/icons/tree_white_right_arrow.png");
    }

    public static Icon getTreeSelectedExpandedIcon() {
        return IconLoader.getIcon("/icons/tree_white_down_arrow.png");
    }

    public static void drawImage(Graphics g, Image image, int x, int y, ImageObserver observer) {
        if (image instanceof JBHiDPIScaledImage) {
            Graphics2D newG = (Graphics2D)g.create(x, y, image.getWidth(observer), image.getHeight(observer));
            newG.scale(0.5, 0.5);
            Image img = ((JBHiDPIScaledImage)image).getDelegate();
            if (img == null) {
                img = image;
            }
            newG.drawImage(img, 0, 0, observer);
            newG.scale(1.0, 1.0);
            newG.dispose();
        } else {
            g.drawImage(image, x, y, observer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isRetina() {
        Ref<Boolean> ref = ourRetina;
        synchronized (ref) {
            if (ourRetina.isNull()) {
                ourRetina.set(false);
                if (SystemInfo.isJavaVersionAtLeast("1.6.0_33") && SystemInfo.isAppleJvm) {
                    if (!"false".equals(System.getProperty("ide.mac.retina"))) {
                        ourRetina.set(IsRetina.isRetina());
                        return ourRetina.get();
                    }
                } else if (SystemInfo.isJavaVersionAtLeast("1.7.0_40") && SystemInfo.isOracleJvm) {
                    GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
                    GraphicsDevice device = env.getDefaultScreenDevice();
                    try {
                        Field field = device.getClass().getDeclaredField("scale");
                        if (field != null) {
                            field.setAccessible(true);
                            Object scale = field.get(device);
                            if (scale instanceof Integer && (Integer)scale == 2) {
                                ourRetina.set(true);
                                return true;
                            }
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                ourRetina.set(false);
            }
            return ourRetina.get();
        }
    }

    public static BufferedImage createImage(int width, int height, int type) {
        if (UIUtil.isRetina()) {
            return RetinaImage.create(width, height, type);
        }
        return new BufferedImage(width, height, type);
    }

    public static GrayFilter getGrayFilter() {
        return UIUtil.isUnderDarcula() ? DARCULA_GRAY_FILTER : DEFAULT_GRAY_FILTER;
    }
}

