//【登録場所】 "V2C\script\system\getdat.js"

//【内容】read.cgiモード時にHTMLからDATを生成する
//【引数】url : ページのURL
//　　　　oBody  : HTMLデータ
//　　　　lastResNum   : 既に取得しているレス番。この番号以降のDATを生成して返す。0の場合は全件。
//【戻り値】生成したDAT文字列
//【備考】2ch接続設定にて「datの生成をスクリプトで行う」にチェックする必要があります。
function htmlToDat(url, oBody, lastResNum) {

	//スレのタイトルを取得
	var title = oBody.match(/<title.*?>(.*?)\n?<\/title>/mi);

	// エラーページの場合はreturn
	var head = oBody.split('</head>', 1);
	if(head[0].match(/og:title" content="[^ ]+ error/mi)) {
		return null;
	}
	if(head[0].match(/<title>[^d]+dat[^U]+URL[^<]+<\/title>/mi)) {
		return null;
	}

	// 以下、htmltodatByFiddlerを参考にさせてもらっています

	// read.cgi ver 08 チェック
	var is_readcgi08 = false;
	if(oBody.match(/<main id="maincontainer">/)){
		is_readcgi08 = true;
		//前後の不要な部分をカット（前処理）
		oBody = oBody.replace(/^<!DOCTYPE HTML>[\s\S]+?<article id="/, '<article id="')
		oBody = oBody.replace(/<div class="navmenu">[\s\S]+$/mi, '');
		oBody = oBody.replace(/<\/article>[\s\S]*?<article id="/gmi, '</article><article id="')
		oBody = oBody.replace(/<span style="float:right;.+?>.+?<\/span>/gmi, '');
	}

	// read.cgi ver 07_62 チェック
	var is_readcgi07_62 = false;
	var isKako = false;
	if(!is_readcgi08 && oBody.match(/<div id="maincontent"/)){
		is_readcgi07_62 = true;
		//過去鯖判定
		if(oBody.match(/<link rel="canonical" href="([^"]+)"/)){
			if((""+RegExp.$1).indexOf("//kako.") != -1){
				isKako = true;
			}
		}
		//前後の不要な部分をカット（前処理）
		oBody = oBody.replace(/^<!DOCTYPE HTML>[\s\S]+?<div id="(\d{1,4})" data-date="/, '<div id="$1" data-date="')
		oBody = oBody.replace(/<div class="adbanners"[\s\S]+?<\/div><div id="(\d{1,4})" data-date="/, '<div id="$1" data-date="')
		oBody = oBody.replace(/<div class="navmenu">[\s\S]+$/mi, '');
	}

	//前後の不要な部分をカット（前処理）
	var isBBSPINK_readcgi06 = false;
	if(oBody.match(/<base href="([^"]+)">/)){
		if((""+RegExp.$1).indexOf(".bbspink.com/") != -1){
			if (oBody.match(/<span class="number">/)){ //read.cgi 06かどうかはspan classタグで判断（で当面いいだろう）
				isBBSPINK_readcgi06 = true;
				// BBSPINKのhtmlを正規化 BBSPINK read.cgi 06対応
				oBody = oBody.replace(/^(.|\s)*?<\/h1.*?>\n?/, "")
							 .replace(/<div><div class="banner(.|\s)*$/g, '')
							 .replace(/<(dd|dl|span)/g, '<div').replace(/<\/(dd|dl|span)/g, '</div')
							 .replace(/<\/?dt.*?>/g, '').replace(/<\/?section.*?>/g, '')
							 .replace(/<div class="thread_in">/g, '<div class="message">');
				oBody = oBody.replace(/<div class="uid">/g, ' ');
				//名前・メール欄内の余計なFONTタグ除去
				oBody = oBody.replace(/(<b><font.*?>)(.+?)(<\/font><\/b>)/g, function(aStr, aTag1, aMailName, aTag2) {
					var Tag1 = aTag1.replace(/<font.*?>/g, '');
					var Tag2 = aTag2.replace(/<\/font>/g, '');
					return Tag1 + aMailName + Tag2;
				});
			}
		}
	}
	if(!isBBSPINK_readcgi06 && !is_readcgi08 && !is_readcgi07_62){
		oBody = oBody.replace(/^(.|\s)*?<(dl|div) class="thread".*?>\n?/, ""); //read.cgi 06対応
	}
	//名前・メール欄内の余計なAタグ除去（前処理）
	oBody = oBody.replace(/(<b><a .*?href="mailto:)(.+?)(<\/a><\/b>)/g, function(aStr, aTag1, aMailName, aTag2) {
		var mailname = aMailName.replace(/<\/?a[^>]*?>/g, '');
		return aTag1 + mailname + aTag2;
	});
	//メール欄デコードの前処理
	//oBody = oBody.replace(/(<a href=")\/cdn-cgi\/l\/(email-protection#.*?">)/ig,"$1mailto:$2");

	if(is_readcgi07_62){
		// 更新時は差分だけカット（htmltodatByFiddlerにはない処理）
		if(lastResNum != 0){
			oBody = cutPage07_62(oBody, lastResNum);
		}
		// 過去ログの正規化用htmlタグ変換
		if(isKako){
			oBody = oBody.replace(/<\/details>/gi, '</div>').replace(/<section/gi, '<div').replace(/<\/section>/gi, '</div>');
		}
		// <span class="AA">取り対応
		oBody = oBody.replace(/<span class="AA">(.*?)<\/span>/g, '$1');
		oBody = oBody.replace(/<div id=.+?<span class="postusername"><b>(?:<a .*?href="mailto:(.*?)">)?(.*?)(?:<\/a>)?<\/b><\/span>.+?<span class="date">(.*?)<\/span><span class="uid">(.*?)<\/span><\/span>(<span class="be .*?>.+?<\/span>)?<\/div><div class="post-content">(.*?)<\/div><\/div>/ig,"$2<>$1<>$3 $4$5<>$6<>\n");
		// BE周りの処理 若干05の場合とかぶってしまうが仕方ない
		oBody = oBody.replace(/<span class="be .*?><a href="https?:\/\/be\.[25]ch\.net\/user\/(\d+).*?>\?(.*?)<\/a><\/span>/ig," BE:$1-$2");
		oBody = oBody.replace(/<img src="(?:https?:)?\/\/((?:img\.[25]ch\.net|o\.[58]ch\.net)\/.+?)">/ig,"sssp://$1");
		// !slot:対応
		oBody = oBody.replace(/<span>(&#[^;]+;?)<\/span><span>(&#[^;]+;?)<\/span><span>(&#[^;]+;?)<\/span><br>/g,"$1$2$3<br>");
		// 何をやってくるか分からないので保険を掛ける
		oBody = oBody.replace(/<\/span><span.+?>/g," ");
		// 最終行のゴミ取り
		oBody = oBody.replace(/<div class="adbanners"[\s\S]+/, '')
		// 1レス対応
		oBody = oBody.replace(/<script[\s\S]*?<\/script>/gmi, '')
		// null取り対応
		oBody = oBody.replace(/\0+/gmi, '');

	}else

	if(is_readcgi08){
		// 更新時は差分だけカット（htmltodatByFiddlerにはない処理）
		if(lastResNum != 0){
			oBody = cutPage08(oBody, lastResNum);
		}
		oBody = oBody.replace(/<article id=.+?<span class="postusername"><b>(?:<a href="mailto:(.*?)">)?(.*?)(?:<\/a>)?<\/b><\/span><\/summary>(?:<span[^>]+>)?<span class="date">(.*?)<\/span><span class="uid">(.*?)<\/span>(?:<\/span>)?<\/details><section class="post-content">(.*?)<\/section><\/article>/ig,"$2<>$1<>$3 $4<>$5<>\n");
		// BE周りの処理 若干05の場合とかぶってしまうが仕方ない
		oBody = oBody.replace(/<\/span><span class="be .*?><a href="https?:\/\/be\.[25]ch\.net\/user\/(\d+).*?>\?(.*?)<\/a>/ig," BE:$1-$2");
		oBody = oBody.replace(/<img src="(?:https?:)?\/\/((?:img\.[25]ch\.net|o\.[58]ch\.net)\/.+?)">/ig,"sssp://$1");
		// !slot:対応
		oBody = oBody.replace(/<span>(&#[^;]+;?)<\/span><span>(&#[^;]+;?)<\/span><span>(&#[^;]+;?)<\/span><br>/g,"$1$2$3<br>");
		// 何をやってくるか分からないので保険を掛ける
		oBody = oBody.replace(/<\/span><span.+?>/g," ");
		// 最終行のゴミ取り
		oBody = oBody.replace(/<\/div>$/,"").replace(/<\/div><div class="push">$/,"");
		// 1レス対応
		oBody = oBody.replace(/<script[\s\S]*?<\/script>/gmi, '')
		// null取り対応
		oBody = oBody.replace(/\0+/gmi, '');

	}else

	//htmltodat変換 read.cgi 07対応
	if (oBody.match(/<li class=".*?metastats/) && !isBBSPINK_readcgi06){ //read.cgi 07かどうかはli class="metastats"タグで判断（で当面いいだろう）
		// 更新時は差分だけカット（htmltodatByFiddlerにはない処理）
		if(lastResNum != 0){
			oBody = cutPage07(oBody, lastResNum);
		}

		oBody = oBody.replace(/<\/div><div class="pagestats">(.|\s)*$/,""); //後ろの不要な部分をカット
		oBody = oBody.replace(/<div id="banner"[\s\S]*?(?=(<div class="post"|$))/,""); //バナー広告削除
		oBody = oBody.replace(/<div><div id=".*?banner.*?"[\s\S]*?<\/div><\/div>((?:<div class="post" id="\d+")|(?:<\/div><div class="push">))/ig,"$1"); //200レス単位のバナー広告削除
		oBody = oBody.replace(/<\/div><div><div class="js--ad--bottom"[\s\S]*$/,""); //最終レス後の広告を削除
		oBody = oBody.replace(/<div class="post".*?><div class="meta"><span class="number">(\d+).*?<\/span><span class="name"><b>(?:<a href="mailto:(.*?)">)?(.*?)(?:<\/a>)?<\/b><\/span><span class="date">(.*?)<\/span><\/div><div class="message"><span class="escaped">(.*?)<\/span><\/div><\/div>(?:<br>)?/ig,"$3<>$2<>$4<>$5<>\n");
		// BE周りの処理 若干05の場合とかぶってしまうが仕方ない
		oBody = oBody.replace(/<\/span><span class="be .*?><a href="https?:\/\/be\.[25]ch\.net\/user\/(\d+).*?>\?(.*?)<\/a>/ig," BE:$1-$2");
		oBody = oBody.replace(/<img src="(?:https?:)?\/\/((?:img\.[25]ch\.net|o\.[58]ch\.net)\/.+?)">/ig,"sssp://$1");
		oBody = oBody.replace(/(HOST:[^<]+)<[^>]+.>/ig,"$1");
		//oBody = oBody.replace(/<a href="https?:\/\/jump\.2ch\.net.*?>(.*?)<\/a>/ig,"$1"); //これは必要か？後で検討
		// レスアンカーに対するフルパスを相対パスに変換（やらなくても問題ないかもしれないが一応昔の仕様に合わせる）→昔の仕様に戻ったようなのでコメントアウト
		//oBody = oBody.replace(/<a href="https?:\/\/.*?\.2ch\.net\/(test\/read\.cgi\/.*?\/\d+\/\d+)/ig,"<a href=\"../$1");
		// !slot:対応
		oBody = oBody.replace(/<span>(&#[^;]+;?)<\/span><span>(&#[^;]+;?)<\/span><span>(&#[^;]+;?)<\/span><br>/g,"$1$2$3<br>");
		// 何をやってくるか分からないので保険を掛ける
		oBody = oBody.replace(/<\/span><span.+?>/g," ");
		// 最終行のゴミ取り
		oBody = oBody.replace(/<\/div>$/,"").replace(/<\/div><div class="push">$/,"");

	}else

	//htmltodat変換 read.cgi 06対応
	if (oBody.match(/<div class="number">/)){ //read.cgi 06かどうかはdiv classタグで判断（で当面いいだろう）

		if(!isBBSPINK_readcgi06){
			// 更新時は差分だけカット（htmltodatByFiddlerにはない処理）
			if(lastResNum != 0){
				oBody = cutPage06(oBody, lastResNum);
			}
		}else{
			// 元の位置でバナー広告を削除すると>>2がうふ～んの場合に補完したうふ～んまで削除されるので予めバナー広告を削除する
			oBody = oBody.replace(/<div id="banner"[\s\S]*?(?=(<div class="post"|$))/,""); //バナー広告削除
			// BBSPINKの場合は削除されたレスを補完する（htmltodatByFiddlerにはない処理）
			oBody = CutAndInsertPageBBSPINK06(oBody, lastResNum);
		}

		oBody = oBody.replace(/<\/div><div class="cLength">(.|\s)*$/,""); //後ろの不要な部分をカット
		oBody = oBody.replace(/<div id="banner"[\s\S]*?(?=(<div class="post"|$))/,""); //バナー広告削除
		oBody = oBody.replace(/<\/div><div><div class="js--ad--bottom"[\s\S]*$/,""); //最終レス後の広告を削除
		oBody = oBody.replace(/<div class="post".*?><div class="number">(\d+).*?<\/div><div class="name"><b>(?:<a href="mailto:(.*?)">)?(.*?)(?:<\/a>)?<\/b><\/div><div class="date">(.*?)<\/div><div class="message">(.*?)<\/div><\/div>/ig,"$3<>$2<>$4<>$5<>\n");
		// BE周りの処理 若干05の場合とかぶってしまうが仕方ない
		oBody = oBody.replace(/<\/div><div class="be .*?><a href="https?:\/\/be\.[25]ch\.net\/user\/(\d+).*?>\?(.*?)<\/a>/ig," BE:$1-$2");
		oBody = oBody.replace(/<img src="(?:https?:)?\/\/((?:img\.[25]ch\.net|o\.[58]ch\.net)\/.+?)">/ig,"sssp://$1");
		oBody = oBody.replace(/(HOST:[^<]+)<[^>]+.>/ig,"$1");
		//oBody = oBody.replace(/<a href="https?:\/\/jump\.2ch\.net.*?>(.*?)<\/a>/ig,"$1"); //これは必要か？後で検討
		// レスアンカーに対するフルパスを相対パスに変換（やらなくても問題ないかもしれないが一応昔の仕様に合わせる）→昔の仕様に戻ったようなのでコメントアウト
		//oBody = oBody.replace(/<a href="https?:\/\/.*?\.2ch\.net\/(test\/read\.cgi\/.*?\/\d+\/\d+)/ig,"<a href=\"../$1");
		// 最終行のゴミ取り
		oBody = oBody.replace(/<\/div>$/,"");
		//BBSPINKの名前欄のゴミ取り
		if(isBBSPINK_readcgi06){
			oBody = oBody.replace(/(<br>)?<\/?div.*?>/ig,"");
		}

	}else{ //read.cgi 05用

		// 更新時は差分だけカット（htmltodatByFiddlerにはない処理）
	     	if(lastResNum != 0){
	     		oBody = cutPage05(oBody, lastResNum);
		}

		oBody = oBody.replace(/(<\/dd>)?<\/dl>(.|\s)*$/,"");
//		oBody = oBody.replace(/<div.*? class="banner"[\s\S]*?(?=(<dt>|$))/,""); //バナー広告削除
		oBody = oBody.replace(/<div.*? (?:id="js--banners--thread"|class="banner")[\s\S]*?(?=(<dt>|$))/,""); //バナー広告削除
		oBody = oBody.replace(/<dt.*?>(\d+).+?(?:"mailto:(.+?)">)?<b>(.+?)<\/b>(?:<\/font>|<\/a>)\s?：(.*?)<dd>(.*?)<br><br>\n/ig,"$3<>$2<>$4<>$5<>\n");
		oBody = oBody.replace(/<a href=.?javascript:be\((.+)(?:,\d+)?\).*?>\?(.*?)<\/a>/ig,"BE:$1-$2");
		oBody = oBody.replace(/<img src="(?:https?:)?\/\/((?:img\.[25]ch\.net|o\.[58]ch\.net)\/.+?)">/ig,"sssp://$1");
		oBody = oBody.replace(/(HOST:[^<]+)<[^>]+.>/ig,"$1");
	}
	// お絵かき機能のimgタグを除去。dat上では除去されてるのでそれに従ったがブラウザによってはなくてもいいかもしれない
	oBody = oBody.replace(/<img src="https?:(.*?)">/ig,"sssp:$1");
	//後処理
	//アンカータグ削除（レスアンカーに対するタグは削除しない）
	oBody = oBody.replace(/<a href="http.*?>(.*?)<\/a>/g,"$1").replace(/<a class="image" href="https?:\/\/jump\.[25]ch\.net\/.*?>(.*?)<\/a>/g,"$1");

	//変換後の１レス目にタイトルを付加
	if(lastResNum == 0){ // 全件取得時のみ
		oBody = oBody.replace(/^(.*?<>.*?<>.*?<>.*?<>$)/m, "$1" + title[1]);
	}

	//半角スペースの連続を除去（read.cgiの挙動不審に対応）
	oBody = oBody.replace(/  +/g, " ");

	//末尾のゴミ掃除
	oBody = oBody.replace(/<br>$/, "");

	// 消しきれなかったゴミhtmlタグの削除
	oBody = oBody.replace(/<\/?mark.*?>|<\/?em.*?>|<div.*?>.*?<\/div>/g,"");
	oBody = oBody.replace(/<\/?div[^>]*>/g,"");

	if(!is_readcgi07_62) oBody = oBody.replace(/<\/?a.*?>/g,"").replace(/<\/?span.*?>/g, '');
	oBody = oBody.replace(/<\/b> <b>垢版/g,"");

	// APIモードで生成されるdatへの近似化
	oBody = oBody.replace(/ class="reply_link"/g,"");
	oBody = oBody.replace(/ +<\/b>/g," </b>");
	oBody = oBody.replace(/<br> <br>/g,"<br>  <br>");

	return oBody;
}

// 差分取得時の不要なレスを削除（readcgi07_62）
function cutPage07_62(html, lastResNum){
	// 改行は前スレで挿入済み

	// レス番を取るためのマッチ条件
	var pn = java.util.regex.Pattern.compile('<div id="(\\d{1,4})" data-date=".+?<\\/div><\\/div>');
	var datMatcher = pn.matcher(html);
	var sb = new java.lang.StringBuilder();
	while (datMatcher.find()) {
		var data = datMatcher.group(0);
		if(data == ""){
			continue;
		}
		var currentNum = datMatcher.group(1).trim();
		if (currentNum <= lastResNum) {
			continue;
		}
		sb.append(data);
	}
	// そのまま返すとJAVA7でエラーになるので一旦Stringに変換
	var cutpage = new String(sb.toString());
	return cutpage;
}

// 差分取得時の不要なレスを削除（readcgi08）
function cutPage08(html, lastResNum){
	// 改行は前スレで挿入済み

	// レス番を取るためのマッチ条件
	var pn = java.util.regex.Pattern.compile('<article id=\"([0-9]*)\".+?<\\/article>');
	var datMatcher = pn.matcher(html);
	var sb = new java.lang.StringBuilder();
	while (datMatcher.find()) {
		var data = datMatcher.group(0);
		if(data == ""){
			continue;
		}
		var currentNum = datMatcher.group(1).trim();
		if (currentNum <= lastResNum) {
			continue;
		}
		sb.append(data);
	}
	// そのまま返すとJAVA7でエラーになるので一旦Stringに変換
	var cutpage = new String(sb.toString());
	return cutpage;
}

// 差分取得時の不要なレスを削除（readcgi05）
function cutPage05(html, lastResNum){
	// レス番を取るためのマッチ条件
	var pn = java.util.regex.Pattern.compile('<dt>([0-9]*).+(<a href=\"(.+)\">(.+)<\\/a>|<font color=\"?green\"?>(.+)<\\/font>)：(.+)<dd>(.+)<br><br>');
	var datMatcher = pn.matcher(html);
	var sb = new java.lang.StringBuilder();
	while (datMatcher.find()) {
		var currentNum = datMatcher.group(1).trim();
		if (currentNum <= lastResNum) {
			continue;
		}
		var data = datMatcher.group(0);
		sb.append(data);
		sb.append('\n');
	}
	// そのまま返すとJAVA7でエラーになるので一旦Stringに変換
	var cutpage = new String(sb.toString());
	return cutpage;
}

// 差分取得時の不要なレスを削除（readcgi06）
function cutPage06(html, lastResNum){
	// 改行を入れる
	html = html.replace(/<div class="post"/g, '\n<div class="post"');
	// レス番を取るためのマッチ条件
	var pn = java.util.regex.Pattern.compile('<div class=\"post\" id=\"([0-9]*)\" data-date=(.+)<div class=\"name\"><b>(.+)<\\/b><\\/div><div class=\"date\">(.+)<\\/div>(.*)<div class=\"message\">(.+)<\\/div><\\/div>');
	var datMatcher = pn.matcher(html);
	var sb = new java.lang.StringBuilder();
	while (datMatcher.find()) {
		var data = datMatcher.group(0);
		if(data == ""){
			continue;
		}
		var currentNum = datMatcher.group(1).trim();
		if (currentNum <= lastResNum) {
			continue;
		}
		sb.append(data);
	}
	// そのまま返すとJAVA7でエラーになるので一旦Stringに変換
	var cutpage = new String(sb.toString());
	return cutpage;
}

// 差分取得時の不要なレスを削除と削除されたレス補完(BBSPINK)（readcgi06）
function CutAndInsertPageBBSPINK06(html, lastResNum){
	// 改行を入れる
	html = html.replace(/<div class="post"/g, '\n<div class="post"');
	// レス番を取るためのマッチ条件
	var pn = java.util.regex.Pattern.compile('<div class=\"post\" id=\"([0-9]*)\" data-date=(.+)<div class=\"name\"><b>(.+)<\\/b><\\/div><div class=\"date\">(.+)<\\/div>(.*)<div class=\"message\">(.+)<\\/div><\\/div>');
	var datMatcher = pn.matcher(html);
	var sb = new java.lang.StringBuilder();
	var st = parseInt(lastResNum);
	while (datMatcher.find()) {
		var data = datMatcher.group(0);
		if(data == ""){
			continue;
		}
		var currentNum = datMatcher.group(1).trim();
		if (currentNum <= lastResNum) {
			continue;
		}
		for(var i=st+1; i<currentNum; i++){
			sb.append('うふ～ん ('+i+')<>うふ～ん<>うふ～ん ID:DELETED<>うふ～ん<>うふ～ん<>');
			sb.append('\n');
		}
		st = parseInt(currentNum);
		sb.append(data);
	}
	// そのまま返すとJAVA7でエラーになるので一旦Stringに変換
	var cutpage = new String(sb.toString());
	return cutpage;
}

// 差分取得時の不要なレスを削除（readcgi07）
function cutPage07(html, lastResNum){
	// 改行を入れる
	html = html.replace(/<div class="post"/g, '\n<div class="post"');
	// レス番を取るためのマッチ条件
	var pn = java.util.regex.Pattern.compile('<div class=\"post\" id=\"([0-9]*)\" data-date=(.+)<span class=\"name\"><b>(.+)<\\/b><\\/span><span class=\"date\">(.+)<\\/span>(.*)<div class=\"message\">(.+)<\\/div><\\/div>');
	var datMatcher = pn.matcher(html);
	var sb = new java.lang.StringBuilder();
	while (datMatcher.find()) {
		var data = datMatcher.group(0);
		if(data == ""){
			continue;
		}
		var currentNum = datMatcher.group(1).trim();
		if (currentNum <= lastResNum) {
			continue;
		}
		sb.append(data);
	}
	// そのまま返すとJAVA7でエラーになるので一旦Stringに変換
	var cutpage = new String(sb.toString());
	return cutpage;
}

//【内容】API+read.cgiモード時に、取得したDATの過去ログ判定を行う(read.cgiモードへの自動切替判定)
//【引数】rescode  : HTMLレスポンスコード
//　　　　rescount : 総レス数(thから取得できるレス数は正しくないのでこちらを使用してください)
//　　　　th       : threadオブジェクト
//【戻り値】過去ログの場合はTrue、それ以外はFalse
//【備考】2ch接続設定にて「過去ログの判定をスクリプトで行う」にチェックする必要があります。
function checkKakolog(rescode, rescount, th){

	// レスポンスが正常、且つ総レス数2のスレだった場合
	if (rescode == 200 && rescount == 2) {
		var resItem = th.getRes(1);
		var idx = resItem.message.indexOf("このスレッドは過去ログです。");
		// 2レス目に該当レスが存在する場合はTrue
		if(idx != -1) {
			return true;
		}
	}

	// 配信仕様変更メッセージが出たスレも一応read.cgiで取りに行ってみる
	if (rescode == 200 && rescount == 1) {
		var resItem = th.getRes(0);
		var idx = resItem.message.indexOf("ちゃんねるの配信仕様が変更されました。");
		// 2レス目に該当レスが存在する場合はTrue
		if(idx != -1) {
			return true;
		}
	}

	// APIアクセス時にエラーコードが返ってくるスレがあるがread.cgiだと取得できることもあるのでこの場合もTrueを返す
	if (rescode >= 400 && rescode <= 499){
		return true;
	}

	// 全ての判定条件に当てはまらなかった場合は過去ログではない
	return false;
}

