package org.monazilla.v2c;

import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

import javax.imageio.ImageIO;

public class V2CWebpConvert2Gif
{
	private static boolean t0_print = false;
	private static boolean c0_print = false;
	private static final int HQ = 9;
	private static final int LQ = 0;
	private static final long THUMB_CUT_WAIT = Long.valueOf(V2CHttpUtil.webpAnimThumbsWait) * 1000L;
	private static final String Const_CreateMovieThumb_ffmpeg = "ffmpeg -i #input# -ss 0 -t 60 -filter_complex \"scale=320:-2,split[a][b];[a]palettegen[pal];[b][pal]paletteuse=alpha_threshold=0\" -loglevel quiet -y #output#.gif";

	private V2CWebpANIMReader war = null;
	private boolean webpAnimHQ;

	public V2CWebpConvert2Gif() {
		webpAnimHQ = V2CWebpAnimation.setWebpAnimHQ();
	}

	private void dumpHQ(File IDfldr, String webp){
		if(c0_print) System.out.println(webp+":dumpHQ start");
		long t0 = System.currentTimeMillis();
		// dump.zipを作成するために全コマ切り出しが必要
		String cmdArray[] = {
				V2CGetContainerOfAnimTools.anim_dump().getAbsolutePath()
				,"-folder"
				,(new File(IDfldr, "dump")).getAbsolutePath()
				,(webp!=null?webp:(new File(IDfldr, "source.webp")).getAbsolutePath())
		};

		Runtime runtime = Runtime.getRuntime();
		Process p = null;
		try {
			p = runtime.exec(cmdArray);
		} catch (IOException e) {
			e.printStackTrace();
		}
		try {
			p.waitFor();
		} catch (InterruptedException e) {
			e.printStackTrace();
		}

		runtime = null;
		cmdArray = null;
		p = null;
		if(t0_print) System.out.println("dump webp全コマ展開 経過時間:" + (System.currentTimeMillis() - t0));

		if((new File(IDfldr, "anmf.txt")).exists()){
			return;
		}
		writeANMFnum(IDfldr, HQ);
		
		t0 = System.currentTimeMillis();
		ZipCompress((new File(IDfldr, "dump.zip")).getAbsolutePath(), new File(IDfldr, "dump"));
		if(t0_print) System.out.println("dump zip圧縮 経過時間:" + (System.currentTimeMillis() - t0));
	}
	
	private void dumpLQ(File IDfldr, String webp){
		if(c0_print) System.out.println(webp+":dumpLQ start");
		// dump.zipは不要でサムネだけ作ればいいので実働5秒で切り辞め
		war = new V2CWebpANIMReader(new File(webp));
		int l = 0;
		int i = 0;
		if(!(new File(IDfldr, "dump")).exists()){
			(new File(IDfldr, "dump")).mkdir();
		}
		long tt0 = System.currentTimeMillis();
		byte[] origin = null;
		BufferedImage image = null;
		int DispHeight = 0;
		while(l != -1){
			l = war.getNextEntry();
			if(l != -1){
				try {
					byte[] b = war.read();
					image = ImageIO.read(new ByteArrayInputStream(b));
					if(i != 0){
						int Offset_Y = DispHeight - image.getHeight();
						if(Offset_Y > 0){
							BufferedImage canvas = ImageIO.read(new ByteArrayInputStream(origin));
							Graphics g = canvas.getGraphics();
							g.drawImage(image, 0, Offset_Y, null);
							image = canvas;
							canvas = null;
						}
					}else{
						origin = b.clone();
						DispHeight = image.getHeight();
					}
					ImageIO.write( image
								  ,"png", new File(IDfldr, "/dump/dump_" + V2CWebpAnimation.createSeq(i++) + ".png")
					);
				} catch (IOException e) {
					// TODO 自動生成された catch ブロック
					e.printStackTrace();
				}
			}
			if(System.currentTimeMillis() - tt0 > THUMB_CUT_WAIT || i > 30){
				break;
			}
		}
		war.close();
		war = null;
		origin = null;
		
		if((new File(IDfldr, "anmf.txt")).exists()){
			return;
		}
		writeANMFnum(IDfldr, LQ);
	}
	
	synchronized public File exec(final File webp){
		if(c0_print) System.out.println(webp.getName()+":ConvertWebp2Gif start");
		long t0 = System.currentTimeMillis();

		
		String CreateMovieThumb_ffmpeg = V2CHttpUtil.CreateMovieThumb_ffmpeg;
		final File IDfldr = V2CWebpAnimation.createFolder(new File(V2CLocalFileHandler.v2cDir, "/tmp").getAbsolutePath(), webp.getName());
		File gif = new File(IDfldr, "source.gif");
		if(CreateMovieThumb_ffmpeg.endsWith(".jpg")){
			gif = new File(IDfldr, "source.jpg");
		}
		File anmf = new File(IDfldr, "anmf.txt");
		if(webpAnimHQ && readANMFnum(IDfldr, "q") == LQ){
			gif.delete();
			anmf.delete();
		}

		if(gif.exists()){
			if(c0_print) System.out.println(webp.getName()+":ConvertWebp2Gif exit by gif");
			return gif;
		}

		if(t0_print) System.out.println("ConvertWebp2Gif 前処理 経過時間:" + (System.currentTimeMillis() - t0));

		t0 = System.currentTimeMillis();
		new Thread(new Runnable() {
			@Override
			public void run() {
				if(!(new File(IDfldr, "dump")).exists()){
					(new File(IDfldr, "dump")).mkdir();
				}
				if(webpAnimHQ){
					dumpHQ(IDfldr, webp.getAbsolutePath());
				}else{
					dumpLQ(IDfldr, webp.getAbsolutePath());
				}
			}
		}).start();

		try {
			Thread.sleep(THUMB_CUT_WAIT);
			while((new File(IDfldr, "dump")).listFiles().length == 0){
				Thread.sleep(500);
			}
		} catch (InterruptedException e) {
			// TODO 自動生成された catch ブロック
			e.printStackTrace();
		}
		if(t0_print) System.out.println("ConvertWebp2Gif gifアニメソース生成 経過時間:" + (System.currentTimeMillis() - t0));

		t0 = System.currentTimeMillis();
		String ext = "%d.jpg";
		boolean isJPEG = true;
//		String CreateMovieThumb_ffmpeg = V2CHttpUtil.CreateMovieThumb_ffmpeg;
		if(CreateMovieThumb_ffmpeg.endsWith(".gif")){
			ext = ".gif";
			isJPEG = false;
			CreateMovieThumb_ffmpeg =  Const_CreateMovieThumb_ffmpeg;
		}else{
			gif = new File(IDfldr, "source.jpg");
		}
		String wcmd = "";
		int r = 1000 / V2CWebpANIMReader.getDuration(webp);
		int m = 1000 % V2CWebpANIMReader.getDuration(webp);
		if(m != 0) r--;
		if(r < 1) r = 1;
		wcmd = CreateMovieThumb_ffmpeg
				.replaceAll("-t 60 ", "-t 60 -r " + r + " ")
				.replaceAll(" ", "\t")
				.replace("#input#", (new File(IDfldr, "dump")).getAbsolutePath() + "/dump_00" + (isJPEG?"00":"%02d") +".png")
				.replace("#output#" + (isJPEG?".jpg":".gif"), gif.getAbsolutePath());
		V2CHttpUtil.CreateMovieThumb_ffmpeg_path = V2CGetContainerOfAnimTools.ffmpeg();
		if(V2CHttpUtil.CreateMovieThumb_ffmpeg_path.length() != 0 && !V2CHttpUtil.CreateMovieThumb_ffmpeg_path.equals(V2CGetContainerOfAnimTools.sDefaultPathTo)){
			wcmd = V2CHttpUtil.CreateMovieThumb_ffmpeg_path + V2CLocalFileHandler.sFileSeparator + wcmd;
		}
		String cmdArray[] = wcmd.split("\t");
		if(V2CApp.isMacintosh() || V2CApp.isLinux()){
			for(int i=0; i<cmdArray.length; i++){
				cmdArray[i] = (""+cmdArray[i]).replaceAll("\"", "");
			}
		}
				
/*
		if(V2CApp.isMacintosh() || V2CApp.isLinux()){
			for(int i=0; i<cmdArray.length; i++){
				cmdArray[i] = (""+cmdArray[i]).replaceAll("\"", "");
			}
		}
*/
				
		Runtime runtime = Runtime.getRuntime();
		Process p = null;
		try {
			p = runtime.exec(cmdArray);
		} catch (IOException e) {
			e.printStackTrace();
		}
		try {
			p.waitFor();
		} catch (InterruptedException e) {
			e.printStackTrace();
		}
			
		long fsize = 0;
		if((new File(gif.getAbsolutePath())).exists()){
			fsize = (new File(gif.getAbsolutePath())).length();
		}
		if(!isJPEG && fsize < 100*1024){
			int image_cnt = 0;
			if(fsize != 0){
				GifDecoder gdec = new GifDecoder();
				try {
					BufferedInputStream bis = new BufferedInputStream(new FileInputStream(new File(gif.getAbsolutePath())));
					if (0 == gdec.read(bis)) {
						image_cnt = gdec.getFrameCount();
					}
					bis.close();
					bis = null;
				} catch (FileNotFoundException e) {
					// TODO 自動生成された catch ブロック
					e.printStackTrace();
				} catch (IOException e) {
					// TODO 自動生成された catch ブロック
					e.printStackTrace();
				}
				gdec = null;
			}
			if(image_cnt < 2){
				File c = (new File(IDfldr, "dump"));
				File files[] = c.listFiles();
				for(int i=0; i<files.length; i++){
					filecopy( new File(c, "dump_" + V2CWebpAnimation.createSeq(i) +".png")
							, new File(c, "dump_" + V2CWebpAnimation.createSeq(i+files.length) +".png")
					);
				}
				
				try {
					p = runtime.exec(cmdArray);
				} catch (IOException e) {
					e.printStackTrace();
				}
				try {
					p.waitFor();
				} catch (InterruptedException e) {
					e.printStackTrace();
				}
			}
		}
		
		if(V2CHttpUtil.CreateMovieThumbShowCmd){
			System.out.println("ffmpegコマンド(デバッグ用)=\n" + wcmd.replaceAll("\t", " ").replaceAll(" -loglevel quiet", ""));
		}
		if(t0_print) System.out.println("ConvertWebp2Gif gifアニメ生成  経過時間:" + (System.currentTimeMillis() - t0));

		runtime = null;
		cmdArray = null;
		p = null;
		return gif;
	}

	private static void filecopy(File in, File out){
		try {
			FileInputStream fileIn = new FileInputStream(in);
			FileOutputStream fileOut = new FileOutputStream(out);

			byte[] buf = new byte[4096];
			int len;
			while((len = fileIn.read(buf)) != -1){
				fileOut.write(buf);
			}
			fileOut.flush();
			fileOut.close();
			fileIn.close();
			fileOut = null;
			fileIn = null;
		} catch (FileNotFoundException e) {
			// TODO 自動生成された catch ブロック
			e.printStackTrace();
		} catch (IOException e) {
			// TODO 自動生成された catch ブロック
			e.printStackTrace();
		}
		
	}
	
	private static void writeANMFnum(File IDfldr, int q){
		try{
			File file = new File(IDfldr, "anmf.txt");
			BufferedWriter bw = new BufferedWriter(new FileWriter(file));
			bw.write("" + q + ":" +String.valueOf((new File(IDfldr, "dump")).listFiles().length));
			bw.close();
			bw = null;
		}catch(IOException e){
			System.out.println(e);
		}
	}
	
	private static int readANMFnum(File IDfldr){
		return readANMFnum(IDfldr, null);
	}
	
	private static int readANMFnum(File IDfldr, String q){
		File file = new File(IDfldr, "anmf.txt");
		if(!file.exists()){
			return 0;
		}
		String text = "";
		try{
			String str = "";
			BufferedReader br = new BufferedReader(new FileReader(file));
			while((str = br.readLine()) != null){
				text += str;
			}
			br.close();
			br = null;
		}catch(FileNotFoundException e){
			System.out.println(e);
		}catch(IOException e){
			System.out.println(e);
		}
		if(q != null){
			return Integer.valueOf(text.split(":")[0]);
		}else{
			return Integer.valueOf(text.split(":")[1]);
		}
	}

	public static boolean ZipCompress( String string, File dumpfldr ) {

		int n = dumpfldr.listFiles().length;
		File[] files = new File[n];
		for(int i=0; i<n; i++){
			files[i] = new File(dumpfldr, "dump_" + V2CWebpAnimation.createSeq(i) + ".png");
		}
		
		ZipOutputStream outZip = null;
		try {
			// ZIPファイル出力オブジェクト作成
			outZip = new ZipOutputStream(new FileOutputStream(string));
			// 圧縮ファイルリストのファイルを連続圧縮
			for ( int i = 0 ; i < files.length ; i++ ) {
				// ファイルオブジェクト作成
				File targetFile = files[i];

				// 圧縮レベル設定
				outZip.setLevel(0);
				try {
					// ZIPエントリ作成
					outZip.putNextEntry(new ZipEntry(targetFile.getName()));

					// 圧縮ファイル読み込みストリーム取得
					DataInputStream dataInStream = 
						new DataInputStream(
							new BufferedInputStream(
								new FileInputStream(targetFile)));

					// 圧縮ファイルをZIPファイルに出力
					int readSize = 0;
					byte buffer[] = new byte[4096]; // 読み込みバッファ
					while ((readSize = dataInStream.read(buffer)) != -1) {
						outZip.write(buffer, 0, readSize);
					}
					// クローズ処理
					dataInStream.close();
					// ZIPエントリクローズ
					outZip.closeEntry();
				} catch ( Exception e ) {
					// ZIP圧縮失敗
					return false;
				}
			}
		} catch ( Exception e ) {
			// ZIP圧縮失敗
			return false;
		} finally {
			// ZIPエントリクローズ
			if ( outZip != null ) {
				try { outZip.closeEntry(); } catch (Exception e) {}
				try { outZip.flush(); } catch (Exception e) {}
				try { outZip.close(); } catch (Exception e) {}
			}
		}
		return true;
	}
}
