package org.monazilla.v2c;

import java.awt.Point;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class V2CURLExec
{

	static boolean checkCommand(String s, int i, V2CAbstractThreadPanel v2cabstractthreadpanel)
	{
		ArrayList arraylist = getCommands(i);
		int j = arraylist.size();
		for (int k = 0; k < j; k++) {
			V2CURLExec v2curlexec = (V2CURLExec) arraylist.get(k);
			if (v2curlexec.matches(s))
				return v2curlexec.execCommand(s, v2cabstractthreadpanel);
		}

		return false;
	}

	static void reloadCommands(int i)
	{
		if (i >= 0 && i < 3) {
			allURLExec[i] = null;
			getCommands(i);
		}
	}

	static ArrayList getCommands(int i)
	{
		if (i < 0 || i >= 3)
			return null;
		ArrayList aarraylist[] = allURLExec;
		ArrayList arraylist = aarraylist[i];
		if (arraylist != null)
			return arraylist;
		arraylist = new ArrayList();
		aarraylist[i] = arraylist;
		String s;
		if (i == 0)
			s = "URLExec.dat";
		else
			s = "URLExec" + (i + 1) + ".dat";
		int loopCnt = (i==0?2:1);
		BufferedReader bufferedreader = null;
		for(int j=0; j<loopCnt; j++){
			if(j == 0){
				bufferedreader = V2CLocalFileHandler.getUserConfigReader(s, "MS932");
			}else{
				File file0 = new File(V2CLauncher.getJarDir(), "URLExec_B11.dat");
				if(file0.exists()){
					try {
						bufferedreader = new BufferedReader(new InputStreamReader(new FileInputStream(file0), "MS932"));
						System.out.println("Use " + file0.getName());
					} catch (UnsupportedEncodingException e) {
						// TODO 自動生成された catch ブロック
						e.printStackTrace();
					} catch (FileNotFoundException e) {
						// TODO 自動生成された catch ブロック
						e.printStackTrace();
					}
				}else{
					bufferedreader = null;
				}
			}
			if (bufferedreader == null)
//				return arraylist;
				continue;
			try {
				do {
					String s1;
					if ((s1 = bufferedreader.readLine()) == null)
						break;
					if (s1.length() > 3) {
						char c = s1.charAt(0);
						if (c != ';' && c != '\'' && (c != '/' || s1.charAt(1) != '/')) {
							String as[] = V2CMiscUtil.split(s1, '\t', false);
							if (as != null && as.length == 3) {
								Pattern pattern = null;
								try {
									pattern = Pattern.compile(as[0]);
								}
								catch (Exception exception) {
								}
								if (pattern != null) {
									V2CURLExec v2curlexec = new V2CURLExec(pattern, as[1], as[2]);
									arraylist.add(v2curlexec);
								}
							}
						}
					}
				} while (true);
			}
			catch (IOException ioexception) {
				System.out.println(ioexception.getMessage());
			}
			finally {
				V2CLocalFileHandler.closeReader(bufferedreader);
			}
		}
		return arraylist;
	}

	private V2CURLExec(Pattern pattern, String s, String s1)
	{
		pURL = pattern;
		sReplace = s;
		sCommand = s1;
	}

	boolean matches(String s)
	{
		return pURL.matcher(s).find();
	}

	boolean execCommand(String s, V2CAbstractThreadPanel v2cabstractthreadpanel)
	{
		String s1 = getCommand(s);
		if (s1 == null)
			return false;
		Matcher matcher = Pattern.compile("(\\$\\{?)V2C(SCRIPT[^\\p{Alnum}].+)").matcher(s1);
		if (matcher.matches())
			V2CExtCommand.execURLCommand(matcher.group(1) + matcher.group(2), replaceURL(s), v2cabstractthreadpanel, "URLExec");
		else
			V2CMiscUtil.execCommandString(s1, null, null, false, v2cabstractthreadpanel);
		return true;
	}

	String replaceURL(String s)
	{
		if (s == null)
			return null;
		String s1 = V2CMiscUtil.convertJaneRegExp(sReplace);
		Matcher matcher = pURL.matcher(s);
		matcher.find();
		StringBuffer stringbuffer = new StringBuffer();
		try {
			matcher.appendReplacement(stringbuffer, s1);
		}
		catch (Exception exception) {
			exception.printStackTrace();
			System.out.println("Pattern: " + pURL);
			System.out.println("Replace: " + s1);
		}
		matcher.appendTail(stringbuffer);
		return stringbuffer.toString();
	}

	String getCommand(String s)
	{
		String s1 = sCommand;
		if (s1.startsWith("$BROWSER "))
			s1 = "$EXTBROWSER" + s1.substring(8);
		else if (s1.startsWith("\"$BROWSER\" "))
			s1 = "$EXTBROWSER" + s1.substring(10);
		if (s1.indexOf("$BROWSER") >= 0 || s1.indexOf("$VIEW") >= 0)
			return null;
		s1 = V2CMiscUtil.replaceAll(s1, "$URL", replaceURL(s));
		s1 = V2CMiscUtil.replaceAll(s1, "$BASEPATH", V2CLocalFileHandler.getV2CDirPath());
		if (s1.indexOf("$POSX") >= 0 || s1.indexOf("$POSX") >= 0) {
			Point point = V2CSwingUtil.getMouseLocationOnScreen(null);
			String s2;
			String s3;
			if (point != null) {
				s2 = String.valueOf(point.x);
				s3 = String.valueOf(point.y);
			}
			else {
				s2 = s3 = "0";
			}
			s1 = V2CMiscUtil.replaceAll(s1, "$POSX", s2);
			s1 = V2CMiscUtil.replaceAll(s1, "$POSY", s3);
		}
		return s1;
	}

	static final ArrayList allURLExec[] = new ArrayList[3];
	final Pattern pURL;
	final String sReplace;
	final String sCommand;

}
