/*      */ package org.monazilla.v2c;
/*      */ 
/*      */ import java.awt.Insets;
/*      */ import java.awt.Rectangle;
/*      */ 
/*      */ public class V2CThreadPopup extends V2CAbstractThreadPanel implements V2CPopupPanel
/*      */ {
/*      */   static final String sPopupLineWrapKey = "ThreadView.PopupLineWrap";
/*      */   static final String sPopupBGKey = "ThreadView.PopupBG";
/*      */   static final String sPopupAltBGKey = "ThreadView.PopupAltBG";
/*      */   static final String sMaxPopupSizeKey = "ThreadView.MaxPopupSize";
/*      */   static final String sPopupScaleKey = "ThreadView.PopupScale";
/*      */   static boolean bPopupLineWrap;
/*      */   static java.awt.Color cPopupBG;
/*      */   static java.awt.Color cPopupAltBG;
/*      */   static int nMaxPopupWidth;
/*      */   static int nMaxPopupHeight;
/*      */   static int nDefaultScale;
/*      */   static boolean bFixPopup;
/*      */   final boolean bInNotification;
/*      */   java.awt.Window jwPopupWindow;
/*      */   Rectangle rScreenBounds;
/*      */   V2CPopupPos vPopupPos;
/*      */   long[] ilTwID;
/*      */   boolean bGeometrySet;
/*      */   int nDrawingWidth0;
/*      */   int nDrawingWidth;
/*      */   volatile boolean bSetPopupGeometryArmed;
/*      */   
/*      */   private class GlassPaneMouseListener extends V2CMouseExitListener
/*      */   {
/*      */     public void mouseEntered(java.awt.event.MouseEvent mouseevent)
/*      */     {
/*   34 */       V2CThreadPopup.this.bPointerInside = true;
/*      */     }
/*      */     
/*      */     void doExitAction(java.awt.event.MouseEvent mouseevent) {
/*   38 */       V2CThreadPopup.this.vtpParent.checkPopupTree(
/*   39 */         V2CSwingUtil.getMouseLocationOnScreen(mouseevent));
/*      */     }
/*      */     
/*      */     public void mouseExited(java.awt.event.MouseEvent mouseevent) {
/*   43 */       if (this.bButtonDown) {
/*   44 */         return;
/*      */       }
/*   46 */       V2CThreadPopup.this.bPointerInside = false;
/*   47 */       if (V2CThreadPopup.bFixPopup) {
/*   48 */         return;
/*      */       }
/*   50 */       if ((isOutside(mouseevent)) && (V2CThreadPopup.this.vtpParent != null)) {
/*   51 */         doExitAction(mouseevent);
/*      */       }
/*      */     }
/*      */     
/*      */     GlassPaneMouseListener() {
/*   56 */       super(V2CThreadPopup.this);
/*      */     }
/*      */   }
/*      */   
/*      */   class PopupPopupListener extends V2CAbstractThreadPanel.PopupListener
/*      */   {
/*      */     boolean bDragWindow;
/*      */     int nLastX;
/*      */     int nLastY;
/*      */     boolean bCursorSet;
/*      */     
/*      */     public void mouseDragged(java.awt.event.MouseEvent mouseevent) {
/*   68 */       if (this.bDragWindow) {
/*   69 */         java.awt.Point point = V2CSwingUtil.getMouseLocationOnScreen(mouseevent);
/*   70 */         int i = point.x - this.nLastX;
/*   71 */         int j = point.y - this.nLastY;
/*   72 */         this.nLastX = point.x;
/*   73 */         this.nLastY = point.y;
/*   74 */         Rectangle rectangle = V2CThreadPopup.this.jwPopupWindow.getBounds();
/*   75 */         int k = rectangle.x + i;
/*   76 */         int l = rectangle.y + j;
/*   77 */         Rectangle rectangle1 = V2CThreadPopup.this.rScreenBounds;
/*   78 */         if (rectangle1 == null) {
/*   79 */           return;
/*      */         }
/*   81 */         if (!rectangle1.contains(point)) {
/*   82 */           Rectangle rectangle2 = 
/*   83 */             V2CSwingUtil.getScreenBoundsAt(point);
/*   84 */           if (rectangle2 != null) {
/*   85 */             V2CThreadPopup.this.rScreenBounds = rectangle2;
/*   86 */             rectangle1 = rectangle2;
/*      */           }
/*      */         }
/*   89 */         if (k < rectangle1.x + 1) {
/*   90 */           k = rectangle1.x + 1;
/*   91 */         } else if (k + rectangle.width > rectangle1.x + rectangle1.width - 1) {
/*   92 */           k = rectangle1.x + rectangle1.width - rectangle.width - 1;
/*      */         }
/*   94 */         if (l < rectangle1.y + 1) {
/*   95 */           l = rectangle1.y + 1;
/*   96 */         } else if (l + rectangle.height > rectangle1.y + rectangle1.height - 1) {
/*   97 */           l = rectangle1.y + rectangle1.height - rectangle.height - 
/*   98 */             1;
/*      */         }
/*  100 */         if ((k == rectangle.x) && (l == rectangle.y)) {
/*  101 */           return;
/*      */         }
/*  103 */         V2CThreadPopup.this.jwPopupWindow.setLocation(k, l);
/*  104 */         if (!this.bCursorSet) {
/*  105 */           this.bCursorSet = true;
/*  106 */           V2CThreadPopup.this.setCursor(java.awt.Cursor.getPredefinedCursor(12));
/*      */         }
/*      */       } else {
/*  109 */         super.mouseDragged(mouseevent);
/*      */       }
/*      */     }
/*      */     
/*      */     public void mousePressed(java.awt.event.MouseEvent mouseevent) {
/*  114 */       super.mousePressed(mouseevent);
/*  115 */       boolean flag = (V2CSwingUtil.isSimpleClick(mouseevent)) && (
/*  116 */         mouseevent.getPoint().x < 20);
/*  117 */       if (flag) {
/*  118 */         java.awt.Point point = mouseevent.getPoint();
/*  119 */         int i = 0;
/*      */         
/*  121 */         while (i < V2CThreadPopup.this.alShapes.size())
/*      */         {
/*      */ 
/*  124 */           V2CAbstractThreadPanel.ActiveShape activeshape = 
/*  125 */             (V2CAbstractThreadPanel.ActiveShape)V2CThreadPopup.this.alShapes.get(i);
/*  126 */           java.awt.Shape shape = activeshape.getShape();
/*  127 */           if ((shape != null) && (shape.contains(point))) {
/*  128 */             flag = false;
/*  129 */             break;
/*      */           }
/*  131 */           i++;
/*      */         }
/*  133 */         if (flag) {
/*  134 */           V2CThreadPopup.this.closeChildPopups(false);
/*  135 */           java.awt.Point point1 = mouseevent.getPoint();
/*  136 */           javax.swing.SwingUtilities.convertPointToScreen(point1, 
/*  137 */             V2CThreadPopup.this);
/*  138 */           point1 = V2CSwingUtil.tweakMouseLocationOnScreen(point1, 
/*  139 */             V2CThreadPopup.this);
/*  140 */           this.nLastX = point1.x;
/*  141 */           this.nLastY = point1.y;
/*      */         }
/*      */       }
/*  144 */       this.bDragWindow = flag;
/*      */     }
/*      */     
/*      */     public void mouseReleased(java.awt.event.MouseEvent mouseevent) {
/*  148 */       if (this.bDragWindow) {
/*  149 */         if (this.bCursorSet) {
/*  150 */           this.bCursorSet = false;
/*  151 */           V2CThreadPopup.this.setCursor(java.awt.Cursor.getDefaultCursor());
/*      */         }
/*      */       } else {
/*  154 */         super.mouseReleased(mouseevent);
/*      */       }
/*      */     }
/*      */     
/*      */     PopupPopupListener() {
/*  159 */       super();
/*      */     }
/*      */   }
/*      */   
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */   static void updatePopupBGs(java.awt.Color color, java.awt.Color color1)
/*      */   {
/*  187 */     if (!cPopupBG.equals(color)) {
/*  188 */       cPopupBG = color;
/*  189 */       V2CMain.getUserProperty().putColor("ThreadView.PopupBG", color);
/*      */     }
/*  191 */     if (!cPopupAltBG.equals(color1)) {
/*  192 */       cPopupAltBG = color1;
/*  193 */       V2CMain.getUserProperty().putColor("ThreadView.PopupAltBG", color1);
/*      */     }
/*      */   }
/*      */   
/*      */   static void toggleFixPopup() {
/*  198 */     bFixPopup = !bFixPopup;
/*      */   }
/*      */   
/*      */   static void configThreadViewGeneral() {
/*  202 */     V2CResPopupSP v2crespopupsp = createResPopupSP();
/*  203 */     if (v2crespopupsp.showDialog()) {
/*  204 */       postConfigResPopup(v2crespopupsp, true);
/*      */     }
/*      */   }
/*      */   
/*      */   static V2CResPopupSP createResPopupSP() {
/*  209 */     if ((nMaxPopupWidth == 0) || (nMaxPopupHeight == 0)) {
/*  210 */       calcMaxPopupSize();
/*      */     }
/*  212 */     return new V2CResPopupSP(nMinResNumColumns, bRNZeroPadding, nMaxConsNL, 
/*  213 */       fVWheelScrollFactor, bPopupWhenInactive, bPopupLineWrap, 
/*  214 */       bOmitOriginalRes, nMaxPopupWidth, nMaxPopupHeight, 
/*  215 */       nDefaultScale, bExpandGetDelPMItems);
/*      */   }
/*      */   
/*      */   static int postConfigResPopup(V2CResPopupSP v2crespopupsp, boolean flag) {
/*  219 */     int i = 0;
/*  220 */     V2CProperty v2cproperty = V2CMain.getUserProperty();
/*  221 */     int j = Math.max(v2crespopupsp.getMaxConsNL(), 0);
/*  222 */     if (j != nMaxConsNL) {
/*  223 */       if (j > 0) {
/*  224 */         V2CPackedPropValue v2cpackedpropvalue = new V2CPackedPropValue();
/*  225 */         v2cpackedpropvalue.setInt('N', j);
/*  226 */         v2cproperty.putPackedValue("ThreadView.DispConvConf", 
/*  227 */           v2cpackedpropvalue);
/*      */       } else {
/*  229 */         v2cproperty.remove("ThreadView.DispConvConf");
/*      */       }
/*  231 */       V2CThreadPanel.TPIterator tpiterator = 
/*  232 */         V2CThreadPanel.getTPIterator();
/*      */       
/*  234 */       while (tpiterator.hasNext())
/*      */       {
/*      */ 
/*  237 */         V2CThreadPanel v2cthreadpanel = tpiterator.next();
/*  238 */         if (!v2cthreadpanel.bAutoLoad) {
/*  239 */           v2cthreadpanel.vtrThreadRes.clearDisplayConversion();
/*      */         }
/*      */       }
/*  242 */       nMaxConsNL = j;
/*  243 */       i |= 0x8;
/*      */     }
/*  245 */     float f = Math.min(
/*  246 */       Math.max(0.1F, v2crespopupsp.getWheelScrollFactor()), 10.0F);
/*  247 */     if (f != fVWheelScrollFactor) {
/*  248 */       fVWheelScrollFactor = f;
/*  249 */       int k = (int)(f * 10.0F);
/*  250 */       if (k != 10) {
/*  251 */         V2CPackedPropValue v2cpackedpropvalue1 = new V2CPackedPropValue();
/*  252 */         v2cpackedpropvalue1.setInt('W', k);
/*  253 */         v2cproperty.putPackedValue("ThreadView.ScrollConf", 
/*  254 */           v2cpackedpropvalue1);
/*      */       } else {
/*  256 */         v2cproperty.remove("ThreadView.ScrollConf");
/*      */       }
/*      */     }
/*  259 */     boolean flag1 = v2crespopupsp.getLineWrap();
/*      */     
/*  261 */     if (V2CApp.setBooleanUserProperty("ThreadView.PopupLineWrap", bPopupLineWrap, flag1, true)) {
/*  262 */       bPopupLineWrap = flag1;
/*      */     }
/*  264 */     boolean flag2 = v2crespopupsp.getPopupWhenInactive();
/*  265 */     boolean flag3 = v2crespopupsp.getOmitOriginalRes();
/*  266 */     boolean flag4 = v2crespopupsp.getNoTextPUForEmptyResPU();
/*  267 */     if ((flag3 != bOmitOriginalRes) || (flag2 != bPopupWhenInactive) || 
/*  268 */       (flag4 != bNoTextPUForEmptyResPU)) {
/*  269 */       bPopupWhenInactive = flag2;
/*  270 */       bOmitOriginalRes = flag3;
/*  271 */       bNoTextPUForEmptyResPU = flag4;
/*  272 */       if ((flag2) || (flag3) || (flag4)) {
/*  273 */         V2CPackedPropValue v2cpackedpropvalue2 = new V2CPackedPropValue();
/*  274 */         v2cpackedpropvalue2.setBoolean('I', flag2);
/*  275 */         v2cpackedpropvalue2.setBoolean('O', flag3);
/*  276 */         v2cpackedpropvalue2.setBoolean('N', flag4);
/*  277 */         v2cproperty.putPackedValue("ThreadView.PopupConf", 
/*  278 */           v2cpackedpropvalue2);
/*      */       } else {
/*  280 */         v2cproperty.remove("ThreadView.PopupConf");
/*      */       }
/*      */     }
/*  283 */     int l = v2crespopupsp.getMaxWidth();
/*  284 */     int i1 = v2crespopupsp.getMaxHeight();
/*  285 */     if ((l > 0) && (i1 > 0) && ((l != nMaxPopupWidth) || (i1 != nMaxPopupHeight))) {
/*  286 */       nMaxPopupWidth = l;
/*  287 */       nMaxPopupHeight = i1;
/*  288 */       v2cproperty.putDimension("ThreadView.MaxPopupSize", new java.awt.Dimension(
/*  289 */         l, i1));
/*      */     }
/*  291 */     nDefaultScale = Math.min(Math.max(v2crespopupsp.getScale(), -3), 3);
/*  292 */     if (nDefaultScale != 0) {
/*  293 */       v2cproperty.putInt("ThreadView.PopupScale", nDefaultScale);
/*      */     } else {
/*  295 */       v2cproperty.remove("ThreadView.PopupScale");
/*      */     }
/*  297 */     int j1 = v2crespopupsp.getMinResNumColumns();
/*  298 */     if (j1 <= 1) {
/*  299 */       j1 = 0;
/*      */     }
/*  301 */     boolean flag5 = v2crespopupsp.getRNZeroPadding();
/*  302 */     boolean flag6 = v2crespopupsp.getShowSelRes();
/*  303 */     boolean flag7 = v2crespopupsp.getJumpByNumKey();
/*  304 */     boolean flag8 = v2crespopupsp.getDisableCtrlWheel();
/*  305 */     boolean flag9 = v2crespopupsp.getOmitSingleGTResRef();
/*  306 */     boolean flag10 = v2crespopupsp.getAlwaysShowResCheckBox();
/*  307 */     boolean flag11 = v2crespopupsp.getCopyWhenSelect();
/*  308 */     boolean flag12 = v2crespopupsp.jcbParseJPDomain.isSelected();
/*  309 */     boolean flag13 = v2crespopupsp.getResetUnreadWhenShown();
/*  310 */     boolean flag14 = v2crespopupsp.getExpandGetDelPMItems();
/*  311 */     int k1 = v2crespopupsp.getSmoothScrollStep();
/*  312 */     boolean flag15 = flag14 ^ bExpandGetDelPMItems;
/*  313 */     int l1 = v2crespopupsp.getDefRCFThreshold();
/*  314 */     if ((flag6 != bShowSelRes) || (j1 != nMinResNumColumns) || 
/*  315 */       (flag5 != bRNZeroPadding) || (flag7 != bJumpByNumKey) || 
/*  316 */       (flag8 != bDisableCtrlWheel) || (flag9 != bOmitSingleGTResRef) || 
/*  317 */       (flag11 != bCopyWhenSelect) || (flag12 != bParseJPDomain) || 
/*  318 */       (flag13 != bResetUnreadWhenShown) || (flag15) || 
/*  319 */       (flag10 != bAlwaysShowResCheckBox) || (k1 != nSmoothScrollStep) || 
/*  320 */       (l1 != nDefRCFThreshold)) {
/*  321 */       if ((j1 != nMinResNumColumns) || (flag5 != bRNZeroPadding)) {
/*  322 */         i |= 0x8;
/*  323 */         nMinResNumColumns = j1;
/*  324 */         bRNZeroPadding = flag5;
/*      */       }
/*  326 */       if (flag13 != bResetUnreadWhenShown) {
/*  327 */         i |= 0x2;
/*      */       }
/*  329 */       if ((flag6 != bShowSelRes) || (flag10 != bAlwaysShowResCheckBox)) {
/*  330 */         i |= 0x1;
/*  331 */         bShowSelRes = flag6;
/*  332 */         bAlwaysShowResCheckBox = flag10;
/*      */       }
/*  334 */       bJumpByNumKey = flag7;
/*  335 */       bDisableCtrlWheel = flag8;
/*  336 */       bOmitSingleGTResRef = flag9;
/*  337 */       bCopyWhenSelect = flag11;
/*  338 */       bParseJPDomain = flag12;
/*  339 */       bResetUnreadWhenShown = flag13;
/*  340 */       bExpandGetDelPMItems = flag14;
/*  341 */       nSmoothScrollStep = k1;
/*  342 */       nDefRCFThreshold = l1;
/*  343 */       saveMiscConf();
/*  344 */       if (flag15) {
/*  345 */         V2CMain.clearMenus();
/*      */       }
/*      */     }
/*  348 */     boolean flag16 = v2crespopupsp.getResAnchorExpand();
/*  349 */     boolean flag17 = v2crespopupsp.getExpandResAnchorBeforeMessage();
/*  350 */     boolean flag18 = v2crespopupsp.getUseCurrentStyleForInnerRes();
/*  351 */     boolean flag19 = v2crespopupsp.getNoThumbnailInInnerRes();
/*  352 */     int i2 = v2crespopupsp.getMaxResAnchorExpandNum();
/*  353 */     int j2 = v2crespopupsp.getMaxInnerResMsgLines();
/*  354 */     int k2 = v2crespopupsp.getMinInnerResIndex();
/*  355 */     if ((flag16 != bDefExpandResAnchor) || 
/*  356 */       (flag18 != bUseCurrentStyleForInnerRes) || 
/*  357 */       (flag17 != bExpandResAnchorBeforeMessage) || 
/*  358 */       (flag19 != bNoThumbnailInInnerRes) || 
/*  359 */       (i2 != nMaxResAnchorExpand) || (nMaxInnerResMsgLines != j2) || 
/*  360 */       (nMinInnerResIndex != k2)) {
/*  361 */       bDefExpandResAnchor = flag16;
/*  362 */       if (i2 != nMaxResAnchorExpand) {
/*  363 */         nMaxResAnchorExpand = i2;
/*  364 */         ilInnerResDrawn = new int[i2];
/*  365 */         i |= 0x8;
/*      */       }
/*  367 */       if (j2 != nMaxInnerResMsgLines) {
/*  368 */         nMaxInnerResMsgLines = j2;
/*  369 */         i |= 0x8;
/*      */       }
/*  371 */       if (k2 != nMinInnerResIndex) {
/*  372 */         nMinInnerResIndex = k2;
/*  373 */         i |= 0x8;
/*      */       }
/*  375 */       if (flag19 != bNoThumbnailInInnerRes) {
/*  376 */         bNoThumbnailInInnerRes = flag19;
/*  377 */         i |= 0x8;
/*      */       }
/*  379 */       if (flag17 != bExpandResAnchorBeforeMessage) {
/*  380 */         bExpandResAnchorBeforeMessage = flag17;
/*  381 */         i |= 0x10;
/*      */       }
/*  383 */       if (flag18 != bUseCurrentStyleForInnerRes) {
/*  384 */         bUseCurrentStyleForInnerRes = flag18;
/*  385 */         V2CThreadPanel.notifyUseCurrentStyleForInnerResChanged();
/*  386 */         i &= 0xFFFFFFF7;
/*      */       }
/*  388 */       saveResRefConf();
/*      */     }
/*  390 */     i |= v2crespopupsp.postConfig();
/*  391 */     if (flag) {
/*  392 */       V2CThreadPanel.requestChange(i);
/*      */     }
/*  394 */     return i;
/*      */   }
/*      */   
/*      */   static java.awt.Dimension getMaxPopupSize() {
/*  398 */     if ((nMaxPopupWidth == 0) || (nMaxPopupHeight == 0)) {
/*  399 */       calcMaxPopupSize();
/*      */     }
/*  401 */     return new java.awt.Dimension(nMaxPopupWidth, nMaxPopupHeight);
/*      */   }
/*      */   
/*      */   static void calcMaxPopupSize() {
/*  405 */     V2CThreadViewPane v2cthreadviewpane = V2CMain.getDisplayPane();
/*  406 */     nMaxPopupWidth = v2cthreadviewpane.getWidth();
/*  407 */     nMaxPopupHeight = v2cthreadviewpane.getHeight();
/*  408 */     if (nMaxPopupWidth <= 0) {
/*  409 */       nMaxPopupWidth = 400;
/*      */     }
/*  411 */     if (nMaxPopupHeight <= 0) {
/*  412 */       nMaxPopupHeight = 300;
/*      */     }
/*      */   }
/*      */   
/*      */ 
/*      */   public V2CThreadPopup(V2CAbstractThreadPanel v2cabstractthreadpanel, int i, V2CPopupPos v2cpopuppos, int[] ai)
/*      */   {
/*  419 */     this(v2cabstractthreadpanel, v2cabstractthreadpanel, i, v2cpopuppos, ai, -1, false, null);
/*      */   }
/*      */   
/*      */ 
/*      */   public V2CThreadPopup(V2CAbstractThreadPanel v2cabstractthreadpanel, int i, V2CPopupPos v2cpopuppos, int[] ai, int j)
/*      */   {
/*  425 */     this(v2cabstractthreadpanel, v2cabstractthreadpanel, i, v2cpopuppos, ai, j, false, null);
/*      */   }
/*      */   
/*      */ 
/*      */ 
/*      */   public V2CThreadPopup(V2CAbstractThreadPanel v2cabstractthreadpanel, int i, V2CPopupPos v2cpopuppos, int[] ai, int j, V2CThreadPopupRequest v2cthreadpopuprequest)
/*      */   {
/*  432 */     this(v2cabstractthreadpanel, v2cabstractthreadpanel, i, v2cpopuppos, ai, j, false, v2cthreadpopuprequest);
/*      */   }
/*      */   
/*      */ 
/*      */   public V2CThreadPopup(V2CAbstractThreadPanel v2cabstractthreadpanel, int i, V2CPopupPos v2cpopuppos, int[] ai, int j, boolean flag)
/*      */   {
/*  438 */     this(v2cabstractthreadpanel, v2cabstractthreadpanel, i, v2cpopuppos, ai, j, flag, null);
/*      */   }
/*      */   
/*      */ 
/*      */ 
/*      */   public V2CThreadPopup(V2CAbstractThreadPanel v2cabstractthreadpanel, V2CAbstractThreadPanel v2cabstractthreadpanel1, int i, V2CPopupPos v2cpopuppos, int[] ai)
/*      */   {
/*  445 */     this(v2cabstractthreadpanel, v2cabstractthreadpanel1, i, v2cpopuppos, ai, -1, false, null);
/*      */   }
/*      */   
/*      */ 
/*      */ 
/*      */   private V2CThreadPopup(V2CAbstractThreadPanel v2cabstractthreadpanel, V2CAbstractThreadPanel v2cabstractthreadpanel1, int i, V2CPopupPos v2cpopuppos, int[] ai, int j, boolean flag, V2CThreadPopupRequest v2cthreadpopuprequest)
/*      */   {
/*  452 */     super(true, false, v2cabstractthreadpanel1.isTwitter());
/*  453 */     this.vPopupPos = v2cpopuppos;
/*  454 */     long l = System.currentTimeMillis();
/*  455 */     if (v2cthreadpopuprequest == null) {
/*  456 */       v2cthreadpopuprequest = new V2CThreadPopupRequest();
/*      */     }
/*  458 */     boolean flag1 = v2cthreadpopuprequest.getNoOwner();
/*  459 */     this.bInNotification = flag1;
/*  460 */     this.nPopupType = i;
/*  461 */     this.vtpParent = v2cabstractthreadpanel;
/*  462 */     this.vtpThreadParent = v2cabstractthreadpanel1;
/*  463 */     V2CThreadItem v2cthreaditem = v2cabstractthreadpanel1.vtiThreadItem;
/*  464 */     this.vtiThreadItem = v2cthreaditem;
/*  465 */     this.vtrThreadRes = v2cabstractthreadpanel1.vtrThreadRes;
/*  466 */     this.cTLType = v2cabstractthreadpanel1.cTLType;
/*  467 */     this.lTLOwnerID = v2cabstractthreadpanel1.lTLOwnerID;
/*  468 */     this.vTLOwner = v2cabstractthreadpanel1.vTLOwner;
/*  469 */     this.bShowNGRes = ((flag) || (v2cabstractthreadpanel.bShowNGRes));
/*  470 */     this.bLineWrap = bPopupLineWrap;
/*  471 */     this.nlDisplayIndex = ai;
/*  472 */     int k = ai.length;
/*  473 */     this.nDisplayIndex = k;
/*  474 */     if ((k > 1) && (getShowFromNewest()) && (ai[0] < ai[(k - 1)])) {
/*  475 */       V2CMiscUtil.revertIntArray(ai, k);
/*      */     }
/*  477 */     if ((this.bTwitter) && (V2CTwitterBBS.isHiddenThread(v2cthreaditem))) {
/*  478 */       V2CTwitterThreadRes v2ctwitterthreadres = (V2CTwitterThreadRes)this.vtrThreadRes;
/*  479 */       long[] al = new long[k];
/*  480 */       for (int i1 = k - 1; i1 >= 0; i1--) {
/*  481 */         V2CTweetItem v2ctweetitem = v2ctwitterthreadres
/*  482 */           .getTweetItem(ai[i1]);
/*  483 */         if (v2ctweetitem != null) {
/*  484 */           al[i1] = v2ctweetitem.getTweetID();
/*      */         }
/*      */       }
/*      */       
/*  488 */       this.ilTwID = al;
/*      */     }
/*  490 */     this.nlNLines = new int[k];
/*  491 */     this.nlWidths = new int[k];
/*  492 */     this.nllLayoutInfo = new int[k][];
/*  493 */     this.iResToMark = j;
/*  494 */     this.vNGWordMatrix = v2cabstractthreadpanel1.vNGWordMatrix;
/*  495 */     this.vNameKWHighlightSet = v2cabstractthreadpanel1.vNameKWHighlightSet;
/*  496 */     this.vKeywordHighlightSet = v2cabstractthreadpanel1.vKeywordHighlightSet;
/*  497 */     this.vSpecialKeywordHighlight = v2cabstractthreadpanel1.vSpecialKeywordHighlight;
/*  498 */     this.vTextMarker = v2cabstractthreadpanel1.vTextMarker;
/*  499 */     this.vResNote = v2cabstractthreadpanel1.vResNote;
/*  500 */     this.iBookMark = v2cabstractthreadpanel1.iBookMark;
/*  501 */     this.vNGTwitterUserSet = v2cabstractthreadpanel1.vNGTwitterUserSet;
/*  502 */     this.vNormalThreadStyle = (this.vThreadStyle = 
/*  503 */       V2CThreadStyle.getStyle(v2cthreaditem));
/*  504 */     getDefaultResStyle(true);
/*  505 */     setFocusable(false);
/*  506 */     createComponents();
/*  507 */     this.bStyleChanged = true;
/*  508 */     this.nScale = (flag1 ? 0 : nDefaultScale);
/*  509 */     this.dScale = Math.pow(1.2D, this.nScale);
/*  510 */     this.fBoldOffset = ((float)(1.0D / this.dScale));
/*  511 */     if (this.nScale != 0) {
/*  512 */       this.fBoldOffset += 0.001F;
/*      */     }
/*  514 */     Object obj = null;
/*  515 */     Object obj1 = v2cthreadpopuprequest.getOwnerFrame();
			   bAltMode = V2CThreadPanel.getActivePanel().bAltMode;
/*  516 */     if ((obj1 == null) && (!flag1)) {
/*  517 */       if (v2cabstractthreadpanel != null) {
/*  518 */         java.awt.Window window = 
/*  519 */           javax.swing.SwingUtilities.getWindowAncestor(v2cabstractthreadpanel);
/*  520 */         if (window != null) {
/*  521 */           java.awt.Window window1 = window.getOwner();
/*  522 */           if ((window1 instanceof javax.swing.JFrame)) {
/*  523 */             obj1 = (javax.swing.JFrame)window1;
/*      */           }
/*      */         }
/*      */       }
/*  527 */       if (obj1 == null) {
/*  528 */         obj1 = V2CMain.v2cMain;
/*      */       }
/*      */     }
/*  531 */     if (obj1 != null) {
/*      */       Object obj2;
/*      */       java.awt.Component component;
/*  534 */       if (V2CMain.getUseJDialogForPopup()) {
/*  535 */         javax.swing.JDialog jdialog = new javax.swing.JDialog((java.awt.Frame)obj1, false);
/*  536 */         obj2 = jdialog;
/*  537 */         jdialog.setUndecorated(true);
/*  538 */         jdialog.setContentPane(this);
/*  539 */         component = jdialog.getGlassPane();
/*  540 */         if ((component instanceof javax.swing.JComponent)) {
/*  541 */           V2CInputMap.setKeyBind((javax.swing.JComponent)component, 0, 
/*  542 */             "ThreadView");
/*      */         }
/*      */       } else {
/*  545 */         javax.swing.JWindow jwindow = new javax.swing.JWindow((java.awt.Frame)obj1);
/*  546 */         obj2 = jwindow;
/*  547 */         jwindow.setContentPane(this);
/*  548 */         component = jwindow.getGlassPane();
/*      */       }
/*  550 */       this.jwPopupWindow = ((java.awt.Window)obj2);
/*  551 */       GlassPaneMouseListener glasspanemouselistener = new GlassPaneMouseListener();
/*  552 */       component.addMouseListener(glasspanemouselistener);
/*  553 */       component.addMouseMotionListener(glasspanemouselistener);
/*  554 */       component.addMouseWheelListener(glasspanemouselistener);
/*  555 */       component.setVisible(true);
/*  556 */       ((java.awt.Window)obj2).setVisible(true);
				 ((java.awt.Window)obj2).toFront();
/*  557 */       setPopupGeometry(0);
/*      */     }
/*  559 */     setSelTextIM(false);
/*  560 */     if ((j >= 0) && (k > 1)) {
/*  561 */       int j1 = j;
/*  562 */       int k1 = 0;
/*  563 */       if (i == 0) {
/*  564 */         int l1 = ai[0];
/*  565 */         if (l1 < j) {
/*  566 */           k1 = -this.lineHeight;
/*  567 */         } else if (l1 == j) {
/*  568 */           j1++;
/*      */         } else {
/*  570 */           j1 = -1;
/*      */         }
/*      */       }
/*  573 */       if (j1 >= 0) {
/*  574 */         goToResNumber(j1, k1);
/*      */       }
/*      */     }
/*      */   }
/*      */   
/*      */   void createComponents() {
/*  580 */     createComponents(new PopupPopupListener());
/*  581 */     setBackground(this.vtpThreadParent != this.vtpParent ? cPopupAltBG : cPopupBG);
/*  582 */     setBorder(javax.swing.BorderFactory.createLineBorder(this.vThreadStyle.getFrameColor()));
/*  583 */     Insets insets = getInsets();
/*  584 */     this.iInsLeft = insets.left;
/*  585 */     this.iInsTop = insets.top;
/*      */   }
/*      */   
/*      */   public void setCursor(java.awt.Cursor cursor) {
/*  589 */     java.awt.Component component = V2CSwingUtil.getGlassPane(this.jwPopupWindow);
/*  590 */     if (component != null) {
/*  591 */       component.setCursor(cursor);
/*      */     }
/*      */   }
/*      */   
/*      */   public V2CProgressState getProgressState() {
/*  596 */     return null;
/*      */   }
/*      */   
/*      */   public String getSaveTabString() {
/*  600 */     return null;
/*      */   }
/*      */   
/*      */ 
/*      */ 
/*      */   public boolean close()
/*      */   {
/*  607 */     this.bClosed = true;
/*  608 */     return true;
/*      */   }
/*      */   
/*      */   public boolean canLock() {
/*  612 */     return false;
/*      */   }
/*      */   
/*      */   public boolean isLocked() {
/*  616 */     return false;
/*      */   }
/*      */   
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */   void toggleFloating(boolean flag)
/*      */   {
/*  626 */     if ((flag) && ((this.vppChild instanceof V2CThreadPopup))) {
/*  627 */       ((V2CThreadPopup)this.vppChild).toggleFloating(true);
/*  628 */       return;
/*      */     }
/*  630 */     boolean flag1 = !this.bFloating;
/*  631 */     this.bFloating = flag1;
/*  632 */     if (flag1) {
/*  633 */       setFocusable(true);
/*  634 */       V2CInputMap.setKeyBind(this, 0, "ThreadView");
/*  635 */       java.awt.Container container = 
/*  636 */         V2CSwingUtil.getContentPane(this.jwPopupWindow);
/*  637 */       if ((container instanceof javax.swing.JComponent)) {
/*  638 */         V2CInputMap.setKeyBind((javax.swing.JComponent)container, 1, "Global");
/*      */       }
/*  640 */       this.jwPopupWindow.setVisible(false);
/*  641 */       javax.swing.SwingUtilities.invokeLater(new Runnable()
/*      */       {
/*      */         public void run() {
/*  644 */           V2CThreadPopup.this.jwPopupWindow.setVisible(true);
					 V2CThreadPopup.this.jwPopupWindow.toFront();
/*      */         }
/*      */         
/*  647 */       });
/*  648 */       this.vtpParent = null;
/*  649 */       V2CAbstractThreadPanel v2cabstractthreadpanel = this.vtpThreadParent;
/*  650 */       if (!(v2cabstractthreadpanel instanceof V2CThreadPanel)) {
/*  651 */         this.vtpThreadParent = 
/*  652 */           V2CThreadPanel.loadThreadIfNotLoaded(this.vtiThreadItem);
/*      */       }
/*      */     } else {
/*  655 */       closePopupWindow();
/*      */     }
/*  657 */     V2CThreadPanel.floatingStateChanged(this);
/*      */   }
/*      */   
/*      */   void doLayoutWorks() {
/*  661 */     if (this.bClosed) {
/*  662 */       return;
/*      */     }
/*  664 */     this.nThreadDisplayHeight = getHeight();
/*  665 */     this.rDrawingArea = null;
/*  666 */     if ((getWidth() > 1) && (getHeight() > 1)) {
/*  667 */       resizeScrollBar();
/*      */     }
/*      */   }
/*      */   
/*      */   boolean getShowFromNewest() {
/*  672 */     return this.bInNotification ? true : super.getShowFromNewest();
/*      */   }
/*      */   
/*      */   void filterNextThread(boolean flag) {
/*  676 */     filterNextThread(false, false, flag);
/*      */   }
/*      */   
/*      */   void resToThisRes(int[] ai, boolean flag) {
/*  680 */     V2CAbstractThreadPanel v2cabstractthreadpanel = getRootPanel();
/*      */     V2CThreadPanel v2cthreadpanel;
/*  682 */     if (((v2cabstractthreadpanel instanceof V2CThreadPanel)) && 
/*  683 */       (v2cabstractthreadpanel.vtiThreadItem == this.vtiThreadItem)) {
/*  684 */       v2cthreadpanel = (V2CThreadPanel)v2cabstractthreadpanel;
/*      */     } else {
/*  686 */       v2cthreadpanel = V2CThreadPanel.getOpenPanel(this.vtiThreadItem);
/*  687 */       if (v2cthreadpanel == null) {
/*  688 */         return;
/*      */       }
/*      */     }
/*  691 */     v2cthreadpanel.resToThisRes(ai, flag);
/*      */   }
/*      */   
/*      */   void resNumClicked(int i) {
/*  695 */     resNumClicked(i, true);
/*      */   }
/*      */   
/*      */   private void resNumClicked(int i, boolean flag) {
/*  699 */     V2CAbstractThreadPanel v2cabstractthreadpanel = getRootPanel();
/*  700 */     if (((v2cabstractthreadpanel instanceof V2CThreadPanel)) && 
/*  701 */       (((V2CThreadPanel)v2cabstractthreadpanel).isAttached()) && 
/*  702 */       (v2cabstractthreadpanel.getThreadItem() == this.vtiThreadItem)) {
/*  703 */       if (flag)
/*      */       {
/*  705 */         ((V2CThreadPanel)v2cabstractthreadpanel).resNumClicked(i, true);
/*      */       } else {
/*  707 */         ((V2CThreadPanel)v2cabstractthreadpanel).resLinkClicked(i, 
/*  708 */           true);
/*      */       }
/*      */     } else {
/*  711 */       V2CThreadOpenRequest v2cthreadopenrequest = new V2CThreadOpenRequest();
/*  712 */       v2cthreadopenrequest.setResNumToGo(i);
/*  713 */       V2CThreadPanel.open(this.vtiThreadItem, false, true, 
/*  714 */         v2cthreadopenrequest);
/*      */     }
/*      */   }
/*      */   
/*      */   void resLinkClicked(int i) {
/*  719 */     resNumClicked(i, false);
/*      */   }
/*      */   
/*      */   void applyNGWord() {
/*  723 */     if (this.vtpParent != null) {
/*  724 */       this.vtpParent.applyNGWord();
/*      */     }
/*      */   }
/*      */   
/*      */   void setHideThisRes(int[] ai, boolean flag, boolean flag1) {
/*  729 */     V2CThreadPanel v2cthreadpanel = 
/*  730 */       V2CThreadPanel.getOpenPanel(this.vtiThreadItem);
/*  731 */     if (v2cthreadpanel != null) {
/*  732 */       v2cthreadpanel.setHideThisRes(ai, flag, flag1);
/*  733 */     } else if (setHideThisRes0(ai, flag, flag1)) {
/*  734 */       V2CThreadPanel v2cthreadpanel1 = V2CThreadPanel.getActivePanel();
/*  735 */       if (v2cthreadpanel1 != null) {
/*  736 */         v2cthreadpanel1.closeChildPopups(true);
/*      */       }
/*      */     }
/*      */   }
/*      */   
/*      */   public void paintComponent(java.awt.Graphics g) {
/*  742 */     if ((!this.bGeometrySet) || (this.bClosed)) {
/*  743 */       return;
/*      */     }
/*  745 */     if ((this.bTwitter) && (this.ilTwID != null)) {
/*  746 */       V2CTwitterThreadRes v2ctwitterthreadres = (V2CTwitterThreadRes)this.vtrThreadRes;
/*  747 */       long[] al = this.ilTwID;
/*  748 */       int i = al.length;
/*  749 */       for (int j = i - 1; j >= 0; j--) {
/*  750 */         long l = al[j];
/*  751 */         if (l > 0L)
/*      */         {
/*      */ 
/*  754 */           V2CTweetItem v2ctweetitem = v2ctwitterthreadres
/*  755 */             .getTweetItem(this.nlDisplayIndex[j]);
/*  756 */           long l1 = v2ctweetitem.getTweetID();
/*  757 */           if ((v2ctweetitem != null) && (l1 != l))
/*      */           {
/*      */ 
/*  760 */             int k = v2ctwitterthreadres.getNRes();
/*  761 */             int i1 = k - 1;
/*      */             
/*  763 */             while (i1 >= 0)
/*      */             {
/*      */ 
/*  766 */               V2CTweetItem v2ctweetitem1 = v2ctwitterthreadres
/*  767 */                 .getTweetItem(i1);
/*  768 */               if ((v2ctweetitem1 != null) && 
/*  769 */                 (v2ctweetitem1.getTweetID() == l)) {
/*  770 */                 this.nlDisplayIndex[j] = i1;
/*  771 */                 break;
/*      */               }
/*  773 */               i1--;
/*      */             }
/*      */           }
/*      */         }
/*      */       } }
/*  778 */     java.awt.Graphics2D graphics2d = (java.awt.Graphics2D)g.create();
/*  779 */     draw(graphics2d);
/*  780 */     graphics2d.dispose();
/*      */   }
/*      */   
/*      */   boolean checkContentHeight() {
/*  784 */     return true;
/*      */   }
/*      */   
/*      */   void toggleAltFont() {
/*  788 */     if ((this.vppChild instanceof V2CThreadPopup)) {
/*  789 */       ((V2CThreadPopup)this.vppChild).toggleAltFont();
/*      */     } else {
/*  791 */       java.awt.EventQueue.invokeLater(new Runnable()
/*      */       {
/*      */         public void run() {
/*  794 */           V2CThreadPopup.this.bAltMode = (!V2CThreadPopup.this.bAltMode);
/*  795 */           V2CThreadPopup.this.rememberViewPosition();
/*  796 */           V2CThreadPopup.this.setPopupGeometry(0);
/*  797 */           V2CThreadPopup.this.repaint();
//					 V2CThreadPanel v2cthreadpanel = V2CThreadPanel.getActivePanel();
//					 v2cthreadpanel.bAltMode = bAltMode;
//					 v2cthreadpanel.repaint();
/*      */         }
/*      */       });
/*      */     }
/*      */   }
/*      */   
/*      */   void toggleTempShowNGRes() {
/*  804 */     if ((this.vppChild instanceof V2CThreadPopup)) {
/*  805 */       ((V2CThreadPopup)this.vppChild).toggleTempShowNGRes();
/*      */     } else {
/*  807 */       java.awt.EventQueue.invokeLater(new Runnable()
/*      */       {
/*      */         public void run() {
/*  810 */           V2CThreadPopup.this.bShowNGRes = (!V2CThreadPopup.this.bShowNGRes);
/*  811 */           V2CThreadPopup.this.rememberViewPosition();
/*  812 */           V2CThreadPopup.this.setPopupGeometry(0);
/*  813 */           V2CThreadPopup.this.repaint();
/*      */         }
/*      */       });
/*      */     }
/*      */   }
/*      */   
/*      */   void imageInserted(int i, boolean flag) {
/*  820 */     int j = this.nDisplayIndex;
/*  821 */     boolean flag1 = false;
/*  822 */     if (i >= 0) {
/*  823 */       boolean flag2 = getShowFromNewest();
/*  824 */       int[] ai1 = this.nlDisplayIndex;
/*  825 */       int l = 0;
/*      */       
/*  827 */       while (l < j)
/*      */       {
/*      */ 
/*  830 */         int i1 = ai1[l];
/*  831 */         if (i1 == i) {
/*  832 */           flag1 = true;
/*  833 */           int j1 = this.nlNLines[l];
/*  834 */           if (j1 <= 0) break;
/*  835 */           this.nlNLines[l] = (-j1);
/*      */           
/*  837 */           break;
/*      */         }
/*  839 */         if (flag2 ? i1 < i : i1 > i) {
/*      */           break;
/*      */         }
/*  842 */         l++;
/*      */       }
/*      */     }
/*  845 */     int[] ai = this.nlNLines;
/*  846 */     int k = 0;
/*      */     
/*  848 */     while (k < j)
/*      */     {
/*      */ 
/*  851 */       if (ai[k] < 0) {
/*  852 */         flag1 = true;
/*  853 */         break;
/*      */       }
/*  855 */       k++;
/*      */     }
/*      */     
/*  858 */     if ((flag) && (flag1) && (!this.bSetPopupGeometryArmed)) {
/*  859 */       this.bSetPopupGeometryArmed = true;
/*  860 */       java.awt.EventQueue.invokeLater(new Runnable()
/*      */       {
/*      */         public void run() {
/*  863 */           V2CThreadPopup.this.bSetPopupGeometryArmed = false;
/*  864 */           V2CThreadPopup.this.rememberViewPosition();
/*  865 */           V2CThreadPopup.this.setPopupGeometry(V2CThreadPopup.this.vtrThreadRes.getNRes());
/*  866 */           V2CThreadPopup.this.repaint();
/*      */         }
/*      */       });
/*      */     }
/*  870 */     if ((this.vppChild instanceof V2CThreadPopup)) {
/*  871 */       ((V2CThreadPopup)this.vppChild).imageInserted(i, flag);
/*      */     }
/*      */   }
/*      */   
/*      */   int getMinContentWidth() {
/*  876 */     return this.nDrawingWidth;
/*      */   }
/*      */   
/*      */   int getDrawingWidth() {
/*  880 */     return this.nDrawingWidth0;
/*      */   }
/*      */   
/*      */   java.awt.Dimension calcGeometry(int i) {
/*  884 */     Insets insets = getInsets();
/*  885 */     if (nMaxPopupHeight == 0) {
/*  886 */       calcMaxPopupSize();
/*      */     }
/*  888 */     int j = nMaxPopupHeight;
/*  889 */     java.awt.Graphics2D graphics2d = (java.awt.Graphics2D)getGraphics();
/*  890 */     if (graphics2d == null) {
/*  891 */       graphics2d = getBufferGraphics();
/*      */     }
/*  893 */     boolean flag = this.nScale == 0;
/*  894 */     int k = i - insets.left - nScrollBarWidth;
/*  895 */     int l = flag ? k : (int)Math.ceil(k / this.dScale);
/*  896 */     java.awt.Dimension dimension = calcSize(graphics2d, insets.left, i, 0);
/*  897 */     if (dimension == null) {
/*  898 */       return null;
/*      */     }
/*  900 */     graphics2d.dispose();
/*  901 */     this.bContentHeightCalculated = true;
/*  902 */     int i1 = dimension.width;
/*  903 */     int j1 = dimension.height;
/*  904 */     this.nDrawingWidth = i1;
/*  905 */     boolean flag1 = i1 > i;
/*  906 */     int k1 = j - insets.top - (flag1 ? nScrollBarWidth : insets.bottom);
/*  907 */     int l1 = flag ? k1 : (int)Math.ceil(k1 / this.dScale);
/*  908 */     boolean flag2 = j1 > l1;
/*  909 */     if (!flag) {
/*  910 */       i1 = (int)(i1 * this.dScale);
/*  911 */       j1 = (int)(j1 * this.dScale);
/*      */     }
/*  913 */     i1 += insets.left + (flag2 ? nScrollBarWidth : insets.right);
/*  914 */     j1 += insets.top + (flag1 ? nScrollBarWidth : insets.bottom);
/*  915 */     i = Math.min(i, flag1 ? i - nScrollBarWidth : flag2 ? i : i1);
/*  916 */     j = Math.min(j, j1);
/*  917 */     dimension.setSize(i, j);
/*  918 */     setPreferredSize(dimension);
/*  919 */     this.bGeometrySet = true;
/*  920 */     return dimension;
/*      */   }
/*      */   
/*      */   void setPopupGeometry(int i) {
/*  924 */     V2CPopupPos v2cpopuppos = this.vPopupPos;
/*  925 */     java.awt.Point point = null;
/*  926 */     if (v2cpopuppos != null) {
/*  927 */       point = v2cpopuppos.vNormalPopupPoint;
/*      */     }
/*  929 */     if (point == null) {
/*  930 */       point = this.jwPopupWindow.getLocation();
/*      */     }
/*  932 */     Rectangle rectangle = V2CSwingUtil.getScreenBoundsAt(point);
/*  933 */     this.rScreenBounds = rectangle;
/*  934 */     Insets insets = getInsets();
/*  935 */     if ((nMaxPopupWidth == 0) || (nMaxPopupHeight == 0)) {
/*  936 */       calcMaxPopupSize();
/*      */     }
/*  938 */     int j = Math.min(nMaxPopupWidth, rectangle.width - 2);
/*  939 */     int k = Math.min(nMaxPopupHeight, rectangle.height - 2);
/*  940 */     java.awt.Graphics2D graphics2d = (java.awt.Graphics2D)getGraphics();
/*  941 */     if (graphics2d == null) {
/*  942 */       graphics2d = getBufferGraphics();
/*      */     }
/*  944 */     boolean flag = this.nScale == 0;
/*  945 */     int l = j - insets.left - nScrollBarWidth;
/*  946 */     int i1 = flag ? l : (int)Math.ceil(l / this.dScale);
/*  947 */     java.awt.Dimension dimension = calcSize(graphics2d, insets.left, this.bLineWrap ? i1 : 
/*  948 */       100000, i);
/*  949 */     graphics2d.dispose();
/*  950 */     if (dimension == null) {
/*  951 */       return;
/*      */     }
/*  953 */     this.bContentHeightCalculated = true;
/*  954 */     int j1 = dimension.width;
/*  955 */     int k1 = dimension.height;
/*  956 */     this.nDrawingWidth = j1;
/*  957 */     boolean flag1 = j1 > i1;
/*  958 */     int l1 = k - insets.top - (flag1 ? nScrollBarWidth : insets.bottom);
/*  959 */     int i2 = flag ? l1 : (int)Math.ceil(l1 / this.dScale);
/*  960 */     boolean flag2 = k1 > i2;
/*  961 */     if (!flag) {
/*  962 */       j1 = (int)(j1 * this.dScale);
/*  963 */       k1 = (int)(k1 * this.dScale);
/*      */     }
/*  965 */     j1 += insets.left + (flag2 ? nScrollBarWidth : insets.right);
/*  966 */     k1 += insets.top + (flag1 ? nScrollBarWidth : insets.bottom);
/*  967 */     j = Math.min(j, flag1 ? j - nScrollBarWidth : flag2 ? j : j1);
/*  968 */     k = Math.min(k, k1);
/*  969 */     dimension.setSize(j, k);
/*  970 */     setPreferredSize(dimension);
/*  971 */     invalidate();
/*  972 */     this.bGeometrySet = true;
/*  973 */     int j2 = (int)point.getX();
/*  974 */     int k2 = (int)point.getY();
/*  975 */     if (j2 + j + 2 > rectangle.x + rectangle.width) {
/*  976 */       j2 = rectangle.x + rectangle.width - j - 1;
/*  977 */       if (v2cpopuppos != null) {
/*  978 */         java.awt.Point point1 = v2cpopuppos.vMousePoint;
/*  979 */         Rectangle rectangle1 = v2cpopuppos.vPopupRegion;
/*  980 */         if ((point1 != null) && (rectangle1 != null) && (j2 <= point1.x)) {
/*  981 */           k2 = point1.y + 3;
/*  982 */           if (k2 >= rectangle1.y + rectangle1.height) {
/*  983 */             k2 = rectangle1.y + rectangle1.height - 1;
/*      */           }
/*      */         }
/*      */       }
/*      */     }
/*  988 */     if (k2 + k + 2 > rectangle.y + rectangle.height) {
/*  989 */       k2 = rectangle.y + rectangle.height - k - 1;
/*      */     }
/*  991 */     this.jwPopupWindow.setLocation(j2, k2);
/*  992 */     this.jwPopupWindow.pack();
/*  993 */     setVerticalScrollBar(V2CMiscUtil.divideCeil(dimension.height - 
/*  994 */       insets.top - (flag1 ? nScrollBarWidth : insets.bottom), 
/*  995 */       this.dScale));
/*  996 */     this.nDrawingWidth0 = 
/*  997 */       (dimension.width - insets.left - (this.bVSBShown ? this.jsbVertical.getWidth() : insets.right));
/*  998 */     if (this.nScale != 0) {
/*  999 */       this.nDrawingWidth0 = V2CMiscUtil.divideCeil(this.nDrawingWidth0, this.dScale);
/*      */     }
/* 1001 */     setHorizontalScrollBar();
/* 1002 */     this.vPopupPos = null;
/*      */   }
/*      */   
/*      */   public boolean isCloseOnExit() {
/* 1006 */     return !bFixPopup;
/*      */   }
/*      */   
/*      */   public void closePopupWindow() {
			   V2CThreadPanel v2cthreadpanel = V2CThreadPanel.getActivePanel();
			   v2cthreadpanel.bAltMode = bAltMode;
/* 1010 */     stopTimer(true);
/* 1011 */     closeChildPopups(false);
/* 1012 */     if (!this.bFloating) {
/* 1013 */       this.bClosed = true;
/* 1014 */       this.jwPopupWindow.dispose();
/*      */     }
/*      */   }
/*      */   
/*      */   boolean checkMousePressInOtherMode(java.awt.event.MouseEvent mouseevent, boolean flag) {
/* 1019 */     return false;
/*      */   }
/*      */   
/*      */   static {
/* 1023 */     V2CProperty v2cproperty = V2CMain.getUserProperty();
/* 1024 */     bPopupLineWrap = v2cproperty.getBoolean("ThreadView.PopupLineWrap", 
/* 1025 */       true);
/* 1026 */     cPopupBG = v2cproperty.getColor("ThreadView.PopupBG", null);
/* 1027 */     if (cPopupBG == null) {
/* 1028 */       cPopupBG = new java.awt.Color(1.0F, 1.0F, 0.9F);
/*      */     }
/* 1030 */     cPopupAltBG = v2cproperty.getColor("ThreadView.PopupAltBG", null);
/* 1031 */     if (cPopupAltBG == null) {
/* 1032 */       cPopupAltBG = new java.awt.Color(0.975F, 0.975F, 1.0F);
/*      */     }
/* 1034 */     java.awt.Dimension dimension = v2cproperty
/* 1035 */       .getDimension("ThreadView.MaxPopupSize");
/* 1036 */     if (dimension != null) {
/* 1037 */       nMaxPopupWidth = dimension.width;
/* 1038 */       nMaxPopupHeight = dimension.height;
/*      */     }
/* 1040 */     nDefaultScale = Math.min(
/* 1041 */       Math.max(v2cproperty.getInt("ThreadView.PopupScale"), -3), 3);
/*      */   }
/*      */   
/*      */   public void detouch() {}
/*      */   
/*      */   public void setLocked(boolean flag) {}
/*      */   
/*      */   public void saveState() {}
/*      */ }


/* Location:              H:\__Apps\jd-gui-windows-1.4.0\V2C_R20171103.jar!\org\monazilla\v2c\V2CThreadPopup.class
 * Java compiler version: 7 (51.0)
 * JD-Core Version:       0.7.1
 */