package org.monazilla.v2c;

import java.lang.reflect.Field;
import java.util.Arrays;

public class V2CSetLauncherToJNIlib
{

	static void exec()
	{
		String launcher = V2CLauncher.getJarDir().getAbsolutePath();
		String sLabel = "usr_paths Exception:";

		Field usr_paths;
		try {
			usr_paths = ClassLoader.class.getDeclaredField("usr_paths");
			usr_paths.setAccessible(true);

			// 現在の検索パスを取得します。
			String[] paths = (String[])usr_paths.get(null);

			// すでに検索パスに含まれていたら何もせずに復帰します。
			for(String path : paths) {
				if(path.equals(launcher)) {
					return;
				}
			}

			// 検索パスを追加した配列を新しく作成して usr_paths に代入します。
			String[] newPaths = Arrays.copyOf(paths, paths.length + 1);
			newPaths[newPaths.length - 1] = launcher;
			usr_paths.set(null, newPaths);

			System.out.println("usr_paths(org)="+Arrays.toString(paths));
			System.out.println("usr_paths(new)="+Arrays.toString(newPaths));
		} catch (NoSuchFieldException e) {
			// TODO 自動生成された catch ブロック
//			e.printStackTrace();
			System.out.println(sLabel + e.getClass().getSimpleName());
		} catch (SecurityException e) {
			// TODO 自動生成された catch ブロック
//			e.printStackTrace();
			System.out.println(sLabel + e.getClass().getSimpleName());
		} catch (IllegalArgumentException e) {
			// TODO 自動生成された catch ブロック
//			e.printStackTrace();
			System.out.println(sLabel + e.getClass().getSimpleName());
		} catch (IllegalAccessException e) {
			// TODO 自動生成された catch ブロック
//			e.printStackTrace();
			System.out.println(sLabel + e.getClass().getSimpleName());
		}
	}
}
