/*     */ package org.monazilla.v2c;
/*     */ 
/*     */ import java.awt.GridBagConstraints;
/*     */ import java.awt.GridBagLayout;
/*     */ import java.awt.Insets;
/*     */ import java.awt.Toolkit;
/*     */ import java.text.NumberFormat;
/*     */ import javax.swing.JCheckBox;
/*     */ import javax.swing.JFormattedTextField;
/*     */ import javax.swing.JLabel;
/*     */ import javax.swing.JPanel;
/*     */ import javax.swing.JPasswordField;
/*     */ import javax.swing.JTextField;
/*     */ import javax.swing.border.TitledBorder;
/*     */ import javax.swing.event.ChangeEvent;
/*     */ import javax.swing.event.ChangeListener;
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ public class V2CProxySettingPanel
/*     */   extends JPanel
/*     */   implements ChangeListener
/*     */ {
/*     */   V2CProxySetting psRead;
/*     */   V2CProxySetting psWrite;
/*     */   JCheckBox jcbUseSystemSetting;
/*     */   JCheckBox jcbUseReadProxy;
/*     */   JTextField jtfReadHost;
/*     */   JFormattedTextField jftfReadPort;
/*     */   JTextField jtfReadUser;
/*     */   JPasswordField jpfReadPass;
/*     */   JCheckBox jcbUseWriteProxy;
/*     */   JTextField jtfWriteHost;
/*     */   JFormattedTextField jftfWritePort;
/*     */   JTextField jtfWriteUser;
/*     */   JPasswordField jpfWritePass;
/*     */   V2CHttpTimeoutSettingPanel vHttpTimeoutSettingPanel;
/*     */   JCheckBox jcbPreferIPv6Addresses;
/*     */   
/*     */   public V2CProxySettingPanel(V2CProxySetting v2cproxysetting, V2CProxySetting v2cproxysetting1)
/*     */   {
/*  48 */     super(new GridBagLayout());
/*  49 */     this.psRead = v2cproxysetting;
/*  50 */     this.psWrite = v2cproxysetting1;
/*  51 */     GridBagConstraints gridbagconstraints = V2CSwingUtil.createGridBagConstraints();
/*  52 */     NumberFormat numberformat = NumberFormat.getIntegerInstance();
/*  53 */     numberformat.setGroupingUsed(false);
/*  54 */     JPanel jpanel = new JPanel(new GridBagLayout());
/*  55 */     jpanel.setBorder(new TitledBorder("読み込みProxy"));
/*  56 */     gridbagconstraints.gridx = 0;
/*  57 */     gridbagconstraints.gridy = 0;
/*  58 */     this.jcbUseReadProxy = new JCheckBox("Proxyを使用する", v2cproxysetting.proxyUsed());
/*  59 */     this.jcbUseReadProxy.setFocusable(false);
/*  60 */     gridbagconstraints.gridwidth = 0;
/*  61 */     gridbagconstraints.anchor = 17;
/*  62 */     jpanel.add(this.jcbUseReadProxy, gridbagconstraints);
/*  63 */     gridbagconstraints.gridwidth = 1;
/*  64 */     gridbagconstraints.gridx = 0;
/*  65 */     gridbagconstraints.gridy += 1;
/*  66 */     jpanel.add(new JLabel(" Host: "), gridbagconstraints);
/*  67 */     gridbagconstraints.gridx += 1;
/*  68 */     this.jtfReadHost = new V2CTextField(v2cproxysetting.getHost(), 20);
/*  69 */     jpanel.add(this.jtfReadHost, gridbagconstraints);
/*  70 */     gridbagconstraints.gridx += 1;
/*  71 */     jpanel.add(new JLabel("  Port: "), gridbagconstraints);
/*  72 */     gridbagconstraints.gridx += 1;
/*  73 */     this.jftfReadPort = new JFormattedTextField(numberformat);
/*  74 */     this.jftfReadPort.setHorizontalAlignment(4);
/*  75 */     this.jftfReadPort.setValue(new Integer(v2cproxysetting.getPort()));
/*  76 */     this.jftfReadPort.setColumns(6);
/*  77 */     jpanel.add(this.jftfReadPort, gridbagconstraints);
/*  78 */     gridbagconstraints.gridx = 0;
/*  79 */     gridbagconstraints.gridy += 1;
/*  80 */     jpanel.add(new JLabel(" ID: "), gridbagconstraints);
/*  81 */     gridbagconstraints.gridx += 1;
/*  82 */     this.jtfReadUser = new V2CTextField(v2cproxysetting.getID(), 15);
/*  83 */     jpanel.add(this.jtfReadUser, gridbagconstraints);
/*  84 */     gridbagconstraints.gridx = 0;
/*  85 */     gridbagconstraints.gridy += 1;
/*  86 */     jpanel.add(new JLabel(" PW: "), gridbagconstraints);
/*  87 */     gridbagconstraints.gridx += 1;
/*  88 */     this.jpfReadPass = new JPasswordField(v2cproxysetting.getPW(), 15);
/*  89 */     jpanel.add(this.jpfReadPass, gridbagconstraints);
/*  90 */     gridbagconstraints.gridx += 1;
/*  91 */     JPanel jpanel1 = new JPanel(new GridBagLayout());
/*  92 */     jpanel1.setBorder(new TitledBorder("書き込みProxy"));
/*  93 */     gridbagconstraints.gridx = 0;
/*  94 */     gridbagconstraints.gridy = 0;
/*  95 */     this.jcbUseWriteProxy = new JCheckBox("Proxyを使用する", v2cproxysetting1.proxyUsed());
/*  96 */     this.jcbUseWriteProxy.setFocusable(false);
/*  97 */     gridbagconstraints.gridwidth = 0;
/*  98 */     jpanel1.add(this.jcbUseWriteProxy, gridbagconstraints);
/*  99 */     gridbagconstraints.gridwidth = 1;
/* 100 */     gridbagconstraints.gridy += 1;
/* 101 */     jpanel1.add(new JLabel(" Host: "), gridbagconstraints);
/* 102 */     gridbagconstraints.gridx += 1;
/* 103 */     this.jtfWriteHost = new V2CTextField(v2cproxysetting1.getHost(), 20);
/* 104 */     jpanel1.add(this.jtfWriteHost, gridbagconstraints);
/* 105 */     gridbagconstraints.gridx += 1;
/* 106 */     jpanel1.add(new JLabel("  Port: "), gridbagconstraints);
/* 107 */     gridbagconstraints.gridx += 1;
/* 108 */     this.jftfWritePort = new JFormattedTextField(numberformat);
/* 109 */     this.jftfWritePort.setHorizontalAlignment(4);
/* 110 */     this.jftfWritePort.setValue(new Integer(v2cproxysetting1.getPort()));
/* 111 */     this.jftfWritePort.setColumns(6);
/* 112 */     jpanel1.add(this.jftfWritePort, gridbagconstraints);
/* 113 */     gridbagconstraints.gridx = 0;
/* 114 */     gridbagconstraints.gridy += 1;
/* 115 */     jpanel1.add(new JLabel(" ID: "), gridbagconstraints);
/* 116 */     gridbagconstraints.gridx += 1;
/* 117 */     this.jtfWriteUser = new V2CTextField(v2cproxysetting1.getID(), 15);
/* 118 */     jpanel1.add(this.jtfWriteUser, gridbagconstraints);
/* 119 */     gridbagconstraints.gridx = 0;
/* 120 */     gridbagconstraints.gridy += 1;
/* 121 */     jpanel1.add(new JLabel(" PW: "), gridbagconstraints);
/* 122 */     gridbagconstraints.gridx += 1;
/* 123 */     this.jpfWritePass = new JPasswordField(v2cproxysetting1.getPW(), 15);
/* 124 */     jpanel1.add(this.jpfWritePass, gridbagconstraints);
/* 125 */     gridbagconstraints.gridx += 1;
				String s = System.getProperty("java.net.preferIPv6Addresses");
				String X = (s != null && s.equals("true")?"4":"6");
/* 126 */     JPanel jpanel2 = new JPanel(new GridBagLayout());
/* 127 */     jpanel2.setBorder(new TitledBorder("IPv"+X));
/* 128 */     gridbagconstraints.gridx = 0;
/* 129 */     gridbagconstraints.gridy = 0;
/* 130 */     Insets insets = gridbagconstraints.insets;
/* 131 */     gridbagconstraints.insets = new Insets(1, 2, 1, 2);
/* 132 */     JCheckBox jcheckbox = new JCheckBox("書き込み時IPv"+X+"のアドレスを優先する", V2CApp.getUserProperty().getBoolean("PreferIPv6Addresses"));
/* 133 */     this.jcbPreferIPv6Addresses = jcheckbox;
/* 134 */     jcheckbox.setFocusable(false);
/* 135 */     gridbagconstraints.fill = 2;
/* 136 */     gridbagconstraints.weightx = 1.0D;
/* 137 */     jpanel2.add(jcheckbox, gridbagconstraints);
/* 138 */     gridbagconstraints.fill = 0;
/* 139 */     gridbagconstraints.weightx = 0.0D;
/* 140 */     gridbagconstraints.insets = insets;
/* 141 */     gridbagconstraints.gridx = 0;
/* 142 */     gridbagconstraints.gridy = 0;
/* 143 */     if (V2CApp.isMacintosh()) {
/* 144 */       this.jcbUseSystemSetting = new JCheckBox("システムのProxy設定を使用する");
/* 145 */       this.jcbUseSystemSetting.setFocusable(false);
/* 146 */       this.jcbUseSystemSetting.addChangeListener(this);
/* 147 */       this.jcbUseSystemSetting.setSelected(V2CProxySetting.getUseSystemSetting());
/* 148 */       add(this.jcbUseSystemSetting, gridbagconstraints);
/* 149 */       gridbagconstraints.gridy += 1;
/* 150 */       add(new JLabel("    （しない→するの場合はV2Cの再起動が必要）"), gridbagconstraints);
/* 151 */       gridbagconstraints.gridy += 1;
/*     */     }
/* 153 */     add(jpanel, gridbagconstraints);
/* 154 */     gridbagconstraints.gridy += 1;
/* 155 */     add(jpanel1, gridbagconstraints);
/* 156 */     gridbagconstraints.gridy += 1;
/* 157 */     this.vHttpTimeoutSettingPanel = new V2CHttpTimeoutSettingPanel();
/* 158 */     gridbagconstraints.fill = 2;
/* 159 */     add(this.vHttpTimeoutSettingPanel, gridbagconstraints);
/* 160 */     gridbagconstraints.gridy += 1;
/* 161 */     add(jpanel2, gridbagconstraints);
/* 162 */     gridbagconstraints.gridy += 1;
/*     */   }
/*     */   
/*     */   boolean showPanel() {
/*     */     for (;;) {
/* 167 */       if (!V2CSwingUtil.showOKCancelDialog(this, "ネットワークの設定")) {
/* 168 */         return false;
/*     */       }
/* 170 */       if (validateAndSave()) break;
/* 171 */       Toolkit.getDefaultToolkit().beep();
/* 172 */       V2CSwingUtil.showErrorMessage("読み込み・書き込みProxyが同じ場合、\nIDとパスワードも同じ設定にしてください。");
/*     */     }
/* 174 */     return true;
/*     */   }
/*     */   
/*     */ 
/*     */   boolean validateAndSave()
/*     */   {
/* 180 */     boolean flag = false;
/* 181 */     boolean flag1 = false;
/* 182 */     int i = 0;
/* 183 */     int j = 0;
/* 184 */     String s = null;
/* 185 */     String s1 = null;
/* 186 */     String s2 = null;
/* 187 */     String s3 = null;
/* 188 */     String s4 = null;
/* 189 */     String s5 = null;
/* 190 */     flag = this.jcbUseReadProxy.isSelected();
/* 191 */     s = this.jtfReadHost.getText();
/* 192 */     s1 = V2CMiscUtil.trim(this.jtfReadUser.getText());
/* 193 */     s2 = V2CMiscUtil.trim(new String(this.jpfReadPass.getPassword()));
/* 194 */     i = V2CSwingUtil.getInt(this.jftfReadPort);
/* 195 */     flag1 = this.jcbUseWriteProxy.isSelected();
/* 196 */     s3 = this.jtfWriteHost.getText();
/* 197 */     j = V2CSwingUtil.getInt(this.jftfWritePort);
/* 198 */     s4 = V2CMiscUtil.trim(this.jtfWriteUser.getText());
/* 199 */     s5 = V2CMiscUtil.trim(new String(this.jpfWritePass.getPassword()));
/* 200 */     boolean valid = (!flag) || (!flag1) || (!s.equals(s3)) || (i != j) || ((s1.equals(s4)) && (s2.equals(s5)));
/* 201 */     if (valid) {
/* 202 */       if (this.jcbUseSystemSetting != null) {
/* 203 */         V2CProxySetting.setUseSystemSetting(this.jcbUseSystemSetting.isSelected());
/*     */       }
/* 205 */       this.psRead.setProxyUsed(flag);
/* 206 */       this.psRead.setHost(s);
/* 207 */       this.psRead.setPort(i);
/* 208 */       this.psRead.setID(s1);
/* 209 */       this.psRead.setPW(s2);
/* 210 */       this.psWrite.setProxyUsed(flag1);
/* 211 */       this.psWrite.setHost(s3);
/* 212 */       this.psWrite.setPort(j);
/* 213 */       this.psWrite.setID(s4);
/* 214 */       this.psWrite.setPW(s5);
/* 215 */       this.vHttpTimeoutSettingPanel.setTimeoutValues();
/* 216 */       V2CProperty v2cproperty = V2CApp.getUserProperty();
/* 217 */       if (this.jcbPreferIPv6Addresses.isSelected()) {
/* 218 */         v2cproperty.putBoolean("PreferIPv6Addresses", true);
/*     */       } else {
/* 220 */         v2cproperty.remove("PreferIPv6Addresses");
/*     */       }
				V2CB11ScriptUtil.syncGlobalBooleanP2S("PreferIPv6Addresses");
/* 222 */       return true;
/*     */     }
/* 224 */     return false;
/*     */   }
/*     */   
/*     */   public void stateChanged(ChangeEvent changeevent)
/*     */   {
/* 229 */     boolean flag = this.jcbUseSystemSetting.isSelected();
/* 230 */     if (flag) {
/* 231 */       this.jcbUseReadProxy.setSelected(false);
/* 232 */       this.jcbUseWriteProxy.setSelected(false);
/*     */     }
/* 234 */     this.jcbUseReadProxy.setEnabled(!flag);
/* 235 */     this.jcbUseWriteProxy.setEnabled(!flag);
/*     */   }
/*     */   
/*     */   public static void initPanel() {}
/*     */ }


/* Location:              H:\__dat\V2C\jar\V2C_R20171103_p_1.1.3.jar!\org\monazilla\v2c\V2CProxySettingPanel.class
 * Java compiler version: 7 (51.0)
 * JD-Core Version:       0.7.1
 */