package org.monazilla.v2c;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;

import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.metal.MetalScrollButton;

public class V2CMetalScrollButtonDark extends MetalScrollButton
{
	//https://flylib.com/books/en/2.715.1.208/1/

	private boolean freeStanding;

	public V2CMetalScrollButtonDark(int arg0, int arg1, boolean arg2) {
		super(arg0, arg1, arg2);
		// TODO 自動生成されたコンストラクター・スタブ
	}

	public void paint(Graphics g)
	{
		Rectangle bounds = SwingUtilities.getLocalBounds(this);

		// fill the background
		if (getModel().isPressed())
			g.setColor(MetalLookAndFeel.getControlShadow());
		else
			g.setColor(UIManager.getColor("ScrollBar.arrowbackground"));
		g.fillRect(0, 0, bounds.width, bounds.height);

		paintArrow(g, bounds.width, bounds.height);

		// paint a border manually - I tried using a real (custom) Border
		// but couldn't get it to stay set for the button, something was 
		// overwriting it...
		if (freeStanding) 
		{
			if (direction == WEST)
				paintWestBorderFreeStanding(g, bounds.width, bounds.height);				
			else if (direction == EAST)
				paintEastBorderFreeStanding(g, bounds.width, bounds.height);
			else if (direction == SOUTH)
				paintSouthBorderFreeStanding(g, bounds.width, bounds.height);
			else // asume NORTH
				paintNorthBorderFreeStanding(g, bounds.width, bounds.height);
		}
		else
		{
			if (direction == WEST)
				paintWestBorder(g, bounds.width, bounds.height);				
			else if (direction == EAST)
				paintEastBorder(g, bounds.width, bounds.height);
			else if (direction == SOUTH)
				paintSouthBorder(g, bounds.width, bounds.height);
			else // asume NORTH
				paintNorthBorder(g, bounds.width, bounds.height);
		}
	}

	private void paintArrow(Graphics g, int w, int h)
	{
		if (isEnabled())
			g.setColor(Color.BLACK);
		else
			g.setColor(MetalLookAndFeel.getControlDisabled());
		
		if (direction == SOUTH)
			{
				int x = (w / 2) + 1;
				int y = h / 2 + 2;
				for (int i = 1; i < 5; i++)
					g.drawLine(x - i, y - i, x + i - 1, y - i);
			}
		else if (direction == EAST)
			{
				int x = w / 2 + 2;
				int y = (h / 2) + 1;
				for (int i = 1; i < 5; i++)
					g.drawLine(x - i, y - i, x - i, y + i - 1);
			}
		else if (direction == WEST)
			{
				int x = w / 2 - 3;
				int y = h / 2;
				for (int i = 1; i < 5; i++)
					g.drawLine(x + i, y - i, x + i, y + i - 1);				
			}
		else // assume NORTH
			{
				int x = (w / 2) + 1;
				int y = h / 2 - 3;
				for (int i = 1; i < 5; i++)
					g.drawLine(x - i, y + i, x + i - 1, y + i);
			}
	}

	/**
	 * Paints the border for a button with a {@link #NORTH} direction that
	 * belongs to a free standing scroll bar.
	 * 
	 * @param g	the graphics device.
	 * @param w	the button width.
	 * @param h	the button height.
	 */
	private void paintNorthBorderFreeStanding(Graphics g, int w, int h) 
	{
		if (isEnabled())
		{
			g.setColor(MetalLookAndFeel.getControlDarkShadow());
			g.drawLine(0, 0, w - 2, 0);
			g.drawLine(0, 0, 0, h - 1);
			g.drawLine(2, h - 1, w - 2, h - 1);
			g.drawLine(w - 2, 2, w - 2, h - 1);

			g.setColor(MetalLookAndFeel.getControlHighlight());
			g.drawLine(1, 1, 1, h - 2);
			g.drawLine(1, 1, w - 3, 1);
			g.drawLine(w - 1, 1, w - 1, h - 1);

			g.setColor(MetalLookAndFeel.getControl());
			g.drawLine(1, h - 1, 1, h - 1);
			g.drawLine(w - 2, 1, w - 2, 1);
		}
		else
		{
			g.setColor(MetalLookAndFeel.getControlDisabled());
			g.drawLine(0, 0, w - 1, 0);
			g.drawLine(w - 1, 0, w - 1, h - 1);
			g.drawLine(0, 0, 0, h - 1);
		}
	}

	/**
	 * Paints the border for a button with a {@link #SOUTH} direction that
	 * belongs to a free standing scroll bar.
	 * 
	 * @param g	the graphics device.
	 * @param w	the button width.
	 * @param h	the button height.
	 */
	private void paintSouthBorderFreeStanding(Graphics g, int w, int h)
	{
		if (isEnabled())
		{
			g.setColor(MetalLookAndFeel.getControlDarkShadow());
			g.drawLine(0, 0, w - 2, 0);
			g.drawLine(0, 0, 0, h - 1);
			g.drawLine(2, h - 1, w - 2, h - 1);
			g.drawLine(w - 2, 2, w - 2, h - 1);

			g.setColor(MetalLookAndFeel.getControlHighlight());
			g.drawLine(1, 1, 1, h - 1);
			g.drawLine(1, 1, w - 1, 1);
			g.drawLine(w - 1, 1, w - 1, h - 1);

			g.setColor(MetalLookAndFeel.getControl());
			g.drawLine(1, h - 1, 1, h - 1);
			g.drawLine(w - 1, 1, w - 1, 1);
		}
		else
		{
			g.setColor(MetalLookAndFeel.getControlDisabled());
			g.drawLine(0, h - 1, w - 1, h - 1);
			g.drawLine(w - 1, 0, w - 1, h - 1);
			g.drawLine(0, 0, 0, h - 1);
		}
	}

	/**
	 * Paints the border for a button with an {@link #EAST} direction that
	 * belongs to a free standing scroll bar.
	 * 
	 * @param g	the graphics device.
	 * @param w	the button width.
	 * @param h	the button height.
	 */
	private void paintEastBorderFreeStanding(Graphics g, int w, int h)
	{
		if (isEnabled())
		{
			g.setColor(MetalLookAndFeel.getControlDarkShadow());
			g.drawLine(0, 0, w - 2, 0);
			g.drawLine(w - 2, 0, w - 2, h - 2);
			g.drawLine(0, h - 2, w - 2, h - 2);

			g.setColor(MetalLookAndFeel.getControlHighlight());
			g.drawLine(0, 1, w - 1, 1);
			g.drawLine(w - 1, 1, w - 1, h - 1);
			g.drawLine(0, h - 1, w - 1, h - 1);

			g.setColor(MetalLookAndFeel.getControl());
			g.drawLine(w - 2, 1, w - 2, 1);
		}
		else
		{
			g.setColor(MetalLookAndFeel.getControlDisabled());
			g.drawLine(0, 0, w - 1, 0);
			g.drawLine(w - 1, 0, w - 1, h - 1);
			g.drawLine(0, h - 1, w - 1, h - 1);
		}
	}

	/**
	 * Paints the border for a button with a {@link #WEST} direction that
	 * belongs to a free standing scroll bar.
	 * 
	 * @param g  the graphics device.
	 * @param w  the button width.
	 * @param h  the button height.
	 */
	private void paintWestBorderFreeStanding(Graphics g, int w, int h)
	{
		if (isEnabled())
		{
			g.setColor(MetalLookAndFeel.getControlDarkShadow());
			g.drawLine(0, 0, w - 1, 0);
			g.drawLine(0, 0, 0, h - 2);
			g.drawLine(0, h - 2, w - 1, h - 2);

			g.setColor(MetalLookAndFeel.getControlHighlight());
			g.drawLine(1, 1, w - 1, 1);
			g.drawLine(1, 1, 1, h - 1);
			g.drawLine(1, h - 1, w - 1, h - 1);

			g.setColor(MetalLookAndFeel.getControl());
			g.drawLine(1, h - 2, 1, h - 2);
		}
		else
		{
			g.setColor(MetalLookAndFeel.getControlDisabled());
			g.drawLine(0, 0, w - 1, 0);
			g.drawLine(0, 0, 0, h - 1);
			g.drawLine(0, h - 1, w - 1, h - 1);
		}
	}

	/**
	 * Paints the border for a button with a {@link #NORTH} direction that
	 * belongs to a scroll bar that is not free standing.
	 * 
	 * @param g	the graphics device.
	 * @param w	the button width.
	 * @param h	the button height.
	 */
	private void paintNorthBorder(Graphics g, int w, int h) 
	{
		if (isEnabled())
		{
			g.setColor(MetalLookAndFeel.getControlDarkShadow());
			g.drawLine(0, 0, 0, h - 1);

			g.setColor(MetalLookAndFeel.getControlHighlight());
			g.drawLine(1, 0, 1, h - 1);
			g.drawLine(1, 0, w - 1, 0);
		}
		else
		{
			g.setColor(MetalLookAndFeel.getControlDisabled());
			g.drawLine(0, 0, 0, h - 1);
		}
	}

	/**
	 * Paints the border for a button with a {@link #SOUTH} direction that
	 * belongs to a scroll bar that is not free standing.
	 * 
	 * @param g	the graphics device.
	 * @param w	the button width.
	 * @param h	the button height.
	 */
	private void paintSouthBorder(Graphics g, int w, int h)
	{
		if (isEnabled())
		{
			g.setColor(MetalLookAndFeel.getControlDarkShadow());
			g.drawLine(0, 0, 0, h - 1);
			g.drawLine(0, h - 1, w - 1, h - 1);

			g.setColor(MetalLookAndFeel.getControlHighlight());
			g.drawLine(1, 0, 1, h - 1);
			g.drawLine(1, 0, w - 1, 0);

			g.setColor(MetalLookAndFeel.getControl());
			g.drawLine(1, h - 1, 1, h - 1);
		}
		else
		{
			g.setColor(MetalLookAndFeel.getControlDisabled());
			g.drawLine(0, 0, 0, h - 1);
		}
	}

	/**
	 * Paints the border for a button with an {@link #EAST} direction that
	 * belongs to a scroll bar that is not free standing.
	 * 
	 * @param g	the graphics device.
	 * @param w	the button width.
	 * @param h	the button height.
	 */
	private void paintEastBorder(Graphics g, int w, int h)
	{
		if (isEnabled())
		{
			g.setColor(MetalLookAndFeel.getControlDarkShadow());
			g.drawLine(0, 0, w - 1, 0);
			g.drawLine(w - 1, 2, w - 1, h - 1);
			g.setColor(MetalLookAndFeel.getControlHighlight());
			g.drawLine(0, 1, w - 2, 1);
			g.drawLine(0, 1, 0, h - 1);
		}
		else
		{
			g.setColor(MetalLookAndFeel.getControlDisabled());
			g.drawLine(0, 0, w - 1, 0);
		}
	}

	/**
	 * Paints the border for a button with a {@link #WEST} direction that
	 * belongs to a scroll bar that is not free standing.
	 * 
	 * @param g	the graphics device.
	 * @param w	the button width.
	 * @param h	the button height.
	 */
	private void paintWestBorder(Graphics g, int w, int h)
	{
		Rectangle bounds = SwingUtilities.getLocalBounds(this);
		if (isEnabled())
		{
			g.setColor(MetalLookAndFeel.getControlDarkShadow());
			g.drawLine(0, 0, bounds.width - 1, 0);
			g.setColor(MetalLookAndFeel.getControlHighlight());
			g.drawLine(0, 1, bounds.width - 1, 1);
			g.drawLine(0, 1, 0, bounds.height - 1);
		}
		else
		{
			g.setColor(MetalLookAndFeel.getControlDisabled());
			g.drawLine(0, 0, bounds.width - 1, 0);
		}
	}
}
