package org.monazilla.v2c;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.LayoutManager2;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;

public class V2CMac5MiniSearch extends V2CAbstractMiniSearch implements LayoutManager, LayoutManager2, MouseListener
{

	public V2CMac5MiniSearch(int i)
	{
		super(i, (GridBagLayout) null);
		JTextField jtextfield = jtfSearchWords;
		if(V2CDarkMode.using && V2CDarkMode.MacNative){
			jtextfield.setForeground(UIManager.getColor("TextField.minisearchforeground"));
		}
		jtextfield.putClientProperty("JTextField.variant", "search");
		jtextfield.putClientProperty("JTextField.Search.CancelAction", new ActionListener() {

			public void actionPerformed(ActionEvent actionevent)
			{
				if (!bInISearch && !bRealTime) {
					String s = jtfSearchWords.getText();
					if (s.length() == 0)
						resetDisplay();
				}
			}
		});
		nWidth = V2CMain.getUserProperty().getInt(sWidthKey, 110);
		JPanel jpanel = new JPanel() {

			public void paintComponent(Graphics g)
			{
				Graphics2D graphics2d = (Graphics2D) g;
				int j = getWidth();
				int k = getHeight();
				if (cTFBG != null) {
					java.awt.RenderingHints.Key key = RenderingHints.KEY_ANTIALIASING;
					Object obj = graphics2d.getRenderingHint(key);
					graphics2d.setRenderingHint(key, RenderingHints.VALUE_ANTIALIAS_ON);
					g.setColor(cTFBG);
					g.fillOval(0, 0, j - 1, k - 1);
					graphics2d.setRenderingHint(key, obj);
				}
				g.drawImage(V2CMac5MiniSearch.imgFindDownArrow, j - 6, k / 2 - 2, null);
			}
		};
		jpFPDummy = jpanel;
		jpanel.setOpaque(false);
		jpanel.addMouseListener(this);
		add(jpanel);
		add(jtextfield);
		setLayout(this);
		if (jtextfield instanceof V2CNoBeepTextField)
			((V2CNoBeepTextField) jtextfield).setIgnoreUIUpdate();
	}

	void setISearchColor(int i)
	{
		switch (i) {
			case 1: // '\001'
				cTFBG = new Color(0x2f00ff00, true);
				break;

			case 2: // '\002'
				cTFBG = new Color(0x2f0000ff, true);
				break;

			case 3: // '\003'
				cTFBG = new Color(0x5fffff00, true);
				break;

			default:
				cTFBG = null;
				break;
		}
		jpFPDummy.repaint();
	}

	void setNormalColor()
	{
		cTFBG = bRegExpError ? new Color(0x7fff0000) : null;
		jpFPDummy.repaint();
	}

	int getMinimumWidth()
	{
		return 40;
	}

	public Dimension getMaximumSize()
	{
		return getPreferredSize();
	}

	public Dimension getPreferredSize()
	{
		Dimension dimension = super.getPreferredSize();
		return new Dimension(nWidth, dimension.height);
	}

	public Dimension getMinimumSize()
	{
		return getPreferredSize();
	}

	public void addLayoutComponent(String s, Component component)
	{
	}

	public void removeLayoutComponent(Component component)
	{
	}

	public Dimension preferredLayoutSize(Container container)
	{
		return jtfSearchWords.getPreferredSize();
	}

	public Dimension minimumLayoutSize(Container container)
	{
		return jtfSearchWords.getMinimumSize();
	}

	public void layoutContainer(Container container)
	{
		synchronized (container.getTreeLock()) {
			int i = getWidth();
			int j = getHeight();
			jtfSearchWords.setBounds(0, 0, i, j);
			jpFPDummy.setBounds(9, 6, 16, j - 11);
		}
	}

	public void addLayoutComponent(Component component, Object obj)
	{
	}

	public Dimension maximumLayoutSize(Container container)
	{
		return jtfSearchWords.getMaximumSize();
	}

	public float getLayoutAlignmentX(Container container)
	{
		return jtfSearchWords.getAlignmentX();
	}

	public float getLayoutAlignmentY(Container container)
	{
		return jtfSearchWords.getAlignmentY();
	}

	public void invalidateLayout(Container container)
	{
	}

	public void mouseEntered(MouseEvent mouseevent)
	{
	}

	public void mouseExited(MouseEvent mouseevent)
	{
	}

	public void mousePressed(MouseEvent mouseevent)
	{
		if (V2CSwingUtil.isSimpleClick(mouseevent))
			mlPopupListener.showPopup(mouseevent);
	}

	public void mouseReleased(MouseEvent mouseevent)
	{
	}

	public void mouseClicked(MouseEvent mouseevent)
	{
	}

	private static final boolean bUseCover = true;
	static final Image imgFindDownArrow;
	JPanel jpFPDummy;
	Color cTFBG;

	static {
		ImageIcon imageicon = V2CSwingUtil.getSystemImage("macfindda");
		imgFindDownArrow = imageicon.getImage();
	}
}
