package org.monazilla.v2c;

import java.awt.Color;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Transparency;
import java.awt.color.CMMException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Iterator;

import javax.imageio.IIOException;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.stream.ImageInputStream;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.Timer;

import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class V2CImageSet implements ActionListener, Cloneable
{
	private static class ImageSizeException extends IOException
	{

		final int nWidth;
		final int nHeight;

		ImageSizeException(String s, int i, int j)
		{
			super(s);
			nWidth = i;
			nHeight = j;
		}
	}

	boolean needPaintBG()
	{
		return bDrawBG;
	}

	void checkGamma(File file)
	{
		if (nFormat != 2)
			return;
		int flen = (int) file.length();
		DataInputStream dis = null;
		int j = 0;
		boolean flag = false;
		try {
			dis = new DataInputStream(new FileInputStream(file));
			if (dis.skipBytes(8) != 8)
				return;

			int k = 8;
			do {
				int l = dis.readInt();
				if (l <= 0)
					break;
				int i1 = dis.readInt();
				int j1 = l + 4;
				k += j1 + 8;
				if (k + 4 > flen)
					break;
				if (i1 == 0x67414d41) {
					j = dis.readInt();
					j1 -= 4;
				}
				if (i1 == 0x504c5445) {
					boolean flag1 = true;
					break;
				}
				if (i1 == 0x49444154)
					break;
				while (j1 > 0)
					j1 -= dis.skipBytes(j1);
			} while (true);
		}
		catch (IOException ioexception2) {
		}
		finally {
			if (dis != null) {
				try {
					dis.close();
				}
				catch (IOException e3) {
				}
			}
		}

		if (j == 0 || j >= 45453 && j <= 45456)
			return;
		double d = 100000D / (double) j;
		BufferedImage bi = null;
		boolean flag2 = false;
		if (silImages != null) {
			final Image img = silImages[0].getImage();
			flag2 = !(img instanceof BufferedImage);
			if (flag2) {
				final BufferedImage bin = new BufferedImage(nWidth, nHeight, 2);
				if (EventQueue.isDispatchThread()) {
					Graphics2D graphics2d = bin.createGraphics();
					graphics2d.drawImage(img, 0, 0, null);
					graphics2d.dispose();
				}
				else {
					try {
						EventQueue.invokeAndWait(new Runnable() {

							public void run()
							{
								Graphics2D graphics2d1 = bin.createGraphics();
								graphics2d1.drawImage(img, 0, 0, null);
								graphics2d1.dispose();
							}
						});
					}
					catch (Exception exception1) {
						return;
					}
				}
				bi = bin;
			}
			else {
				bi = (BufferedImage) img;
			}
		}
		if (bi == null)
			return;
		int ai[] = new int[256];
		for (int k1 = 0; k1 < 256; k1++)
			ai[k1] = (int) (256D * Math.pow((double) k1 / 256D, d / 2.2000000000000002D));

		int l1 = nWidth;
		int i2 = nHeight;
		for (int j2 = 0; j2 < i2; j2++) {
			for (int k2 = 0; k2 < l1; k2++) {
				int l2 = bi.getRGB(k2, j2);
				bi.setRGB(k2, j2, l2 & 0xff000000 | ai[l2 >>> 16 & 0xff] << 16 | ai[l2 >>> 8 & 0xff] << 8 | ai[l2 & 0xff]);
			}

		}

		if (flag2)
			silImages[0].setImage(bi);
		return;
	}

	static V2CImageSet createImageSet(Object obj, boolean flag)
	{
		return createImageSet0(obj, 0, 0, flag);
	}

	private static V2CImageSet createImageSet0(Object obj, int i, int j, boolean flag)
    {

        String s = null;
        boolean flag1 = false;
        ImageInputStream iis = null;
        ImageReader ir = null;
        V2CImageSet imgset = null;
        int k = 0;
        int l = 0;
        try
        {
	        iis = ImageIO.createImageInputStream(obj);
	        if(iis != null)
	        {

	            Iterator iterator = ImageIO.getImageReaders(iis);
	            if(iterator.hasNext())
	            {
	                ir = (ImageReader)iterator.next();
	                ir.setInput(iis);
	                imgset = new V2CImageSet(ir, obj, flag);
	                if(obj instanceof File)
	                    imgset.nFileSize = (int)((File)obj).length();
	            } else
	            {
	                s = "No ImageReader Found.";
	            }
	        } else
	        {
	            s = "error in ImageIO.createImageInputStream()";
	        }
        }
        catch (ImageSizeException ise)
        {
        	flag1 = true;
        	k = ise.nWidth;
        	l = ise.nHeight;
        	s = ise.getMessage();
        	V2CMain.setMessage(s);
        }
        catch (IOException ioe)
        {
        	s = ioe.getMessage();
    		if(!V2CHttpUtil.CreateMovieThumb){
            	V2CMain.setMessage(s);
        	}else
        	if(!s.equals(V2CWebpAnimation.VP8_STATUS_UNSUPPORTED_FEATURE)){
            	V2CMain.setMessage(s);
        	}else{
                if(obj instanceof File){
                	V2CWebpConvert2Gif v2cwebpconvert2gif = new V2CWebpConvert2Gif();
                	obj = (Object) v2cwebpconvert2gif.exec((File) obj);
                	v2cwebpconvert2gif = null;

                	try
                	{
            	        iis = ImageIO.createImageInputStream(obj);
            	        if(iis != null)
            	        {

            	            Iterator iterator = ImageIO.getImageReaders(iis);
            	            if(iterator.hasNext())
            	            {
            	                ir = (ImageReader)iterator.next();
            	                ir.setInput(iis);
            	                imgset = new V2CImageSet(ir, obj, flag);
            	                if(obj instanceof File)
            	                    imgset.nFileSize = (int)((File)obj).length();
            	            } else
            	            {
            	                s = "No ImageReader Found.";
            	            }
            	        } else
            	        {
            	            s = "error in ImageIO.createImageInputStream()";
            	        }
                	}catch (Exception e){
                    	s = e.getMessage();
                    	V2CMain.setMessage(s);
                	}
                }
        	}
         }
        catch (OutOfMemoryError ome)
        {
        	s = "OutOfMemoryError: " + ome.getMessage();
        	V2CMain.setMessage(s);
        }
        catch (Exception e)
        {
        	s = e.getMessage();
        	V2CMain.setMessage(s);
        }
        finally
        {
            if(ir != null)
                ir.dispose();
            if(iis != null) {
                try
                {
                    iis.close();
                }
                catch(IOException ioexception1) { }
            }
            if(imgset != null)
            {
                ImageReader imagereader5 = imgset.vJFIFImageReader;
                if(imagereader5 != null)
                {
                    imgset.vJFIFImageReader = null;
                    imagereader5.dispose();
                    Object obj6 = imagereader5.getInput();
                    if(obj6 instanceof ImageInputStream)
                        try
                        {
                            ((ImageInputStream)obj6).close();
                        }
                        catch(IOException ioexception6) { }
                }
            }
        }
        if(imgset != null && (obj instanceof File))
            imgset.checkGamma((File)obj);
        V2CMemoryGauge.update();
        return imgset == null ? new V2CImageSet(s, flag1, k, l) : imgset;
    }

	static V2CImageSet createImageSet(BufferedImage bufferedimage)
	{
		String s = null;
		V2CImageSet v2cimageset = null;
		try {
			v2cimageset = new V2CImageSet(bufferedimage);
		}
		catch (IOException ioexception) {
			s = ioexception.getMessage();
			V2CMain.setMessage(s);
		}
		return v2cimageset == null ? new V2CImageSet(s, false, 0, 0) : v2cimageset;
	}

	static V2CImageSet createImageSet(V2CImageSet v2cimageset, double d, File file)
	{
//		V2CImageSet v2cimageset1 = null;
		if (d >= 1.0D){
			try {
//				v2cimageset1 = (V2CImageSet) v2cimageset.clone();
				return (V2CImageSet) v2cimageset.clone();
			}
			catch (CloneNotSupportedException clonenotsupportedexception) {
			}
		}else{
//			v2cimageset1 = new V2CImageSet(v2cimageset, d, file);
			return new V2CImageSet(v2cimageset, d, file);
		}
//		return v2cimageset1;
		return null;
	}

	private V2CImageSet(String s, boolean flag, int i, int j)
	{
		cBackground = cDefaultBackground;
		nLastDrawIndex = -1;
		iClearIndex = -1;
		sErrorMessage = s == null ? "unknown error" : s;
		bSizeLimitExceeded = flag;
		nWidth = i;
		nHeight = j;
	}

	private V2CImageSet(BufferedImage bufferedimage) throws IOException
	{
		cBackground = cDefaultBackground;
		nLastDrawIndex = -1;
		iClearIndex = -1;
		if (bufferedimage == null) {
			throw new IOException("bi==null");
		}
		else {
			V2CSingleImage v2csingleimage = new V2CSingleImage(bufferedimage, 0);
			silImages = new V2CSingleImage[1];
			silImages[0] = v2csingleimage;
			nWidth = v2csingleimage.getWidth();
			nHeight = v2csingleimage.getHeight();
			bOK = true;
			v2csingleimage = null;
			return;
		}
	}

	private V2CImageSet(ImageReader ir, Object obj, boolean use_mozaic) throws IOException
	{
		cBackground = cDefaultBackground;
		nLastDrawIndex = -1;
		iClearIndex = -1;
		V2CImageInfo v2cimageinfo = null;
		boolean obj_is_file = obj instanceof File;
		if (obj_is_file) {
			v2cimageinfo = V2CImageInfo.getImageInfo((File) obj, false, true);
		}
		String fmn = ir.getFormatName();
		sFormatName = (fmn == null) ? "" : fmn;
		int nformat_type = FORMAT_UNKNOWN;
		if (fmn.equalsIgnoreCase("JPEG"))		nformat_type = FORMAT_JPEG;
		else if (fmn.equalsIgnoreCase("PNG"))	nformat_type = FORMAT_PNG;
		else if (fmn.equalsIgnoreCase("gif"))	nformat_type = FORMAT_GIF;

		nFormat = nformat_type;
		boolean bjpeg = nformat_type == FORMAT_JPEG;
		boolean bgif = nformat_type == FORMAT_GIF;
		GifDecoder gdec = null;
		int image_cnt = (bjpeg) ? 1 : ir.getNumImages(true);
		if (bgif) {
			gdec = new GifDecoder();
			if (obj_is_file) {
				BufferedInputStream bis = null;
				try
				{
					bis = new BufferedInputStream(new FileInputStream((File)obj));
					if (0 == gdec.read(bis)) {
						image_cnt = gdec.getFrameCount();
					} else {
						gdec = null;
					}
				}
				finally
				{
					if (bis != null) {
						bis.close();
						bis = null;
					}
				}
			} else {
				gdec = null;
			}
		}
		if (image_cnt <= 0)
			throw new IOException("No. of Image <= 0.");

		int mlisize = V2CLink.nMaxLoadImageSize;
		if (mlisize <= 0)
			mlisize = 32768;
		int mliarea = V2CLink.nMaxLoadImageArea;
		int width = 0;
		int height = 0;
		if (v2cimageinfo != null) {
			int w2 = v2cimageinfo.nWidth;
			int h2 = v2cimageinfo.nHeight;
			if (w2 > 0 && h2 > 0) {
				width = w2;
				height = h2;
			}
		}
		if (width <= 0 || height <= 0) {
			for (int i = 0; i < image_cnt; i++) {
				int w2 = ir.getWidth(i);
				int h2 = ir.getHeight(i);
				if (w2 > width)
					width = w2;
				if (h2 > height)
					height = h2;
			}
		}
		if (width > mlisize)
			throw new ImageSizeException("幅が上限を越えています（" + width + "＞" + mlisize + "）", width, height);
		if (height > mlisize)
			throw new ImageSizeException("高さが上限を越えています（" + height + "＞" + mlisize + "）", width, height);
		if (mliarea > 0 && width * height > mliarea)
			throw new ImageSizeException("幅\327高さが上限を越えています（" + width * height + "＞" + mliarea + "）", width, height);
		int moza_block_size = (use_mozaic) ? calcMaxBlockSize(width, height) : 0;
		nBlockSize = moza_block_size;
		boolean b_ac = (image_cnt == 1) && bgif;
		bAlwaysClear = b_ac;
		boolean no_anim = b_ac || bjpeg;
		if (no_anim) {
			if (bjpeg && v2cimageinfo != null
				&& v2cimageinfo.bICC
				&& !v2cimageinfo.bJFIFBeforeICC
				&& !v2cimageinfo.bJFIF
				&& (obj_is_file)
			) {
				ImageReader ir2 = V2CJFIFInputStream.createImageReader((File) obj);
				if (ir2 != null) {
					ir = ir2;
					vJFIFImageReader = ir2;
					v2cimageinfo.bJFIFBeforeICC = true;
				}
			}
			boolean flag5 = (obj_is_file)
					&& (bgif || (bjpeg && v2cimageinfo != null && v2cimageinfo.bICC && v2cimageinfo.bJFIFBeforeICC));
			Object obj1 = null;
			V2CSingleImage v2csingleimage = null;
			try {
				//v2csingleimage = new V2CSingleImage(ir, obj, moza_block_size, flag5, bjpeg);
				v2csingleimage = new V2CSingleImage(ir, obj, moza_block_size, flag5, v2cimageinfo.nColorModel);
			}
			catch (IllegalArgumentException illegalargumentexception) {
				obj1 = illegalargumentexception;
			}
			catch (IIOException iioexception) {
				obj1 = iioexception;
			}
			catch (CMMException cmmexception) {
				obj1 = cmmexception;
			}
			catch (IOException ioexception) {
				if (!flag5 && V2CMiscUtil.isEqual(ioexception.getMessage(), "image loading error !"))
					try {
						v2csingleimage = new V2CSingleImage(ir, obj, moza_block_size, true, v2cimageinfo.nColorModel);
					}
					catch (IllegalArgumentException illegalargumentexception2) {
						throw new IllegalArgumentException(illegalargumentexception2.getMessage());
					}
			}
			if (obj1 != null && flag5)
				try {
					v2csingleimage = new V2CSingleImage(null, obj, moza_block_size, false, v2cimageinfo.nColorModel);
				}
				catch (IllegalArgumentException illegalargumentexception1) {
					throw new IllegalArgumentException(((Exception) (obj1)).getMessage());
				}
			if (v2csingleimage != null) {
				silImages = new V2CSingleImage[1];
				silImages[0] = v2csingleimage;
			}
			else {
				try {
					Thread.sleep(100L);
				}
				catch (InterruptedException interruptedexception) {
					throw new IOException("Interrupted during sleep");
				}
			}
			v2csingleimage = null;
		}
		if (!no_anim || silImages == null) {
			ArrayList al = new ArrayList();
			for (int i = 0; i < image_cnt; i++) {
				V2CSingleImage si = null;
				try {
					if (gdec != null) {
						si = new V2CSingleImage(gdec.getFrame(i), moza_block_size);
					} else {
						si = new V2CSingleImage(ir, i, moza_block_size);
					}
				}
				catch (OutOfMemoryError outofmemoryerror) {
					if (nformat_type == FORMAT_PNG && (obj_is_file))
						si = new V2CSingleImage(null, obj, moza_block_size, false, -1);
					else
						throw outofmemoryerror;
				}
				catch (IndexOutOfBoundsException indexoutofboundsexception) {
					break;
				}
				// V2CMOD-twZ by MCZ, Date:2017/12/15, PNG medadata read error対応
				catch (IOException ioexception) {
					if (nformat_type == FORMAT_PNG && (obj_is_file))
						si = new V2CSingleImage(null, obj, moza_block_size, false, -1);
					else
						throw ioexception;
				}
				// ---- END of V2CMOD-twZ ----
				al.add(si);
				si = null;
			}
			image_cnt = al.size();
			if (image_cnt <= 0)
				throw new IOException("No. of Image <= 0.");
			silImages = (V2CSingleImage[]) al.toArray(new V2CSingleImage[image_cnt]);
			al = null;
		}
		V2CSingleImage asi[] = silImages;
		if (image_cnt > 1) {
			bAnimate = true;
			extractStreamInfo(ir);
			Rectangle rectangle = new Rectangle();
			for (int i = 0; i < image_cnt; i++) {
				V2CSingleImage v2csingleimage2 = asi[i];
				v2csingleimage2.extractInfo(ir, i);
				v2csingleimage2.computeUnion(rectangle);
				v2csingleimage2 = null;
			}

			if (nWidth <= 0 || nHeight <= 0) {
				nWidth = rectangle.width;
				nHeight = rectangle.height;
			}
			if (rectangle.x != 0 || rectangle.y != 0 || rectangle.width != nWidth || rectangle.height != nHeight)
				bNeedsBuffer = true;
			rectangle = null;
		}
		else {
			final V2CSingleImage vsi0 = silImages[0];
			if (nWidth <= 0 || nHeight <= 0) {
				nWidth = vsi0.getWidth();
				nHeight = vsi0.getHeight();
			}
			if (nFormat == FORMAT_PNG) {
				Image image = vsi0.getImage();
				if (image instanceof BufferedImage) {
					final BufferedImage bi = (BufferedImage) image;
					ColorModel colormodel = bi.getColorModel();
					boolean trans = colormodel.getTransparency() != Transparency.OPAQUE;
					colormodel = null;

					bDrawBG = trans;
					if (!trans && V2CApp.isWinType()) {
						String s1 = System.getProperty("sun.java2d.noddraw");
						String s2 = System.getProperty("sun.java2d.d3d");
						if (s1 != null && s1.equals("true") || s2 != null && s2.equals("true"))
							trans = true;
					}
					if (trans)
						EventQueue.invokeLater(new Runnable() {

							public void run()
							{
								BufferedImage bufferedimage = V2CSwingUtil.convertToCompatibeImage(bi);
								if (bufferedimage != null)
									vsi0.setImage(bufferedimage);
								bufferedimage = null;
							}
						});
				}
				image = null;
			}
		}
		bOK = true;
		v2cimageinfo = null;
		gdec = null;
	}

	public V2CImageSet(V2CImageSet v2cimageset, final double ds, File file)
	{
		cBackground = cDefaultBackground;
		nLastDrawIndex = -1;
		iClearIndex = -1;
		if (!v2cimageset.bOK)
			return;
		fOriginalFile = file;
		bThumbnailCreating = true;
		nWidth = (int) Math.round(ds * (double) v2cimageset.nWidth);
		nHeight = (int) Math.round(ds * (double) v2cimageset.nHeight);
		cBackground = v2cimageset.cBackground;
		bNeedsBuffer = v2cimageset.bNeedsBuffer;
		bAlwaysClear = v2cimageset.bAlwaysClear;
		sFormatName = v2cimageset.sFormatName;
		nFormat = v2cimageset.nFormat;
		final V2CSingleImage sil0[] = v2cimageset.silImages;
		final V2CSingleImage sil[] = new V2CSingleImage[sil0.length];
		silImages = sil;
		final boolean bq = V2CAbstractImagePanel.bHRQTh;
		final AffineTransformOp atop = !bq || nFormat == 3 ? new AffineTransformOp(new AffineTransform(ds, 0.0D, 0.0D, ds, 0.0D,
				0.0D), 1) : null;
		if (bq || EventQueue.isDispatchThread()) {
			for (int i = 0; i < sil.length; i++)
				sil[i] = new V2CSingleImage(sil0[i], ds, atop, bq, sFormatName);

		}
		else {
			try {
				EventQueue.invokeAndWait(new Runnable() {

					public void run()
					{
						for (int j = 0; j < sil.length; j++)
							sil[j] = new V2CSingleImage(sil0[j], ds, atop, bq, sFormatName);

					}
				});
			}
			catch (Exception exception) {
				exception.printStackTrace();
			}
		}
		nOriginalWidth = v2cimageset.nWidth;
		nOriginalHeight = v2cimageset.nHeight;
		bAnimate = sil.length > 1;
		bThumbnailCreating = false;
		bOK = true;
	}

	private void createBuffer()
	{
		bBufferChecked = true;
		if (silImages.length == 1)
			return;
		if (!bNeedsBuffer) {
			boolean flag = false;
			int i = 0;
			do {
				if (i >= silImages.length)
					break;
				V2CSingleImage v2csingleimage = silImages[i];
				if (v2csingleimage == null) {
					bBufferChecked = false;
					return;
				}
				if (v2csingleimage.needsBuffer(nWidth, nHeight)) {
					flag = true;
					break;
				}
				i++;
				v2csingleimage = null;
			} while (true);
			if (!flag)
				return;
		}
		iBuffer = V2CMain.v2cMain.createImage(nWidth, nHeight);
		Graphics g = iBuffer.getGraphics();
		clearRect(g, 0, 0, 0.0D);
		g.dispose();
	}

	void extractStreamInfo(ImageReader imagereader)
	{
		IIOMetadata iiometadata = null;
		try {
			iiometadata = imagereader.getStreamMetadata();
		}
		catch (IOException ioexception) {
			System.out.println(ioexception.getMessage());
		}
		if (iiometadata == null)
			return;
		String s = iiometadata.getNativeMetadataFormatName();
		if (s == null || s.length() == 0)
			return;
		Node node = iiometadata.getAsTree(s);
		if (s.indexOf("_gif_") > 0)
			extractGIFInfo(node);
		iiometadata = null;
	}

	int getWidth()
	{
		return nWidth;
	}

	int getHeight()
	{
		return nHeight;
	}

	int getOriginalWidth()
	{
		return nOriginalWidth;
	}

	int getOriginalHeight()
	{
		return nOriginalHeight;
	}

	boolean isOK()
	{
		return bOK;
	}

	boolean isSizeLimitExceeded()
	{
		return bSizeLimitExceeded;
	}

	String getErrorMessage()
	{
		return sErrorMessage;
	}

	int getImageCount()
	{
		return silImages == null ? 0 : silImages.length;
	}

	Icon createIcon()
	{
		if (silImages != null) {
			V2CSingleImage v2csingleimage = silImages[0];
			if (v2csingleimage != null) {
				Image image = v2csingleimage.getImage();
				v2csingleimage = null;
				if (image != null)
					return new ImageIcon(image);
			}
		}
		return null;
	}

	int getDisplayIndex()
	{
		return nDrawIndex;
	}

	void setOriginalFile(File file)
	{
		fOriginalFile = file;
	}

	void setImageProperty(V2CProperty v2cproperty)
	{
		if (v2cproperty == null || v2cproperty.getInt("Height") > 0)
			return;
		try {
			v2cproperty.putInt("Width", nWidth);
			v2cproperty.putInt("Height", nHeight);
			int i = getImageCount();
			if (i > 0) {
				v2cproperty.putInt("NumImages", i);
				if (i > 1) {
					int j = 0;
					for (int k = 0; k < i; k++)
						j += silImages[k].getDelayTime();

					v2cproperty.putInt("TotalTime", j);
				}
			}
			v2cproperty.doSaveState();
		}
		catch (Exception exception) {
		}
	}

	String getCaption(boolean flag)
	{
		if (sCaption == null) {
			File file = fOriginalFile;
			V2CImageInfo v2cimageinfo = V2CImageInfo.getImageInfo(file, true, true);
			StringBuffer stringbuffer = new StringBuffer();
			int i = getImageCount();
			boolean flag1 = i > 1;
			int j = v2cimageinfo.nWidth <= 0 ? nWidth : v2cimageinfo.nWidth;
			int k = v2cimageinfo.nHeight <= 0 ? nHeight : v2cimageinfo.nHeight;
			String s = v2cimageinfo.sFormatName;
			if (s == null)
				s = sFormatName;
			stringbuffer.append(s == null ? "unknown" : s);
			stringbuffer.append(" (");
			stringbuffer.append(j);
			stringbuffer.append('\327');
			stringbuffer.append(k);
			stringbuffer.append(')');
			if (flag1) {
				stringbuffer.append(' ');
				stringbuffer.append(i);
				stringbuffer.append("枚 合計 ");
				int l = 0;
				for (int j1 = 0; j1 < i; j1++)
					l += silImages[j1].getDelayTime();

				stringbuffer.append((double) l / 1000D);
				stringbuffer.append("秒");
			}
			int i1 = file == null ? nFileSize : (int) file.length();
			if (i1 > 0) {
				stringbuffer.append(' ');
				DecimalFormat decimalformat = new DecimalFormat(",##0");
				boolean flag2 = i1 >= 0x10000;
				if (flag2)
					i1 >>= 10;
				stringbuffer.append(decimalformat.format(i1));
				stringbuffer.append(flag2 ? "kB" : "bytes");
			}
			sCaption = stringbuffer.toString();
			if (v2cimageinfo.bExif && v2cimageinfo.sInfoString != null)
				sCaptionEx = '\n' + v2cimageinfo.sInfoString;
			else
				sCaptionEx = sCaption;
			v2cimageinfo = null;
			stringbuffer = null;
		}
		return flag ? sCaptionEx : sCaption;
	}

	void setNullCaption()
	{
		sCaption = "";
	}

	boolean needsUpdate()
	{
		return silImages.length > 1;
	}

	void clear()
	{
		if (!bOK || bThumbnailCreating)
			return;
		for (int i = 0; i < silImages.length; i++) {
			V2CSingleImage v2csingleimage = silImages[i];
			if (v2csingleimage != null) {
				v2csingleimage.clear();
				silImages[i] = null;
			}
			v2csingleimage = null;
		}

		silImages = null;
		if (iBuffer != null) {
			iBuffer.flush();
			iBuffer = null;
		}
		if (tTimer != null) {
			tTimer.stop();
			tTimer = null;
		}
	}

	private void setBlockSize(int i)
	{
		if (i != nBlockSize) {
			nBlockSize = i;
			for (int j = 0; j < silImages.length; j++) {
				V2CSingleImage v2csingleimage = silImages[j];
				if (v2csingleimage != null)
					v2csingleimage.setBlockSize(i);
				v2csingleimage = null;
			}

		}
	}

	private int calcMaxBlockSize()
	{
		return calcMaxBlockSize(nWidth, nHeight);
	}

	private static int calcMaxBlockSize(int i, int j)
	{
		return Math.max(Math.max(i, j) / 50, 16);
	}

	boolean isMosaic()
	{
		return nBlockSize > 0;
	}

	void setMosaic(boolean flag)
	{
		setBlockSize(flag ? calcMaxBlockSize() : 0);
	}

	boolean changeBlockSize(boolean flag)
	{
		int i = nBlockSize;
		int j = i;
		if (flag) {
			if (j == 0) {
				j = calcMaxBlockSize();
			}
			else {
				j = Math.min(j * 2, calcMaxBlockSize());
				if (j < 4)
					j = 4;
			}
		}
		else {
			j /= 2;
			if (j < 4)
				j = 0;
		}
		setBlockSize(j);
		return (i > 0) ^ (j > 0);
	}

	void startAnimation()
	{
		if (silImages.length <= 1) {
			return;
		}
		else {
			bAnimate = true;
			rescheduleAnimation(false);
			return;
		}
	}

	void stopAnimation()
	{
		if (!bAnimate || silImages.length <= 1)
			return;
		bAnimate = false;
		if (tTimer != null && tTimer.isRunning())
			tTimer.stop();
	}

	void showAnimeController(JComponent jcomponent, Point point)
	{
		V2CAnimationController.showController(this, jcomponent, point);
	}

	void controlGIFAnimation(String s)
	{
		V2CWebpAnimation.controllStatus(s);
		
		if (s == null || silImages.length <= 1)
			return;
		if (s.equals("NormalPlay")) {
			iRateIndex = 0;
			startAnimation();
		}
		else if (s.equals("NextFrame")) {
			stopAnimation();
			paintNextFrame();
		}
		else if (s.equals("Stop"))
			stopAnimation();
		else if (s.equals("FastPlay")) {
			stopAnimation();
			iRateIndex++;
			startAnimation();
		}
	}

	void drawScaledAndCentered(Graphics2D graphics2d, int i, int j, boolean flag)
	{
		int k = nWidth;
		int l = nHeight;
		if (k <= 0 || l <= 0)
			return;
		double d = Math.min((double) i / (double) k, (double) j / (double) l);
		if (!flag && d > 1.0D)
			d = 0.0D;
		int i1;
		int j1;
		if (flag || d > 0.0D) {
			i1 = (int) (d * (double) k);
			j1 = (int) (d * (double) l);
		}
		else {
			i1 = k;
			j1 = l;
		}
		int k1 = (i - i1) / 2;
		int l1 = (j - j1) / 2;
		draw(graphics2d, k1, l1, d);
	}

	void draw(Graphics2D graphics2d)
	{
		draw(graphics2d, 0, 0, 0.0D);
	}

	void draw(Graphics2D graphics2d, int i, int j)
	{
		draw(graphics2d, i, j, 0.0D);
	}

	void draw(Graphics2D graphics2d, int i, int j, double d)
	{
		V2CSingleImage av2csingleimage[] = silImages;
		if (av2csingleimage == null)
			return;
		if (!bBufferChecked)
			createBuffer();
		rescheduleAnimation(nDrawIndex == av2csingleimage.length - 1);
		int k = nDrawIndex;
		V2CSingleImage v2csingleimage = av2csingleimage[k];
		if (v2csingleimage == null)
			return;
		if (iBuffer != null) {
			boolean flag = k != nLastDrawIndex;
			if (v2csingleimage.restoreToPrev()) {
				if (d > 0.0D && d != 1.0D)
					graphics2d.drawImage(iBuffer, i, j, (int) (d * (double) nWidth), (int) (d * (double) nHeight), null);
				else
					graphics2d.drawImage(iBuffer, i, j, null);
				v2csingleimage.draw(graphics2d, i, j, d);
			}
			else {
				if (flag) {
					Graphics2D graphics2d1 = (Graphics2D) iBuffer.getGraphics();
					if (iClearIndex >= 0)
						silImages[iClearIndex].clearRect(graphics2d1, 0, 0, 0.0D, cBackground);
					else if (nDrawIndex == 0 && v2csingleimage.isBGVisible(nWidth, nHeight))
						clearRect(graphics2d1, 0, 0, 0.0D);
					v2csingleimage.draw(graphics2d1, 0, 0, 0.0D);
					graphics2d1.dispose();
					graphics2d1 = null;
				}
				if (d > 0.0D && d != 1.0D)
					graphics2d.drawImage(iBuffer, i, j, (int) (d * (double) nWidth), (int) (d * (double) nHeight), null);
				else
					graphics2d.drawImage(iBuffer, i, j, null);
			}
			nLastDrawIndex = k;
		}
		else {
			if (iClearIndex >= 0)
				silImages[iClearIndex].clearRect(graphics2d, i, j, d, cBackground);
			else if (bAlwaysClear)
				clearRect(graphics2d, i, j, d);
			v2csingleimage.draw(graphics2d, i, j, d);
		}
		v2csingleimage = null;
	}

	void nextFrame()
	{
		if (silImages.length > 1) {
			int i = nDrawIndex;
			V2CSingleImage v2csingleimage = silImages[i];
			if (v2csingleimage != null && v2csingleimage.shouldClear())
				iClearIndex = i;
			else
				iClearIndex = -1;
			nDrawIndex = (i + 1) % silImages.length;
			V2CAnimationController.displayIndexChanged(this, nDrawIndex);
			v2csingleimage = null;
		}
	}

	void rescheduleAnimation(boolean flag)
	{
		if (!bAnimate || silImages.length <= 1)
			return;
		if (tTimer == null) {
			tTimer = new Timer(0, this);
			tTimer.setRepeats(false);
		}
		if (tTimer.isRunning())
			return;
		int i = iRateIndex;
		final int nd;
		if (i <= 0) {
			V2CSingleImage v2csingleimage = silImages[nDrawIndex];
			nd = v2csingleimage == null ? 250 : v2csingleimage.getDelayTime();
			v2csingleimage = null;
		}
		else if (i == 1)
			nd = 250;
		else if (i == 2)
			nd = 125;
		else if (i == 3)
			nd = 60;
		else
			nd = 30;
		if (flag && V2CApp.isUNIX()) {
			EventQueue.invokeLater(new Runnable() {

				public void run()
				{
					Toolkit.getDefaultToolkit().sync();
					tTimer.setInitialDelay(nd);
					tTimer.start();
				}
			});
		}
		else {
			tTimer.setInitialDelay(nd);
			tTimer.start();
		}
	}

	void clearRect(Graphics g, int i, int j, double d)
	{
		g.setColor(cBackground);
		if (d > 0.0D && d != 1.0D)
			g.fillRect(i, j, (int) (d * (double) nWidth), (int) (d * (double) nHeight));
		else
			g.fillRect(i, j, nWidth, nHeight);
	}

	public void actionPerformed(ActionEvent actionevent)
	{
		paintNextFrame();
	}

	void paintNextFrame()
	{
		nextFrame();
		if (V2CLink.bStopRedrawThumbnail)
			return;
		V2CImagePopup.imageUpdated(this);
		V2CImagePanel.imageUpdated(this);
		V2CMain.vtpDisplayPane.imageThumbnailUpdated(this);
		V2CMain.vtpTablePane.imageThumbnailUpdated(this);
		V2CLink.ThumbnailPanel thumbnailpanel = V2CLink.jcThumbnailPanel;
		if (thumbnailpanel != null)
			thumbnailpanel.imageThumbnailUpdated(this);
		if (V2CLink.bSlideShowPanelShown) {
			V2CSlideShowPanel v2cslideshowpanel = V2CSlideShowPanel.getInstance();
			if (v2cslideshowpanel != null)
				v2cslideshowpanel.imageThumbnailUpdated(this);
		}
		if (V2CLink.bImageViewerShown) {
			V2CImageViewer v2cimageviewer = V2CImageViewer.getInstance();
			if (v2cimageviewer != null)
				v2cimageviewer.imageUpdated(this);
		}
	}

	void extractGIFInfo(Node node)
	{
		NodeList nodelist = node.getChildNodes();
		if (nodelist == null)
			return;
		byte byte0 = -1;
		int j = nodelist.getLength();
		for (int k = 0; k < j; k++) {
			Node node1 = nodelist.item(k);
			String s = node1.getNodeName();
			if (s == null)
				continue;
			NamedNodeMap namednodemap = node1.getAttributes();
			if (s.equals("LogicalScreenDescriptor")) {
				Node node2 = namednodemap.getNamedItem("logicalScreenWidth");
				if (node2 != null)
					try {
						nWidth = Integer.parseInt(node2.getNodeValue());
					}
					catch (NumberFormatException numberformatexception) {
					}
				node2 = namednodemap.getNamedItem("logicalScreenHeight");
				if (node2 == null)
					continue;
				try {
					nHeight = Integer.parseInt(node2.getNodeValue());
				}
				catch (NumberFormatException numberformatexception1) {
				}
				node2 = null;
				continue;
			}
			if (!s.equals("GlobalColorTable"))
				continue;
			Node node3 = namednodemap.getNamedItem("backgroundColorIndex");
			if (node3 == null)
				continue;
			int i;
			try {
				i = Integer.parseInt(node3.getNodeValue());
			}
			catch (NumberFormatException numberformatexception2) {
				continue;
			}
			extractGIFBGColorInfo(node1, i);
			node1 = null;
			node3 = null;
			namednodemap = null;
		}

	}

	void extractGIFBGColorInfo(Node node, int i)
	{
		NodeList nodelist = node.getChildNodes();
		if (nodelist == null)
			return;
		int j = nodelist.getLength();
		for (int k = 0; k < j; k++) {
			Node node1 = nodelist.item(k);
			NamedNodeMap namednodemap = node1.getAttributes();
			int l = -1;
			Node node2 = namednodemap.getNamedItem("index");
			if (node2 != null)
				try {
					l = Integer.parseInt(node2.getNodeValue());
				}
				catch (NumberFormatException numberformatexception) {
				}
			if (l != i)
				continue;
			int i1 = 204;
			int j1 = 204;
			int k1 = 204;
			node2 = namednodemap.getNamedItem("red");
			if (node2 != null)
				try {
					i1 = Integer.parseInt(node2.getNodeValue());
				}
				catch (NumberFormatException numberformatexception1) {
				}
			node2 = namednodemap.getNamedItem("green");
			if (node2 != null)
				try {
					j1 = Integer.parseInt(node2.getNodeValue());
				}
				catch (NumberFormatException numberformatexception2) {
				}
			node2 = namednodemap.getNamedItem("blue");
			if (node2 != null)
				try {
					k1 = Integer.parseInt(node2.getNodeValue());
				}
				catch (NumberFormatException numberformatexception3) {
				}
			cBackground = new Color(i1, j1, k1);
			node1 = null;
			node2 = null;
			namednodemap = null;
		}

	}

	void cacheThumbnailImage(File file, int i, int j)
	{
		if (file == null || getImageCount() != 1 || sFormatName == null)
			return;
		boolean flag = i == nWidth && j == nHeight;
		Image image = silImages[0].getImage();
		if (!flag && !(image instanceof BufferedImage))
			return;
		if (file.exists()) {
			file.delete();
		}
		else {
			File file1 = file.getParentFile();
			if (file1 != null && !file1.isDirectory())
				file1.mkdirs();
		}
		if (flag) {
			byte abyte0[] = new byte[4];
			if (i > 65535)
				i = 65535;
			if (j > 65535)
				j = 65535;
			abyte0[0] = (byte) (i >>> 8);
			abyte0[1] = (byte) i;
			abyte0[2] = (byte) (j >>> 8);
			abyte0[3] = (byte) j;
			if (!V2CLocalFileHandler.saveToFile(file, abyte0) && file.exists())
				file.delete();
		}
		else {
			V2CLocalFileHandler.saveThumbnail(file, (BufferedImage) image);
		}
		image = null;
	}

	private static final int FORMAT_UNKNOWN = 0;
	private static final int FORMAT_JPEG = 1;
	private static final int FORMAT_PNG = 2;
	private static final int FORMAT_GIF = 3;
	private static final boolean bPrintNodeInfo = false;
	private static final boolean bPrintDebugInfo = false;
	static final Color cDefaultBackground = new Color(204, 204, 204);
	V2CSingleImage silImages[];
	String sFormatName;
	int nFormat;
	int nFileSize;
	Image iBuffer;
	ImageReader vJFIFImageReader;
	boolean bNeedsBuffer;
	private boolean bBufferChecked;
	boolean bAlwaysClear;
	int nWidth;
	int nHeight;
	int nRotation;
	boolean bMirror;
	int nBlockSize;
	int nOriginalWidth;
	int nOriginalHeight;
	Color cBackground;
	boolean bDrawBG;
	int nDrawIndex;
	int nLastDrawIndex;
	int iClearIndex;
	Timer tTimer;
	boolean bAnimate;
	int iRateIndex;
	volatile boolean bThumbnailCreating;
	String sCaptionEx;
	String sCaption;
	boolean bSizeLimitExceeded;
	boolean bOK;
	String sErrorMessage;
	File fOriginalFile;
	static final int MIN_BLOCKSIZE = 4;
	static final int DEF_BLOCKSIZE = 16;

}
