package org.monazilla.v2c;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.HashSet;
import java.util.Iterator;

import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;

public class V2CImagePopup extends V2CAbstractImagePanel implements V2CPopupPanel, ActionListener
{
	private class PopupMouseListener extends V2CAbstractImagePanel.ImageMouseListener
	{

		void dragAction(MouseEvent mouseevent, int i, int j)
		{
			if (bDragWindow) {
				Rectangle rectangle = jwPopupWindow.getBounds();
				int k = rectangle.x + i;
				int l = rectangle.y + j;
				if (rScreenBounds == null)
					return;
				if (k < rScreenBounds.x + 1)
					k = rScreenBounds.x + 1;
				else if (k + rectangle.width > (rScreenBounds.x + rScreenBounds.width) - 1)
					k = (rScreenBounds.x + rScreenBounds.width) - rectangle.width - 1;
				if (l < rScreenBounds.y + 1)
					l = rScreenBounds.y + 1;
				else if (l + rectangle.height > (rScreenBounds.y + rScreenBounds.height) - 1)
					l = (rScreenBounds.y + rScreenBounds.height) - rectangle.height - 1;
				if (k == rectangle.x && l == rectangle.y)
					return;
				jwPopupWindow.setLocation(k, l);
			}
			else if (iResizeWindow != 0) {
				JScrollPane jscrollpane = jScrollPane;
				Point point = mouseevent.getPoint();
				if (bZoomFollowWindowSize) {
					Insets insets = jscrollpane.getInsets();
					Point point1 = SwingUtilities.convertPoint(mouseevent.getComponent(), point.x, point.y, jscrollpane);
					int i1 = jscrollpane.getWidth() - insets.left - insets.right;
					int j1 = jscrollpane.getHeight() - insets.top - insets.bottom;
					if (iResizeWindow == 3) {
						i = (point1.x + nDX) - jscrollpane.getWidth();
						j = (point1.y + nDY) - jscrollpane.getHeight();
						double d = (double) Math.max(i1 + i, 20) / (double) i1;
						double d1 = (double) Math.max(j1 + j, 20) / (double) j1;
						double d2 = Math.min(d, d1);
						nSize = 10;
						dScale *= d2;
						resizePanel(false);
						repaint();
					}
				}
				else {
					Rectangle rectangle1 = rWindowRect;
					Rectangle rectangle2 = jwPopupWindow.getBounds();
					SwingUtilities.convertPointToScreen(point, mouseevent.getComponent());
					Rectangle rectangle3 = rScreenBounds;
					if (rectangle3 == null)
						rectangle3 = V2CSwingUtil.getScreenBoundsAt(point);
					int k1;
					int l1;
					int i2;
					int j2;
					if (iResizeWindow == 1) {
						k1 = Math.max(point.x - nDX, rectangle3.x + 1);
						l1 = Math.max(point.y - nDY, rectangle3.y + 1);
						i2 = Math.max((rectangle1.x + rectangle1.width) - k1, 20);
						j2 = Math.max((rectangle1.y + rectangle1.height) - l1, 20);
					}
					else if (iResizeWindow == 2) {
						k1 = Math.max(point.x - nDX, rectangle3.x + 1);
						l1 = rectangle1.y;
						i2 = Math.max((rectangle1.x + rectangle1.width) - k1, 20);
						j2 = Math.max((point.y + nDY) - l1, 20);
					}
					else if (iResizeWindow == 3) {
						k1 = rectangle1.x;
						l1 = rectangle1.y;
						i2 = Math.max((point.x + nDX) - k1, 20);
						j2 = Math.max((point.y + nDY) - l1, 20);
					}
					else if (iResizeWindow == 4) {
						k1 = rectangle1.x;
						l1 = Math.max(point.y - nDY, rectangle3.y + 1);
						i2 = Math.max((point.x + nDX) - k1, 20);
						j2 = Math.max((rectangle1.y + rectangle1.height) - l1, 20);
					}
					else {
						return;
					}
					nSize = 10;
					jwPopupWindow.setBounds(k1, l1, i2, j2);
					jwPopupWindow.invalidate();
					jwPopupWindow.validate();
					Dimension dimension = jscrollpane.getViewport().getSize();
					double d3 = (double) dimension.width / (dScale * (double) nDispWidth);
					double d4 = (double) dimension.height / (dScale * (double) nDispHeight);
					double d5 = Math.max(d3, d4);
					if (d5 > 1.0D) {
						dScale *= d5;
						nViewWidth = (int) (dScale * (double) nDispWidth);
						nViewHeight = (int) (dScale * (double) nDispHeight);
						Dimension dimension1 = new Dimension(nViewWidth, nViewHeight);
						setPreferredSize(dimension1);
						setSize(dimension1);
						repaint();
					}
				}
			}
			else {
				super.dragAction(mouseevent, i, j);
			}
		}

		public void mouseMoved(MouseEvent mouseevent)
		{
			if (!bCloseOnMouseMove || vipParent == null) {
				return;
			}
			else {
				Point point = mouseevent.getPoint();
				SwingUtilities.convertPointToScreen(point, mouseevent.getComponent());
				vipParent.mouseMoved(V2CImagePopup.this, point);
				return;
			}
		}

		public void mouseClicked(MouseEvent mouseevent)
		{
			if (bIgnoreClick) {
				bIgnoreClick = false;
				return;
			}
			if (!V2CSwingUtil.isSimpleClick(mouseevent))
				return;
			boolean flag = findComponentAt(mouseevent.getPoint()) == jlStopButton;
			if (vipParent != null)
				closePopupWindow();
			else
				jwPopupWindow.toFront();
			if (flag)
				vLink.stopDownloading();
		}

		public void mouseReleased(MouseEvent mouseevent)
		{
			super.mouseReleased(mouseevent);
			if (bDragged && bIgnoreClick)
				bIgnoreClick = false;
		}

		public void mousePressed(MouseEvent mouseevent)
		{
			if (bCloseOnMouseMove) {
				bIgnoreClick = true;
				bCloseOnMouseMove = false;
			}
			bDragWindow = false;
			super.mousePressed(mouseevent);
			if (!mouseevent.isConsumed() && V2CSwingUtil.isSimpleClick(mouseevent)) {
				rWindowRect = jwPopupWindow.getBounds();
				Rectangle rectangle = getVisibleRect();
				Point point = mouseevent.getPoint();
				Rectangle rectangle1 = jScrollPane.getBounds();
				Point point1 = SwingUtilities.convertPoint(mouseevent.getComponent(), point.x, point.y, jScrollPane);
				int i = rectangle.width;
				int j = rectangle.height;
				int k = Math.min(20, i / 4);
				int l = Math.min(20, j / 4);
				int i1 = rectangle.x + k;
				int j1 = (rectangle.x + i) - k;
				int k1 = 0;
				if (point.y <= rectangle.y + l) {
					if (point.x <= i1) {
						k1 = 1;
						nDX = point1.x;
						nDY = point1.y;
					}
					else if (point.x >= j1) {
						k1 = 4;
						nDX = rectangle1.width - point1.x;
						nDY = point1.y;
					}
				}
				else if (point.y >= (rectangle.y + rectangle.height) - l)
					if (point.x <= i1) {
						k1 = 2;
						nDX = point1.x;
						nDY = rectangle1.height - point1.y;
					}
					else if (point.x >= j1) {
						k1 = 3;
						nDX = rectangle1.width - point1.x;
						nDY = rectangle1.height - point1.y;
					}
				iResizeWindow = k1;
				boolean flag = !jScrollPane.getVerticalScrollBar().isShowing()
						&& !jScrollPane.getHorizontalScrollBar().isShowing();
				bZoomFollowWindowSize = flag && k1 == 3;
				if (k1 == 0)
					if (flag)
						bDragWindow = true;
					else
						bDragWindow = point.x < rectangle.x + k || point.x > (rectangle.x + rectangle.width) - k
								|| point.y < rectangle.y + l || point.y > (rectangle.y + rectangle.height) - l;
			}
		}

		int nDX;
		int nDY;
		Rectangle rWindowRect;
		boolean bZoomFollowWindowSize;
		boolean bDragWindow;
		boolean bIgnoreClick;

		PopupMouseListener()
		{
			//super(V2CImagePopup.this, "ImagePopup");
			super("ImagePopup");
		}
	}

	static V2CImagePopup getCurrentImagePopup()
	{
		Object obj = null;
		Reference reference = refCurrentImagePopup;
		return reference == null ? null : (V2CImagePopup) reference.get();
	}

	static void notifyDownloadCompleted(V2CLink v2clink)
	{
		V2CImagePopup v2cimagepopup = getCurrentImagePopup();
		if (v2cimagepopup != null)
			v2cimagepopup.downloadCompleted(v2clink);
	}

	static void imageUpdated(V2CImageSet v2cimageset)
	{
		V2CImagePopup v2cimagepopup = getCurrentImagePopup();
		if (v2cimagepopup != null && v2cimagepopup.vImageSet == v2cimageset)
			v2cimagepopup.repaint();
		Iterator iterator = hsOpenPopups.iterator();
		do {
			if (!iterator.hasNext())
				break;
			V2CImagePopup v2cimagepopup1 = (V2CImagePopup) iterator.next();
			if (v2cimagepopup1.vImageSet == v2cimageset)
				v2cimagepopup1.repaint();
		} while (true);
	}

	static void setAllOpenPopupsVisibility(boolean flag)
	{
		V2CImagePopup v2cimagepopup;
		for (Iterator iterator = hsOpenPopups.iterator(); iterator.hasNext(); v2cimagepopup.jwPopupWindow.setVisible(flag)){
			if(flag) ((V2CImagePopup) iterator).jwPopupWindow.toFront();
			v2cimagepopup = (V2CImagePopup) iterator.next();
		}

	}

	static String createErrorText(String s)
	{
		String s1 = "画像エラー：";
		if (s != null) {
			if (s.equals("OutOfMemoryError: Java heap space")) {
				StringBuffer stringbuffer = new StringBuffer(s1);
				stringbuffer.append(" 割り当てメモリ不足\n");
				if (V2CLauncher.startedByLauncher())
					stringbuffer
							.append("「設定」メニューの「ランチャーの設定」で\n");
				stringbuffer
						.append("メモリ使用量の上限を増やしてみてください。");
				return stringbuffer.toString();
			}
			else {
				return s1 + '\n' + s;
			}
		}
		else {
			return s1 + " （原因不明）";
		}
	}

	static V2CPopupPanel popupImage(V2CImagePopupParent v2cimagepopupparent, V2CLink v2clink, Point point)
	{
		return popupImage(v2cimagepopupparent, v2clink, point, 0);
	}

	static V2CPopupPanel popupImage(V2CImagePopupParent v2cimagepopupparent, V2CLink v2clink, Point point, boolean flag)
	{
		return popupImage(v2cimagepopupparent, v2clink, point, getScaleFromShiftState(flag));
	}

	static V2CPopupPanel popupImage(V2CImagePopupParent v2cimagepopupparent, V2CLink v2clink, Point point, int i)
	{
		closeVolatilePopup();
		V2CImageSet v2cimageset = v2clink.getLocalImage();
		if (v2cimageset != null && v2cimageset.isSizeLimitExceeded()) {
			int j = V2CLink.nMaxLoadImageSize;
			if (j <= 0)
				j = 30000;
			int k = V2CLink.nMaxLoadImageArea;
			int l = v2cimageset.getWidth();
			int i1 = v2cimageset.getHeight();
			if (l <= j && i1 <= j && (k <= 0 || l * i1 <= k)) {
				v2clink.clearThumbnail(true);
				v2clink.clearImage();
				v2cimageset = null;
			}
		}
		v2cwebpanimation = null;
		if (v2cimageset == null || v2cimageset.isOK()) {
			if(V2CHttpUtil.webpAnimHQ && V2CGetContainerOfAnimTools.anim_dump_exists()){
				String id = v2clink.getImageFile().getName().replaceAll("\\.webp$", "");
				String digit = id.substring(0, 1);
				File tmpDir = new File(V2CLocalFileHandler.v2cDir, "tmp");
				if(V2CHttpUtil.CreateMovieThumb && (new File(tmpDir, "/webp/" + digit + "/" + id)).exists()){
					if((new File(tmpDir, "/webp/" + digit + "/" + id + "/dump.zip")).exists()){
						v2cwebpanimation = new V2CWebpAnimation(v2clink);
					}else{
						V2CTextPopup2 v2ctextpopup2 = new V2CTextPopup2(V2CWebpAnimation.wait_message, point,
								(Component) v2cimagepopupparent);
						v2ctextpopup2.showPopup();
						return v2ctextpopup2;
					}
				}
			}else{
				if(V2CWebpANIMReader.isWebpANIM(v2clink.getImageFile())){
					if(V2CHttpUtil.CreateMovieThumb){
						v2cwebpanimation = new V2CWebpAnimation(v2clink);
					}
				}
			}
			return new V2CImagePopup(v2cimagepopupparent, v2clink, point, i);
		}
		else {
			v2clink.createThumbnailBG(false);
			V2CTextPopup2 v2ctextpopup2 = new V2CTextPopup2(createErrorText(v2cimageset.getErrorMessage()), point,
					(Component) v2cimagepopupparent);
			v2ctextpopup2.showPopup();
			return v2ctextpopup2;
		}
	}

	static void closeVolatilePopup()
	{
		V2CImagePopup v2cimagepopup = getCurrentImagePopup();
		if (v2cimagepopup != null)
			v2cimagepopup.closePopupWindow();
	}

	private V2CImagePopup(V2CImagePopupParent v2cimagepopupparent, V2CLink v2clink, Point point, int i)
	{
		super(v2clink, i);
		V2CInputMap v2cinputmap = V2CInputMap.getInputMap("ImagePopup");
		bPopup = true;
		vipParent = v2cimagepopupparent;
		bFocusRequested = true;
		pInitialPoint = point;
		PopupMouseListener popupmouselistener = new PopupMouseListener();
		addMouseListener(popupmouselistener);
		addMouseMotionListener(popupmouselistener);
		Object obj = null;
		if (v2cimagepopupparent instanceof Component) {
			Window window = SwingUtilities.getWindowAncestor((Component) v2cimagepopupparent);
			if (window != null) {
				Window window1 = window.getOwner();
				if (window1 instanceof JFrame)
					obj = (JFrame) window1;
			}
		}
		if (obj == null)
			obj = V2CMain.v2cMain;
		if (V2CMain.getUseJDialogForPopup()) {
			JDialog jdialog = new JDialog(((java.awt.Frame) (obj)), false);
			jwPopupWindow = jdialog;
			jdialog.setUndecorated(true);
			jdialog.setContentPane(jScrollPane);
			requestFocusInWindow();
		}
		else {
			JWindow jwindow = new JWindow(((java.awt.Frame) (obj)));
			jwPopupWindow = jwindow;
			jwindow.setFocusableWindowState(true);
			jwindow.addWindowListener(new WindowAdapter() {

				public void windowOpened(WindowEvent windowevent)
				{
					requestFocus();
				}
			});
			jwindow.setContentPane(jScrollPane);
		}
		if (vImageSet != null) {
			if (!vImageSet.isOK() && v2cwebpanimation == null)
				return;
			if(vImageSet.isOK())
				bNeedsUpdate = vImageSet.needsUpdate();
		}
		jwPopupWindow.setLocation(point);
		if (vImageSet != null) {
			bResized = true;
			if(v2cwebpanimation != null){
				jLabel = new JLabel();
				jLabel.setOpaque(true);
				v2cwebpanimation.setFirst(this, jLabel);
				nWidth = v2cwebpanimation.getWidth();
				nHeight = v2cwebpanimation.getHeight();
				nDispWidth = v2cwebpanimation.getDispWidth();
				nDispHeight = v2cwebpanimation.getDispHeight();
			}

			resizeWindow(false);
			if(v2cwebpanimation != null){
				v2cwebpanimation.resetFirst(this, jLabel);
			}
			jwPopupWindow.setVisible(true);
			jwPopupWindow.toFront();

			if(v2cwebpanimation != null){
				v2cwebpanimation.play(this, jLabel, Integer.MAX_VALUE);
			}
		}
		else {
			jwPopupWindow.setVisible(true);
			jwPopupWindow.toFront();
			setLayout(new GridBagLayout());
			GridBagConstraints gridbagconstraints = new GridBagConstraints();
			gridbagconstraints.gridx = 0;
			gridbagconstraints.gridy = 0;
			gridbagconstraints.fill = 2;
			gridbagconstraints.insets = new Insets(2, 2, 2, 2);
			jLabel = new JLabel("               ");
			jLabel.setHorizontalAlignment(0);
			gridbagconstraints.gridwidth = 2;
			add(jLabel, gridbagconstraints);
			gridbagconstraints.gridwidth = 1;
			gridbagconstraints.gridy++;
			jProgressBar = new JProgressBar(0, 100);
			jProgressBar.setStringPainted(true);
			add(jProgressBar, gridbagconstraints);
			gridbagconstraints.gridx++;
			gridbagconstraints.insets = new Insets(2, 0, 2, 2);
			jlStopButton = new JLabel(icStop);
			add(jlStopButton, gridbagconstraints);
			jScrollPane.setHorizontalScrollBarPolicy(31);
			jScrollPane.setVerticalScrollBarPolicy(21);
			jwPopupWindow.pack();
			vLink.setLoadingStatus(jLabel, jProgressBar);
			tTimer = new Timer(200, this);
			tTimer.start();
		}
		refCurrentImagePopup = new SoftReference(this);
	}

	public boolean needsScrollPane()
	{
		return false;
	}

	public boolean isCloseOnExit()
	{
		return bCloseOnMouseMove;
	}

	public void closePopupWindow()
	{
		if(v2cwebpanimation != null){
			v2cwebpanimation.stopPlay();
			v2cwebpanimation = null;
		}
		if (bCloseOnMouseMove)
			bCloseOnMouseMove = false;
		if (vipParent != null) {
			V2CImagePopupParent v2cimagepopupparent = vipParent;
			vipParent = null;
			if (v2cimagepopupparent.requestClosePopup(this))
				return;
		}
		if (tTimer != null && tTimer.isRunning())
			tTimer.stop();
		bNeedsUpdate = false;
		jwPopupWindow.dispose();
		if (getCurrentImagePopup() == this)
			refCurrentImagePopup = null;
		hsOpenPopups.remove(this);
		if (vImageSet != null)
			V2CAnimationController.imagePopupClosed(vImageSet);
		if (V2CApp.isMacintosh() && V2CApp.javaVersionEqualOrGreaterThan(1, 6)) {
			jScrollPane.setViewportView(null);
			V2CSwingUtil.setContentPane(jwPopupWindow, new JPanel());
		}
	}

	void detouchImagePopup()
	{
		if (vipParent != null) {
			vipParent.imagePopupDetouched(this);
			vipParent = null;
			hsOpenPopups.add(this);
			if (getCurrentImagePopup() == this)
				refCurrentImagePopup = null;
		}
	}

	Point getWindowLocation()
	{
		return jwPopupWindow.getLocation();
	}

	V2CPopupPanel showErrorText(String s)
	{
		closePopupWindow();
		V2CTextPopup2 v2ctextpopup2 = new V2CTextPopup2(createErrorText(s), getWindowLocation(), this);
		v2ctextpopup2.showPopup();
		return v2ctextpopup2;
	}

	public void actionPerformed(ActionEvent actionevent)
	{
		V2CImageSet v2cimageset = vLink.getLocalImage();
		vImageSet = v2cimageset;
		if (v2cimageset == null) {
			if (!vLink.isChecking() && !vLink.hasImageCache())
				closePopupWindow();
			else if (jLabel != null) {
				long l = System.currentTimeMillis();
				if (l > ltLastUpdate + 250L) {
					ltLastUpdate = l;
					vLink.setLoadingStatus(jLabel, jProgressBar);
					repaint();
				}
			}
			return;
		}
		tTimer.stop();
		if (!v2cimageset.isOK()) {
			if (vipParent != null)
				vipParent.imageError(v2cimageset.getErrorMessage());
			return;
		}
		else {
			remove(jProgressBar);
			remove(jLabel);
			remove(jlStopButton);
			setLayout(null);
			bNeedsUpdate = v2cimageset.needsUpdate();
			nDispWidth = nWidth = v2cimageset.getWidth();
			nDispHeight = nHeight = v2cimageset.getHeight();
			bResized = true;
			//SwingUtilities.invokeLater(new V2CAbstractImagePanel.PanelResizer(this));
			SwingUtilities.invokeLater(this.new PanelResizer());
			return;
		}
	}

	void downloadCompleted(V2CLink v2clink)
	{
		if (v2clink != vLink) {
			return;
		}
		else {
			SwingUtilities.invokeLater(new Runnable() {

				public void run()
				{
					if (jLabel != null)
						jLabel.setText("done.");
					if (jProgressBar != null)
						jProgressBar.setValue(100);
				}
			});
			return;
		}
	}

	void resizePanel(boolean flag)
	{
		resizeWindow(flag);
	}

	void resizeWindow(boolean flag)
	{
		if (nWidth <= 1 || nHeight <= 1)
			return;
		bResized = true;
		bResizing = true;
		Point point = jwPopupWindow.getLocation();
		Insets insets = jwPopupWindow.getInsets();
		Rectangle rectangle = V2CSwingUtil.getScreenBoundsAt(point);
		rScreenBounds = rectangle;
		Insets insets1 = jScrollPane.getInsets();
		int i;
		int j;
		if (flag) {
			Dimension dimension = jwPopupWindow.getSize();
			i = dimension.width - insets1.left - insets1.right;
			j = dimension.height - insets1.top - insets1.bottom;
		}
		else {
			i = Math.min(nMaxWidth, rectangle.width - insets.left - insets.right - insets1.left - insets1.right - 2);
			j = Math.min(nMaxHeight, rectangle.height - insets.top - insets.bottom - insets1.top - insets1.bottom - 2);
		}
		double d = 1.0D;
		int k = nDispWidth;
		int l = nDispHeight;
		switch (nSize) {
			case 0: // '\0'
				double d1 = (double) nSmallMaxWidth / (double) k;
				double d2 = (double) nSmallMaxHeight / (double) l;
				d = Math.min(Math.min(d1, d2), 1.0D);
				break;

			case 1: // '\001'
				if (i < k || j < l)
					d = Math.min((double) i / (double) k, (double) j / (double) l);
				break;

			case 3: // '\003'
				if (i > k && j > l)
					d = Math.min((double) i / (double) k, (double) j / (double) l);
				break;

			case 4: // '\004'
				d = Math.min((double) i / (double) k, (double) j / (double) l);
				break;

			case 10: // '\n'
				d = dScale;
				break;
		}
		if (Math.abs(d - 1.0D) < 0.0001D)
			d = 1.0D;
		k = (int) (d * (double) k);
		l = (int) (d * (double) l);
		nViewWidth = k;
		nViewHeight = l;
		dScale = d;
		setPreferredSize(new Dimension(nViewWidth, nViewHeight));
		setSize(nViewWidth, nViewHeight);
		boolean flag1 = V2CApp.isGTK();
		if (flag1) {
			k += 2;
			l += 2;
		}
		int i1 = UIManager.getInt("ScrollBar.width");
		boolean flag2 = i < k;
		boolean flag3 = j < l;
		if (flag3) {
			k += i1;
			if (flag1)
				k += 2;
		}
		if (i < k)
			k = i;
		if (flag2) {
			l += i1;
			if (flag1)
				l += 2;
		}
		if (j < l)
			l = j;
		Dimension dimension1 = new Dimension(k + insets1.left + insets1.right, l + insets1.top + insets1.bottom);
		jScrollPane.setPreferredSize(dimension1);
		jScrollPane.setHorizontalScrollBarPolicy(30);
		jScrollPane.setVerticalScrollBarPolicy(20);
		if (bAlwaysCenter || nSize == 3) {
			centerImagePopup(point, rectangle, dimension1);
		}
		else {
			int j1 = (int) point.getX();
			int k1 = (int) point.getY();
			int l1 = (int) dimension1.getWidth();
			int i2 = (int) dimension1.getHeight();
			boolean flag4 = false;
			if (pInitialPoint != null) {
				flag4 = true;
				k1 = Math.max((pInitialPoint.y - i2) + 1, rectangle.y + 1);
				pInitialPoint = null;
			}
			if (j1 + l1 + 2 > rectangle.x + rectangle.width) {
				flag4 = true;
				j1 = (rectangle.x + rectangle.width) - l1 - 1;
			}
			if (k1 + i2 + 2 > rectangle.y + rectangle.height) {
				flag4 = true;
				k1 = (rectangle.y + rectangle.height) - i2 - 1;
			}
			if (flag4)
				jwPopupWindow.setLocation(j1, k1);
		}
		jwPopupWindow.pack();
		bResizing = false;
	}

	void centerImagePopup()
	{
		Point point = jwPopupWindow.getLocation();
		Rectangle rectangle = V2CSwingUtil.getScreenBoundsAt(point);
		Dimension dimension = jwPopupWindow.getSize();
		centerImagePopup(point, rectangle, dimension);
	}

	void centerImagePopup(Point point, Rectangle rectangle, Dimension dimension)
	{
		int i = rectangle.x + (rectangle.width - dimension.width) / 2;
		if (i < rectangle.x)
			i = rectangle.x;
		int j = rectangle.y + (rectangle.height - dimension.height) / 2;
		if (j < rectangle.y)
			j = rectangle.y;
		if (i != point.x || j != point.y)
			jwPopupWindow.setLocation(i, j);
	}

	void saveImage(File file, boolean flag)
	{
		V2CThreadItem v2cthreaditem = null;
		if (vipParent != null)
			v2cthreaditem = vipParent.getThreadItem();
		saveImage(((Component) (jwPopupWindow)), file, v2cthreaditem, flag);
	}

	void showImageProperty()
	{
		if (V2CApp.isUNIX())
			jwPopupWindow.setVisible(false);
		try {
			super.showImageProperty();
		}
		finally {
			if (V2CApp.isUNIX()){
				jwPopupWindow.setVisible(true);
				jwPopupWindow.toFront();
			}
		}
	}

	void showNextImage(boolean flag)
	{
		if (vipParent != null)
			vipParent.popupNextImage(flag);
	}

	void disableLink()
	{
		if (!imageLoaded()) {
			return;
		}
		else {
			closePopupWindow();
			vLink.disable();
			return;
		}
	}

	void deleteLinkCache()
	{
		if (!imageLoaded()) {
			return;
		}
		else {
			closePopupWindow();
			vLink.deleteHistory();
			return;
		}
	}

	void addToNGFile(boolean flag, ActionEvent actionevent)
	{
		if (!imageLoaded())
			return;
		Window window = jwPopupWindow;
		boolean flag1 = V2CApp.isUNIX() && (window instanceof JWindow);
		if (flag1)
			window.setVisible(false);
		String s;
		if (flag) {
			s = "";
		}
		else {
			try {
				s = V2CNGFileItem.getInputComment();
			}
			finally {
				if (flag1){
					window.setVisible(true);
					window.toFront();
				}
			}
			if (s == null)
				return;
		}
		closePopupWindow();
		vLink.addToNGFile(s);
	}

	void setCloseOnMouseMove()
	{
		bCloseOnMouseMove = true;
	}

	private static final int RESIZE_NONE = 0;
	private static final int RESIZE_TOPLEFT = 1;
	private static final int RESIZE_BOTTOMLEFT = 2;
	private static final int RESIZE_BOTTOMRIGHT = 3;
	private static final int RESIZE_TOPRIGHT = 4;
	static final HashSet hsOpenPopups = new HashSet();
	static Reference refCurrentImagePopup;
	Rectangle rScreenBounds;
	V2CImagePopupParent vipParent;
	Window jwPopupWindow;
	Point pInitialPoint;
	final JScrollPane jScrollPane = new JScrollPane(this);
	JLabel jLabel;
	JProgressBar jProgressBar;
	JLabel jlStopButton;
	Timer tTimer;
	int iResizeWindow;
	boolean bCloseOnMouseMove;
	
	private static V2CWebpAnimation v2cwebpanimation = null;
}
