package org.monazilla.v2c;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;

import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class V2CCustomTabbedPane extends JTabbedPane
{
	private class FixedWidthLabel extends JLabel
	{

		public Dimension getPreferredSize()
		{
			Dimension dimension = super.getPreferredSize();
			if (bUseTabComponent)
				dimension.width = nFixedTabWidth;
			return dimension;
		}

		FixedWidthLabel(String s, Icon icon, int i)
		{
			super(s, icon, i);
			setFont(getFont());
			setHorizontalAlignment(2);
		}
	}

	public V2CCustomTabbedPane(V2CSingleTabbedPane v2csingletabbedpane, int i, boolean flag, int j, int k, int l, int i1, int j1,
			int k1)
	{
		iDragTargetIndex = -1;
		vParentTabbedPane = v2csingletabbedpane;
		setTabPosition(i);
		boolean flag1 = k == 1;
		boolean flag2 = k == 2;
		boolean flag3 = !flag && flag2;
		if (flag3 && !V2CApp.javaVersionEqualOrGreaterThan(1, 6)) {
			flag3 = false;
			flag = true;
		}
		bFlatTab = flag;
		nFixedTabHeight = j;
		bLimitTitleChars = flag1;
		nMaxFullLengthTab = l;
		nMaxTitleLength = i1;
		bFixTabWidth = flag2;
		nFixedTabWidth = j1;
		nMaxFixedTabWidth = k1;
		bUseTabComponent = flag3;
		if (flag)
			updateUI();
	}

	private void setTabPosition(int i)
	{
		if (i == nTabPosition)
			return;
		nTabPosition = i;
		byte byte0;
		switch (i) {
			case 1: // '\001'
				byte0 = 2;
				break;

			case 2: // '\002'
				byte0 = 3;
				break;

			case 3: // '\003'
				byte0 = 4;
				break;

			default:
				byte0 = 1;
				break;
		}
		setTabPlacement(byte0);
	}

	void reconfigure(int i, boolean flag, int j, int k, int l, int i1, int j1, int k1)
	{
		boolean flag1 = false;
		boolean flag2 = false;
		boolean flag3 = k == 1;
		boolean flag4 = k == 2;
		boolean flag5 = !flag && flag4;
		if (flag5 && !V2CApp.javaVersionEqualOrGreaterThan(1, 6)) {
			flag5 = false;
			flag = true;
		}
		setTabPosition(i);
		if (flag5 != bUseTabComponent) {
			bUseTabComponent = flag5;
			flag2 = true;
			int l1 = getTabCount();
			if (flag5) {
				for (int i2 = 0; i2 < l1; i2++)
					V2CJSE6Util.setTabComponentAt(this, i2, createTabComponent(null, getIconAt(i2)));

			}
			else {
				for (int j2 = 0; j2 < l1; j2++)
					V2CJSE6Util.setTabComponentAt(this, j2, null);

			}
		}
		if (flag != bFlatTab) {
			bFlatTab = flag;
			flag1 = true;
		}
		if (j != nFixedTabHeight) {
			nFixedTabHeight = j;
			flag1 = true;
		}
		nMaxFullLengthTab = l;
		nMaxTitleLength = i1;
		if (flag3 || bLimitTitleChars) {
			bLimitTitleChars = flag3;
			if (flag3)
				bTruncateTitle = getTabCount() > l;
			else
				bTruncateTitle = false;
			flag2 = true;
		}
		if (flag4 != bFixTabWidth) {
			bFixTabWidth = flag4;
			flag1 = true;
		}
		if (flag4 && (j1 != nFixedTabWidth || k1 != nMaxFixedTabWidth)) {
			nFixedTabWidth = j1;
			nMaxFixedTabWidth = k1;
			flag1 = true;
		}
		if (flag2) {
			resetTabTitles();
			resetTooltips();
		}
		if (flag1)
			updateUI();
	}

	void sendChangeEventToOthers()
	{
		ChangeListener achangelistener[] = getChangeListeners();
		for (int i = 0; i < achangelistener.length; i++) {
			final ChangeListener cl = achangelistener[i];
			if (!(cl instanceof V2CTabbedPane))
				EventQueue.invokeLater(new Runnable() {

					public void run()
					{
						cl.stateChanged(new ChangeEvent(V2CCustomTabbedPane.this));
					}
				});
		}

	}

	String checkPanelTitle(String s)
	{
		if (bTruncateTitle && s.length() > nMaxTitleLength)
			s = s.substring(0, nMaxTitleLength - 1) + '\u2026';
		return s;
	}

	void manageTooltip(int i, boolean flag)
	{
		if (!flag && (!bLimitTitleChars || !bTruncateTitle) && !bFixTabWidth)
			return;
		String s = null;
		V2CPanel v2cpanel = getPanelAt(i);
		if (v2cpanel != null)
			s = v2cpanel.getTitleString();
		if (s == null)
			s = "\u540D\u79F0\u672A\u8A2D\u5B9A";
		if ((!bTruncateTitle || s.length() <= nMaxTitleLength) && !bFixTabWidth)
			s = null;
		setToolTipTextAt(i, s);
	}

	int getFixedTabHeight()
	{
		return nFixedTabHeight;
	}

	V2CPanel getPanelAt(int i)
	{
		Component component = getComponentAt(i);
		if (!(component instanceof V2CPanel))
			if (component instanceof JScrollPane) {
				component = ((JScrollPane) component).getViewport().getView();
				if (!(component instanceof V2CPanel))
					component = null;
			}
			else {
				component = null;
			}
		return (V2CPanel) component;
	}

	void checkTabCount(int i)
	{
		if (!bLimitTitleChars)
			return;
		int j = getTabCount() + i;
		boolean flag = false;
		if (bTruncateTitle) {
			if (j <= nMaxFullLengthTab) {
				bTruncateTitle = false;
				flag = true;
			}
		}
		else if (j > nMaxFullLengthTab) {
			bTruncateTitle = true;
			flag = true;
		}
		if (flag)
			resetTabTitles();
	}

	void resetTabTitles()
	{
		int i = getTabCount();
		for (int j = 0; j < i; j++) {
			V2CPanel v2cpanel = getPanelAt(j);
			if (v2cpanel != null)
				setTitleAt(j, V2CSingleTabbedPane.getPanelTitle(v2cpanel));
		}

	}

	void resetTooltips()
	{
		int i = getTabCount();
		if (i > 0) {
			for (int j = 0; j < i; j++)
				manageTooltip(j, true);

		}
	}

	public void insertTab(String s, Icon icon, Component component, String s1, int i)
	{
		checkTabCount(1);
		s = checkPanelTitle(s);
		if (bUseTabComponent) {
			super.insertTab(null, icon, component, s1, i);
			V2CJSE6Util.setTabComponentAt(this, i, createTabComponent(s, icon));
		}
		else {
			super.insertTab(s, icon, component, s1, i);
		}
		manageTooltip(i, false);
		javax.swing.plaf.TabbedPaneUI tabbedpaneui = getUI();
		if (tabbedpaneui instanceof V2CCustomTabbedPaneUI)
			((V2CCustomTabbedPaneUI) tabbedpaneui).resetTabVisibilityChecked();
	}

	public void addTab(String s, Icon icon, Component component, String s1)
	{
		checkTabCount(1);
		s = checkPanelTitle(s);
		if (bUseTabComponent) {
			super.addTab(null, icon, component, s1);
			V2CJSE6Util.setTabComponentAt(this, getTabCount() - 1, createTabComponent(s, icon));
		}
		else {
			super.addTab(s, icon, component, s1);
		}
		manageTooltip(getTabCount() - 1, false);
		javax.swing.plaf.TabbedPaneUI tabbedpaneui = getUI();
		if (tabbedpaneui instanceof V2CCustomTabbedPaneUI)
			((V2CCustomTabbedPaneUI) tabbedpaneui).resetTabVisibilityChecked();
	}

	public void addTab(String s, Icon icon, Component component)
	{
		addTab(s, icon, component, null);
	}

	public void addTab(String s, Component component)
	{
		addTab(s, null, component, null);
	}

	public void remove(Component component)
	{
		int i = getTabCount();
		super.remove(component);
		int j = getTabCount();
		if (j < i)
			checkTabCount(0);
	}

	public void remove(int i)
	{
		int j = getTabCount();
		super.remove(i);
		int k = getTabCount();
		if (k < j)
			checkTabCount(0);
	}

	public void setIconAt(int i, Icon icon)
	{
		super.setIconAt(i, icon);
		if (bUseTabComponent) {
			Component component = V2CJSE6Util.getTabComponentAt(this, i);
			if (component instanceof JLabel)
				((JLabel) component).setIcon(icon);
		}
	}

	String getRealTitleAt(int i)
	{
		V2CPanel v2cpanel = getPanelAt(i);
		return v2cpanel == null ? null : v2cpanel.getTitleString();
	}

	public void setTitleAt(int i, String s)
	{
		s = checkPanelTitle(s);
		if (bUseTabComponent) {
			Component component = V2CJSE6Util.getTabComponentAt(this, i);
			if (component instanceof JLabel)
				((JLabel) component).setText(s);
		}
		else {
			super.setTitleAt(i, s);
		}
		manageTooltip(i, true);
	}

	Component createTabComponent(String s, Icon icon)
	{
		return new FixedWidthLabel(s, icon, 4);
	}

	public void setFont(Font font)
	{
		super.setFont(font);
		if (bUseTabComponent) {
			int i = getTabCount();
			for (int j = 0; j < i; j++) {
				Component component = V2CJSE6Util.getTabComponentAt(this, j);
				if (component instanceof FixedWidthLabel)
					((FixedWidthLabel) component).setFont(font);
			}

		}
	}

	public void setForegroundAt(int i, Color color)
	{
		if(V2CDarkMode.using && V2CDarkMode.MacNative && color == null && bFlatTab){
			color = UIManager.getColor("TabbedPane.customforeground");
		}
		super.setForegroundAt(i, color);
		if (bUseTabComponent && i >= 0 && i < getTabCount()) {
			Component component = V2CJSE6Util.getTabComponentAt(this, i);
			if (component instanceof FixedWidthLabel)
				((FixedWidthLabel) component).setForeground(color);
		}
	}

	public void setTabLayoutPolicy(int i)
	{
		super.setTabLayoutPolicy(i);
		javax.swing.plaf.TabbedPaneUI tabbedpaneui = getUI();
		if (tabbedpaneui instanceof V2CCustomTabbedPaneUI)
			((V2CCustomTabbedPaneUI) tabbedpaneui).tabLayoutPolicyChanged(i);
	}

	public void doLayout()
	{
		javax.swing.plaf.TabbedPaneUI tabbedpaneui = getUI();
		V2CCustomTabbedPaneUI v2ccustomtabbedpaneui = null;
		if (tabbedpaneui instanceof V2CCustomTabbedPaneUI)
			v2ccustomtabbedpaneui = (V2CCustomTabbedPaneUI) tabbedpaneui;
		boolean flag = getTabLayoutPolicy() == 0;
		if (v2ccustomtabbedpaneui != null)
			v2ccustomtabbedpaneui.calculateTabWidth(getTabPlacement(), getTabCount(), flag);
		super.doLayout();
		if (!flag && v2ccustomtabbedpaneui != null)
			v2ccustomtabbedpaneui.adjustScrollTabButtonSize(getTabPlacement());
	}

	public void updateUI()
	{
		if (bFlatTab)
			setUI(new V2CCustomTabbedPaneUI(bFixTabWidth, nFixedTabWidth, nMaxFixedTabWidth));
		else
			super.updateUI();
	}

	void setDragTargetIndex(int i)
	{
		int j = getTabCount();
		if (i == j)
			i--;
		if (i == iDragTargetIndex)
			return;
		int k = iDragTargetIndex;
		iDragTargetIndex = i;
		if (j == 0)
			return;
		if (k >= 0) {
			Rectangle rectangle = getBoundsAt(k);
			if (rectangle != null)
				repaint(rectangle);
		}
		if (i >= 0) {
			Rectangle rectangle1 = getBoundsAt(i);
			if (rectangle1 != null)
				repaint(rectangle1);
		}
	}

	public void paint(Graphics g)
	{
		super.paint(g);
		vParentTabbedPane.paintAttributes(g);
		if (iDragTargetIndex >= 0) {
			Rectangle rectangle = getBoundsAt(iDragTargetIndex);
			if (rectangle != null) {
				g.setColor(new Color(V2CApp.isMacintosh() ? 0x404040ff : 0x40ff6347, true));
				g.fillRect(rectangle.x + 1, rectangle.y + 1, rectangle.width - 2, rectangle.height - 2);
			}
		}
	}

	private static final String UNKNOWN_TITLE = "\u540D\u79F0\u672A\u8A2D\u5B9A";
	private final V2CSingleTabbedPane vParentTabbedPane;
	int nTabPosition;
	boolean bFlatTab;
	int nFixedTabHeight;
	boolean bLimitTitleChars;
	boolean bTruncateTitle;
	int nMaxFullLengthTab;
	int nMaxTitleLength;
	boolean bFixTabWidth;
	int nFixedTabWidth;
	int nMaxFixedTabWidth;
	boolean bUseTabComponent;
	int iDragTargetIndex;
}
