package org.monazilla.v2c;
import java.awt.Desktop;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;

import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;

public class V2CAPISettings2 extends JPanel {

	private static final String UseOPPAI_Key = "2chAPI.UseOPPAI";
	private static final String UseOPPAItest_Key = "2chAPI.UseOPPAItest";
	private static final String Use5chNet_Key = "2chAPI.Use5chNet";

	JPanel jPanel;
	static JTextArea[] config = new JTextArea[1];
	static JTextField[] config2 = new JTextField[3];

	static JCheckBox UseOPPAI = new JCheckBox("おπ送りを監視する", V2CHttpUtil.apiProperty.getBoolean(UseOPPAI_Key));
	static JCheckBox UseOPPAItest = new JCheckBox("常に書きこみ時間を表示する", V2CHttpUtil.apiProperty.getBoolean(UseOPPAItest_Key));
//	static JCheckBox Use5chNet = new JCheckBox("5ch.netを使用する", V2CHttpUtil.apiProperty.getBoolean(Use5chNet_Key));

	public V2CAPISettings2() {
		this.jPanel = new JPanel(new GridBagLayout());

		GridBagConstraints constraints = V2CSwingUtil
				.createGridBagConstraints();
		JPanel oppaiConfigPanel = new JPanel(new GridBagLayout());
		oppaiConfigPanel.setBorder(new TitledBorder("おπ送り"));
		constraints.insets = new Insets(2, 7, 2, 7);

		constraints.gridx = 0;
		constraints.gridy = 0;
		oppaiConfigPanel.add(UseOPPAI, constraints);

		constraints.gridx = 0;
		constraints.gridy += 1;
		oppaiConfigPanel.add(UseOPPAItest, constraints);

		JPanel brtConfigPane2 = new JPanel(new GridBagLayout());
		brtConfigPane2.setBorder(new TitledBorder("B11バグ報告用テンプレ (読み込めない/書き込めない場合は、最初にUAを新しい物に変えてみてください)"));
		constraints.insets = new Insets(2, 7, 2, 7);

		V2CCreateBugReportTemplate v2ccreatebugreporttemplate = new V2CCreateBugReportTemplate();
		v2ccreatebugreporttemplate.main();
		v2ccreatebugreporttemplate = null;

		constraints.gridx = 0;
		constraints.gridy = 0;
		config[0] = new JTextArea(7, 50);
		config[0].setEditable(false);
		config[0].setText((String) V2CScriptApp.getProperty("?br"));
		config[0].setCaretPosition(0);
		JScrollPane jscrollpane = new JScrollPane(config[0]);
		brtConfigPane2.add(jscrollpane, constraints);

		JPanel fldrConfigPane = new JPanel(new GridBagLayout());
		if(!V2CApp.bOS2){
			fldrConfigPane.setBorder(new TitledBorder("フォルダを開く"));
			constraints.insets = new Insets(2, 7, 2, 7);

			constraints.gridx = 0;
			constraints.gridy = 0;
			JButton button1 = new JButton("保存用フォルダ");
			button1.addActionListener(new openSave());
			fldrConfigPane.add(button1, constraints);
	
			constraints.gridx++;
			constraints.gridy = 0;
			JButton button2 = new JButton("jarフォルダ(置き変えはV2Cを終了させてから)");
			button2.addActionListener(new openJar());
			fldrConfigPane.add(button2, constraints);
			
			if(!(V2CApp.isMacintosh() && V2CApp.javaVersionLessThan(1, 6))){
				constraints.gridx++;
				constraints.gridy = 0;
				JButton button3 = new JButton("script/system(" + V2CAPISettings.exp +")");
				button3.addActionListener(new openSystem());
				fldrConfigPane.add(button3, constraints);
			}
		}

//		JPanel p5chnetConfigPanel = new JPanel(new GridBagLayout());
//		p5chnetConfigPanel.setBorder(new TitledBorder("*.5ch.net"));
//		constraints.insets = new Insets(2, 7, 2, 7);
//
//		constraints.gridx = 0;
//		constraints.gridy = 0;
//		p5chnetConfigPanel.add(Use5chNet, constraints);

		JPanel jsReloadPane = new JPanel(new GridBagLayout());
		jsReloadPane.setBorder(new TitledBorder("スクリプトリロード"));
		constraints.insets = new Insets(2, 7, 2, 7);

		constraints.gridx = 0;
		constraints.gridy = 0;
		JButton button4 = new JButton("readcgi" + V2CAPISettings.exp + "とreadcgi_aux" + V2CAPISettings.exp + "をリロードする");
		button4.addActionListener(new jsReload());
		jsReloadPane.add(button4, constraints);

		JPanel OperationError = new JPanel(new GridBagLayout());
		OperationError.setBorder(new TitledBorder("不可抗力エラー対策 (複数ある場合は半角カンマで区切る、半角カンマがある場合は \\, に置き変えて登録)"));
		constraints.insets = new Insets(2, 7, 2, 7);

		constraints.gridx = 0;
		constraints.gridy = 0;
		OperationError.add(new JLabel("read.cgiモード時にitestモード発火のトリガとなるHTTPレスポンスコード："),
				constraints);
		config2[1] = new JTextField(V2CHttpUtil.OperationErrorResponseCode, 20);
		constraints.gridx = 1;
		OperationError.add(config2[1], constraints);

		constraints.gridx = 0;
		constraints.gridy = 1;
		OperationError.add(new JLabel("APIモード時に受信したdatを無視するdat内容："),
				constraints);
		config2[2] = new JTextField(V2CHttpUtil.OperationErrorDat, 20);
		constraints.gridx = 1;
		OperationError.add(config2[2], constraints);

		constraints = V2CSwingUtil.createGridBagConstraints();
		constraints.gridx = 0;
		constraints.gridy = 0;
		this.jPanel.add(oppaiConfigPanel, constraints);
		constraints.gridy++;
		this.jPanel.add(brtConfigPane2, constraints);
		if(!V2CApp.bOS2){
			constraints.gridy++;
			this.jPanel.add(fldrConfigPane, constraints);
		}
//		constraints.gridy++;
//		this.jPanel.add(p5chnetConfigPanel, constraints);
		constraints.gridy++;
		this.jPanel.add(jsReloadPane, constraints);
		constraints.gridy++;
		this.jPanel.add(OperationError, constraints);
	}

	JPanel getPanel() {
		return this.jPanel;
	}
	public static V2CProperty saveChanges(V2CProperty apiProperty) {
		apiProperty.putBoolean(UseOPPAI_Key, UseOPPAI.isSelected());
		apiProperty.putBoolean(UseOPPAItest_Key, UseOPPAItest.isSelected());
//		apiProperty.putBoolean(Use5chNet_Key, Use5chNet.isSelected());
		apiProperty.put(V2CAPISettings.OperationErrorResponseCode_Key, config2[1].getText());
		apiProperty.put(V2CAPISettings.OperationErrorDat_Key, config2[2].getText());
		V2CHttpUtil.UseOPPAI = UseOPPAI.isSelected();
		V2CHttpUtil.UseOPPAItest = UseOPPAItest.isSelected();
//		V2CHttpUtil.Use5chNet = Use5chNet.isSelected();
		V2CHttpUtil.OperationErrorResponseCode = config2[1].getText();
		V2CHttpUtil.OperationErrorResponseCodeArrayList = V2CHttpUtil.StringToArrayList("read.cgiモードでのHTTPレスポンスコード", V2CHttpUtil.OperationErrorResponseCode);
		V2CHttpUtil.OperationErrorDat = config2[2].getText();
		V2CHttpUtil.OperationErrorDatArrayList = V2CHttpUtil.StringToArrayList("不正なdat", V2CHttpUtil.OperationErrorDat.replace("\\,", "%comma%"));
		return apiProperty;
	}

	private class openSave implements ActionListener{
		public void actionPerformed(ActionEvent e){
			if(!(V2CApp.isMacintosh() && V2CApp.javaVersionLessThan(1, 6))){
				Desktop desktop = Desktop.getDesktop();
				try {
					desktop.open(V2CLocalFileHandler.v2cDir);
				} catch (IOException e1) {
					e1.printStackTrace();
				}
				desktop = null;
			}else{
				String[] Command = { "open", V2CLocalFileHandler.v2cDir.getAbsolutePath()};
				Runtime runtime = Runtime.getRuntime(); // ランタイムオブジェクトを取得する
				try {
					runtime.exec(Command); // 指定したコマンドを実行する
				} catch (IOException e1) {
					e1.printStackTrace();
				}
				runtime = null;
			}
		}
	}
	private class openJar implements ActionListener{
		public void actionPerformed(ActionEvent e){
			if(!(V2CApp.isMacintosh() && V2CApp.javaVersionLessThan(1, 6))){
				Desktop desktop = Desktop.getDesktop();
				try {
					desktop.open(V2CHttpUtil.getJarDir());
				} catch (IOException e1) {
					e1.printStackTrace();
				}
				desktop = null;
			}else{
				String[] Command = { "open", V2CHttpUtil.getJarDir().getAbsolutePath()};
				Runtime runtime = Runtime.getRuntime(); // ランタイムオブジェクトを取得する
				try {
					runtime.exec(Command); // 指定したコマンドを実行する
				} catch (IOException e1) {
					e1.printStackTrace();
				}
				runtime = null;
			}
		}
	}
	private class openSystem implements ActionListener{
		public void actionPerformed(ActionEvent e){
			Desktop desktop = Desktop.getDesktop();
			try {
				desktop.open(new File(new File(V2CLocalFileHandler.v2cDir, "script"), "system"));
			} catch (IOException e1) {
				e1.printStackTrace();
			}
			desktop = null;
		}
	}
	private class jsReload implements ActionListener{
		public void actionPerformed(ActionEvent e){
			V2CHttpUtil.eval_Script(true);
		}
	}
}
