/*    */ import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Enumeration;
/*    */ import java.util.Properties;

import javax.print.DocFlavor.URL;

import org.monazilla.v2c.V2CDarkMode;
/*    */ 
/*    */ public class V2C
/*    */ {
/*    */   public static void main(String[] as)
/*    */   {
/*  8 */     setJavaVersion();

		String jarPath = System.getProperty("java.class.path");
		String dirPath = jarPath.substring(0, jarPath.lastIndexOf(File.separator)+1);
		File v2cargs_B11 = (new File(dirPath + "v2cargs_B11.txt"));
		if(v2cargs_B11.exists()){
			BufferedReader br = null;
			String s = null;
			try {
				br = new BufferedReader(new FileReader(v2cargs_B11));
				while ((s = br.readLine()) != null) {
					break;
				}
			} catch (IOException e) {
				// TODO 自動生成された catch ブロック
				e.printStackTrace();
			} finally {
				if (br != null) {
					try {
						br.close();
					} catch (IOException e) {
						// TODO 自動生成された catch ブロック
						e.printStackTrace();
					}
				}
			}
			String[] opts = s.trim().replaceAll(" +", " ").split(" ");
			for(int i=0; i<opts.length; i++){
				if(opts[i].startsWith("-D")){
					String[] kv = opts[i].replaceAll("^-D", "").split("=");
					if(kv.length == 2){
						System.setProperty(kv[0], kv[1]);
					}
				}
			}
		}
		
		V2CDarkMode.setcolorkeys();

		File v2crelativefolder = new File(getApplicationDir("launcher"), "v2cfolder.txt");		
		if(v2crelativefolder.exists()){
			String s = null;
			boolean isAbsolute = false;
			File f = getApplicationDir("");
			BufferedReader br = null;
			try {
				br = new BufferedReader(new FileReader(v2crelativefolder));
				while ((s = br.readLine()) != null) {
					if(s.substring(0, 2).equals("##")){
						s = null;
						continue;
					}
					isAbsolute = (new File(s)).isAbsolute();
					break;
				}
			} catch (IOException e) {
				// TODO 自動生成された catch ブロック
				e.printStackTrace();
			} finally {
				if (br != null) {
					try {
						br.close();
					} catch (IOException e) {
						// TODO 自動生成された catch ブロック
						e.printStackTrace();
					}
				}
			}
			if(s != null){
				System.setProperty("v2c.directory", (!isAbsolute
														?(new File(f.getAbsolutePath(), s)).getAbsolutePath()
														:(new File(                     s)).getAbsolutePath()
													)
				);
			}
		}
/*  9 */     org.monazilla.v2c.V2CApp.startApp(as);
/*    */   }
/*    */   
/*    */   private static void setJavaVersion()
/*    */   {
/*    */     try
/*    */     {
/* 16 */       String s = System.getProperty("v2c.java.version");
/* 17 */       if ((s == null) || (s.length() < 3)) {
/* 18 */         s = System.getProperty("java.specification.version");
/*    */       }
/*    */       
/* 21 */       int[] ai = org.monazilla.v2c.V2CMiscUtil.parseDotSeparatedNumbers(s, 2);
/* 22 */       if ((ai == null) || (ai.length < 2)) {
/*    */         try {
/* 24 */           Integer intValue = Integer.valueOf(Integer.parseInt(s));
/*    */           
/* 26 */           if ((intValue.intValue() >= 7) && (intValue.intValue() <= 99)) {
/* 27 */             setJavaVersion(1, intValue.intValue());
/*    */           } else {
/* 29 */             setJavaVersion(1, 8);
/*    */           }
/*    */         }
/*    */         catch (Exception e) {
/* 33 */           System.out.println("Javaのバージョンを認識できません。Java8として扱います。");
/* 34 */           setJavaVersion(1, 8);
/*    */         }
/*    */       }
/*    */       
/*    */ 
/*    */ 
/* 40 */       return;
/*    */     }
/*    */     catch (Exception e)
/*    */     {
/* 38 */       e.printStackTrace();
/*    */     }
/*    */   }
/*    */   
/*    */ 
/*    */ 
/*    */   private static void setJavaVersion(int majorVersion, int minorVersion)
/*    */   {
/* 46 */     System.setProperty("java.specification.version", majorVersion + "." + minorVersion);
/*    */   }
/*    */   
/*    */   private static void printAllSystemProperties() {
/* 50 */     Properties props = System.getProperties();
/*    */     
/*    */ 
/* 53 */     Enumeration<String> en = (Enumeration<String>) props.propertyNames();
/* 54 */     java.util.ArrayList<String> list = new java.util.ArrayList();
/* 55 */     while (en.hasMoreElements()) {
/* 56 */       String key = (String)en.nextElement();
/* 57 */       list.add(key);
/*    */     }
/* 59 */     java.util.Collections.sort(list);
/*    */     
/* 61 */     for (String key : list) {
/* 62 */       String Property = props.getProperty(key);
/* 63 */       System.out.println("【" + key + "】" + Property);
/*    */     }
/*    */   }

	private static File getApplicationDir(String fldr)
	{
		java.net.URL url = (org.monazilla.v2c.V2CLauncher.class).getClassLoader().getResource("V2C.class");
		if (url == null)
			return null;
		String s = url.getPath();
		try {
			s = URLDecoder.decode(s, "UTF-8");
		}
		catch (UnsupportedEncodingException unsupportedencodingexception) {
			return null;
		}
		if (s == null || !s.startsWith("file:"))
			return null;
		int i = s.lastIndexOf(".jar!");
		if (i < 0)
			return null;
		String s1 = s.substring(5, i + 4);
		File file = new File(s1);
		if (!file.exists())
			return null;
		if (!file.isAbsolute()) {
			file = file.getAbsoluteFile();
			if (file == null || !file.exists())
				return null;
		}
		File fJarDir = file.getParentFile();
		if (!fJarDir.getName().equals("launcher")) {
			return null;
		}
		if(fldr.equals("launcher")){
			return fJarDir;
		}
		return fJarDir.getParentFile();
	}
/*    */
}


/* Location:              H:\__dat\V2C\jar\V2C_R20171103_p_1.1.3.jar!\V2C.class
 * Java compiler version: 7 (51.0)
 * JD-Core Version:       0.7.1
 */